/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.network.message;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.DataPackRegistriesHooks;

public class DataPackEventMessage<T> {
    public final ResourceKey<Registry<T>> resourceKey;
    public List<Pair<ResourceKey<T>, T>> data = new ArrayList<Pair<ResourceKey<T>, T>>();
    public List<CompoundTag> compoundTags = new ArrayList<CompoundTag>();
    public Codec<T> codec = null;
    private RegistryAccess registryAccess = null;

    public DataPackEventMessage(RegistryAccess registryAccess, ResourceKey<Registry<T>> resourceKey, Set<Map.Entry<ResourceKey<T>, T>> data, Codec<T> codec) {
        this.resourceKey = resourceKey;
        this.data = data.stream().map(e -> Pair.of((Object)((ResourceKey)e.getKey()), e.getValue())).toList();
        this.codec = codec;
        this.registryAccess = registryAccess;
    }

    public DataPackEventMessage(FriendlyByteBuf buf) {
        ResourceLocation resourceLocation = buf.m_130281_();
        ResourceKey registryResourceKeyTo = null;
        for (RegistryDataLoader.RegistryData syncedCustomRegistry : DataPackRegistriesHooks.getDataPackRegistries()) {
            if (syncedCustomRegistry.f_243794_().m_135782_().compareTo(resourceLocation) != 0) continue;
            registryResourceKeyTo = syncedCustomRegistry.f_243794_();
            this.codec = syncedCustomRegistry.f_244580_();
            break;
        }
        this.resourceKey = registryResourceKeyTo;
        if (this.codec != null) {
            int size = buf.m_130242_();
            for (int i = 0; i < size; ++i) {
                Tag tag;
                CompoundTag compoundTag = buf.m_130260_();
                if (compoundTag == null || (tag = compoundTag.m_128423_("value")) == null) continue;
                this.compoundTags.add(compoundTag);
            }
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.resourceKey.m_135782_());
        buf.m_130130_(this.data.size());
        RegistryOps registryops = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)this.registryAccess);
        Codec resourceKeyCodec = ResourceKey.m_195966_(this.resourceKey);
        for (Pair<ResourceKey<T>, T> datum : this.data) {
            Optional tag = this.codec.encodeStart((DynamicOps)registryops, datum.getSecond()).resultOrPartial(EclipticSeasons::logger);
            Optional k_tag = resourceKeyCodec.encodeStart((DynamicOps)registryops, (Object)((ResourceKey)datum.getFirst())).resultOrPartial(EclipticSeasons::logger);
            CompoundTag compoundTag = new CompoundTag();
            if (tag.isPresent() && k_tag.isPresent()) {
                compoundTag.m_128365_("value", (Tag)tag.get());
                compoundTag.m_128365_("key", (Tag)k_tag.get());
            }
            buf.m_130079_(compoundTag);
        }
    }

    public List<T> build(RegistryAccess clientRegistryAccess, Class<T> tClass) {
        EclipticSeasons.extraLogger(true, "Rebuild registry %s for client side.".formatted(tClass.getSimpleName()));
        ArrayList tList = new ArrayList();
        if (this.codec != null && ClientCon.getUseLevel() != null) {
            RegistryOps registryops = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)clientRegistryAccess);
            Codec resourceKeyCodec = ResourceKey.m_195966_(this.resourceKey);
            Registry registry = clientRegistryAccess.m_175515_(this.resourceKey);
            ArrayList<Pair<ResourceKey<T>, T>> pairArrayList = new ArrayList<Pair<ResourceKey<T>, T>>();
            for (CompoundTag compoundTag : this.compoundTags) {
                Optional keyOptional;
                Optional t;
                Tag tag;
                if (compoundTag == null || (tag = compoundTag.m_128423_("value")) == null || !(t = this.codec.parse((DynamicOps)registryops, (Object)tag).resultOrPartial(EclipticSeasons::logger)).isPresent()) continue;
                Object t1 = t.get();
                tList.add(t1);
                Tag k_tag = compoundTag.m_128423_("key");
                if (k_tag == null || !(keyOptional = resourceKeyCodec.parse((DynamicOps)registryops, (Object)k_tag).resultOrPartial(EclipticSeasons::logger)).isPresent()) continue;
                ResourceKey tResourceKey = (ResourceKey)keyOptional.get();
                pairArrayList.add(Pair.of((Object)tResourceKey, t1));
                if (!(registry instanceof MappedRegistry)) continue;
                MappedRegistry mappedRegistry = (MappedRegistry)registry;
                Optional holder = registry.m_203636_(tResourceKey);
                if (!holder.isPresent() || ((Holder.Reference)holder.get()).getType() == Holder.Reference.Type.INTRUSIVE) continue;
                Holder.Reference reference = (Holder.Reference)holder.get();
                Object old = reference.m_203334_();
                int oldId = mappedRegistry.f_122673_.getInt(old);
                reference.m_247654_(t1);
                mappedRegistry.f_205843_.remove(old);
                mappedRegistry.f_205843_.put(t1, reference);
                if (oldId <= -1) continue;
                mappedRegistry.f_122673_.remove(old, oldId);
                mappedRegistry.f_122673_.put(t1, oldId);
            }
            if (!(registry instanceof MappedRegistry)) {
                EclipticSeasons.logger("Error for a registry not override from MappedRegistry, which location at " + registry.getClass().getName());
            }
            this.data = pairArrayList;
        }
        EclipticSeasons.extraLogger(true, "End registry %s for client side with size %s.".formatted(tClass.getSimpleName(), tList.size()));
        return tList;
    }
}

