/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.misc;

import java.util.ArrayList;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SimpleVoxelShapeUtils {
    public static VoxelShape rotateVoxelShape(VoxelShape shape, Direction.Axis axis, float angleDegrees, Vec3 origin) {
        ArrayList<AABB> rotatedBoxes = new ArrayList<AABB>();
        for (AABB box : shape.m_83299_()) {
            rotatedBoxes.add(SimpleVoxelShapeUtils.rotateAABB(box, axis, angleDegrees, origin));
        }
        VoxelShape rotatedShape = Shapes.m_83040_();
        for (AABB box : rotatedBoxes) {
            rotatedShape = Shapes.m_83110_((VoxelShape)rotatedShape, (VoxelShape)Shapes.m_83064_((AABB)box));
        }
        return rotatedShape.m_83296_();
    }

    public static VoxelShape rotateVoxelShape(VoxelShape shape, Direction.Axis axis, float angleDegrees) {
        return SimpleVoxelShapeUtils.rotateVoxelShape(shape, axis, angleDegrees, new Vec3(0.5, 0.5, 0.5));
    }

    private static AABB rotateAABB(AABB box, Direction.Axis axis, float angleDegrees, Vec3 origin) {
        Vec3 min = SimpleVoxelShapeUtils.rotateVec(new Vec3(box.f_82288_, box.f_82289_, box.f_82290_), axis, angleDegrees, origin);
        Vec3 max = SimpleVoxelShapeUtils.rotateVec(new Vec3(box.f_82291_, box.f_82292_, box.f_82293_), axis, angleDegrees, origin);
        double minX = Math.min(min.f_82479_, max.f_82479_);
        double minY = Math.min(min.f_82480_, max.f_82480_);
        double minZ = Math.min(min.f_82481_, max.f_82481_);
        double maxX = Math.max(min.f_82479_, max.f_82479_);
        double maxY = Math.max(min.f_82480_, max.f_82480_);
        double maxZ = Math.max(min.f_82481_, max.f_82481_);
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static Vec3 rotateVec(Vec3 vec, Direction.Axis axis, float angleDegrees, Vec3 origin) {
        double x = vec.f_82479_ - origin.f_82479_;
        double y = vec.f_82480_ - origin.f_82480_;
        double z = vec.f_82481_ - origin.f_82481_;
        double radians = Math.toRadians(angleDegrees);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double rx = x;
        double ry = y;
        double rz = z;
        switch (axis) {
            case X: {
                ry = y * cos - z * sin;
                rz = y * sin + z * cos;
                break;
            }
            case Y: {
                rx = x * cos - z * sin;
                rz = x * sin + z * cos;
                break;
            }
            case Z: {
                rx = x * cos - y * sin;
                ry = x * sin + y * cos;
            }
        }
        return new Vec3(rx + origin.f_82479_, ry + origin.f_82480_, rz + origin.f_82481_);
    }
}

