/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.item;

import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.core.snow.SnowyMapChecker;
import com.teamtea.eclipticseasons.config.ClientConfig;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.loading.FMLLoader;

public class BroomItem
extends Item {
    public static final int ANIMATION_DURATION = 10;
    private static final int USE_DURATION = 200;
    private static final double MAX_DISTANCE = Math.sqrt(ServerGamePacketListenerImpl.f_215198_) - 1.0;

    public BroomItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Player player = pContext.m_43723_();
        if (player != null && this.calculateHitResult((LivingEntity)player).m_6662_() == HitResult.Type.BLOCK) {
            if (!(player instanceof FakePlayer)) {
                player.m_6672_(pContext.m_43724_());
            } else {
                FakePlayer fakePlayer = (FakePlayer)player;
                this.m_5929_(pContext.m_43725_(), (LivingEntity)fakePlayer, pContext.m_43722_(), this.m_8105_(pContext.m_43722_()) + 1 - 5);
            }
        }
        return InteractionResult.CONSUME;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BRUSH;
    }

    public int m_8105_(ItemStack pStack) {
        return 200;
    }

    public void m_5929_(Level level, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (pRemainingUseDuration >= 0) {
            HitResult hitresult = this.calculateHitResult(pLivingEntity);
            if (hitresult instanceof BlockHitResult) {
                BlockHitResult blockhitresult = (BlockHitResult)hitresult;
                if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
                    int remainTicks = this.m_8105_(pStack) - pRemainingUseDuration + 1;
                    if (remainTicks % 10 == 5) {
                        SoundEvent soundevent;
                        Block block;
                        BlockPos blockpos = blockhitresult.m_82425_();
                        BlockState blockstate = level.m_8055_(blockpos);
                        BlockPos pickPos = blockpos.m_7494_();
                        BlockState pickState = level.m_8055_(pickPos);
                        HumanoidArm humanoidarm = pLivingEntity.m_7655_() == InteractionHand.MAIN_HAND ? pLivingEntity.m_5737_() : pLivingEntity.m_5737_().m_20828_();
                        boolean shouldSet = EclipticSeasonsApi.getInstance().isSnowyBlock(level, blockstate, blockpos);
                        if (blockstate.m_245147_() && blockstate.m_60799_() != RenderShape.INVISIBLE) {
                            this.spawnDustParticles(level, blockhitresult, shouldSet ? Blocks.f_50127_.m_49966_() : blockstate, pLivingEntity.m_20252_(0.0f), humanoidarm);
                        }
                        if ((block = blockstate.m_60734_()) instanceof BrushableBlock) {
                            BrushableBlock brushableblock = (BrushableBlock)block;
                            soundevent = brushableblock.m_276856_();
                        } else {
                            soundevent = SoundEvents.f_276624_;
                        }
                        if (!level.m_5776_() && pickState.m_60713_(Blocks.f_50125_)) {
                            Player player;
                            level.m_46953_(pickPos, true, (Entity)pLivingEntity);
                            pStack.m_41622_(pLivingEntity instanceof Player && (player = (Player)pLivingEntity).m_7500_() ? 0 : 1, pLivingEntity, entity -> entity.m_21190_(pLivingEntity.m_7655_()));
                        }
                        level.m_245803_((Entity)pLivingEntity, blockpos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                        if (shouldSet && EclipticUtil.canSnowyBlockInteract()) {
                            if (level instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)level;
                                SnowyMapChecker.removeSnowyStatus(serverLevel, blockpos);
                            } else {
                                ClientCon.agent.setChunkDirty(SectionPos.m_123199_((BlockPos)blockpos));
                            }
                        }
                    }
                    return;
                }
            }
            pLivingEntity.m_21253_();
        } else {
            pLivingEntity.m_21253_();
        }
    }

    private HitResult calculateHitResult(LivingEntity livingEntity) {
        return BroomItem.getHitResultOnViewVector((Entity)livingEntity, entity -> !entity.m_5833_() && entity.m_6087_(), MAX_DISTANCE);
    }

    public static HitResult getHitResultOnViewVector(Entity pProjectile, Predicate<Entity> pFilter, double pScale) {
        Vec3 vec3 = pProjectile.m_20252_(0.0f).m_82490_(pScale);
        Level level = pProjectile.m_9236_();
        Vec3 vec31 = pProjectile.m_146892_();
        return BroomItem.getHitResult(vec31, pProjectile, pFilter, vec3, level);
    }

    private static HitResult getHitResult(Vec3 pStartVec, Entity pProjectile, Predicate<Entity> pFilter, Vec3 pEndVecOffset, Level pLevel) {
        EntityHitResult hitresult1;
        Vec3 vec3 = pStartVec.m_82549_(pEndVecOffset);
        BlockHitResult hitresult = pLevel.m_45547_(new ClipContext(pStartVec, vec3, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, pProjectile));
        if (hitresult.m_6662_() != HitResult.Type.MISS) {
            vec3 = hitresult.m_82450_();
        }
        if ((hitresult1 = ProjectileUtil.m_37304_((Level)pLevel, (Entity)pProjectile, (Vec3)pStartVec, (Vec3)vec3, (AABB)pProjectile.m_20191_().m_82369_(pEndVecOffset).m_82400_(1.0), pFilter)) != null) {
            hitresult = hitresult1;
        }
        return hitresult;
    }

    private void spawnDustParticles(Level pLevel, BlockHitResult pHitResult, BlockState pState, Vec3 pPos, HumanoidArm pArm) {
        double speed = 3.0;
        int right = pArm == HumanoidArm.RIGHT ? 1 : -1;
        int count = pLevel.m_213780_().m_216339_(7, 12);
        BlockParticleOption blockparticleoption = new BlockParticleOption(ParticleTypes.f_123794_, pState);
        Direction direction = pHitResult.m_82434_();
        DustParticlesDelta brushitem$dustparticlesdelta = DustParticlesDelta.fromDirection(pPos, direction);
        Vec3 vec3 = pHitResult.m_82450_();
        for (int k = 0; k < count; ++k) {
            pLevel.m_7106_((ParticleOptions)blockparticleoption, vec3.f_82479_ - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), vec3.f_82480_, vec3.f_82481_ - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), brushitem$dustparticlesdelta.xd() * (double)right * speed * pLevel.m_213780_().m_188500_(), 0.0, brushitem$dustparticlesdelta.zd() * (double)right * speed * pLevel.m_213780_().m_188500_());
        }
    }

    public void m_7373_(ItemStack stack, Level pLevel, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, pLevel, tooltipComponents, tooltipFlag);
        if (FMLLoader.getDist() != Dist.CLIENT || !((Boolean)ClientConfig.GUI.itemInformation.get()).booleanValue()) {
            return;
        }
        if (!EclipticUtil.canSnowyBlockInteract()) {
            tooltipComponents.add((Component)Component.m_237115_((String)"info.eclipticseasons.config.inactive"));
        }
    }

    record DustParticlesDelta(double xd, double yd, double zd) {
        private static final double ALONG_SIDE_DELTA = 1.0;
        private static final double OUT_FROM_SIDE_DELTA = 0.1;

        public static DustParticlesDelta fromDirection(Vec3 pPos, Direction pDirection) {
            double yd = 0.0;
            return switch (pDirection) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN, Direction.UP -> new DustParticlesDelta(pPos.m_7094_(), yd, -pPos.m_7096_());
                case Direction.NORTH -> new DustParticlesDelta(1.0, yd, -0.1);
                case Direction.SOUTH -> new DustParticlesDelta(-1.0, yd, 0.1);
                case Direction.WEST -> new DustParticlesDelta(-0.1, yd, -1.0);
                case Direction.EAST -> new DustParticlesDelta(0.1, yd, 1.0);
            };
        }
    }
}

