/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.snow;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.map.BiomeHolder;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntLongMutablePair;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeatherStatusKeeper
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final Codec<WeatherStatusKeeper> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)CodecUtil.holderCodec(Registries.f_256952_).listOf().optionalFieldOf("biomes", List.of()).forGetter(o -> new ArrayList<Holder<Biome>>(o.snowDepthRecord.keySet())), (App)Codec.INT.listOf().optionalFieldOf("snow_depth", List.of()).forGetter(o -> o.snowDepthRecord.values().stream().map(IntLongMutablePair::leftInt).toList()), (App)Codec.LONG.listOf().optionalFieldOf("last_rain_time", List.of()).forGetter(o -> o.snowDepthRecord.values().stream().map(IntLongMutablePair::rightLong).toList())).apply((Applicative)ins, WeatherStatusKeeper::new));
    private final Map<Holder<Biome>, IntLongMutablePair> snowDepthRecord = new Reference2ObjectLinkedOpenHashMap();
    private final Set<Holder<Biome>> biomeUse = new ReferenceLinkedOpenHashSet();
    private boolean change = false;
    public static final WeatherStatusKeeper EMPTY = WeatherStatusKeeper.create();
    public static final Capability<WeatherStatusKeeper> WEATHER_STATUS_KEEPER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<WeatherStatusKeeper>(){});
    private LazyOptional<WeatherStatusKeeper> cast = null;
    private transient CompoundTag cacheTag = null;

    protected WeatherStatusKeeper() {
        this(List.of(), List.of(), List.of());
    }

    public static WeatherStatusKeeper create() {
        return new WeatherStatusKeeper();
    }

    public WeatherStatusKeeper(List<Holder<Biome>> biomes, List<Integer> snow_depth, List<Long> last_rain_time) {
        if (biomes.size() == snow_depth.size()) {
            boolean lastRainRecord = last_rain_time.size() == biomes.size();
            int biomesSize = biomes.size();
            for (int i = 0; i < biomesSize; ++i) {
                Holder<Biome> biome = biomes.get(i);
                this.snowDepthRecord.put(biome, IntLongMutablePair.of((int)snow_depth.get(i), (long)(lastRainRecord ? last_rain_time.get(i) : 0L)));
            }
        }
    }

    public void removeBiomeRecord(Holder<Biome> biomeHolder) {
        this.snowDepthRecord.remove(biomeHolder);
        this.setChange();
    }

    public void updateAndSend(ServerLevel serverLevel, LevelChunk chunk) {
        if (EclipticUtil.canSnowyBlockInteract()) {
            this.updateBiomeWhenEndTick(serverLevel);
            if (this.change) {
                chunk.m_8092_(true);
            }
        }
        this.change = false;
    }

    protected void updateBiomeWhenEndTick(ServerLevel serverLevel) {
        if (serverLevel.m_213780_().m_188503_(20) == 0) {
            for (Holder<Biome> biomeHolder : this.biomeUse) {
                WeatherManager.BiomeWeather biomeWeather = WeatherManager.getBiomeWeather((Level)serverLevel, biomeHolder);
                byte snowDepth = biomeWeather.snowDepth;
                long lastRainTime = biomeWeather.lastRainTime;
                IntLongMutablePair orDefault = this.snowDepthRecord.getOrDefault(biomeHolder, null);
                if (orDefault != null && orDefault.leftInt() == snowDepth && orDefault.rightLong() == lastRainTime) continue;
                if (orDefault == null) {
                    orDefault = IntLongMutablePair.of((int)snowDepth, (long)lastRainTime);
                    this.snowDepthRecord.put(biomeHolder, orDefault);
                } else {
                    orDefault.left((int)snowDepth).right(lastRainTime);
                }
                this.setChange();
            }
        }
    }

    protected void setChange() {
        this.change = true;
        this.cacheTag = null;
    }

    public Pair<Map<Holder<Biome>, IntIntImmutablePair>, Map<Holder<Biome>, Long>> collectSnowyUpdate(ServerLevel level, @javax.annotation.Nullable BiomeHolder biomeHolder) {
        IdentityHashMap biomeRainUpdate;
        IdentityHashMap<Holder, IntIntImmutablePair> biomeSnowyUpdate = new IdentityHashMap<Holder, IntIntImmutablePair>();
        if (EclipticUtil.canSnowyBlockInteract()) {
            if (this.snowDepthRecord.isEmpty()) {
                ArrayList<WeatherManager.BiomeWeather> ws;
                biomeRainUpdate = null;
                ReferenceLinkedOpenHashSet biomeDetect = new ReferenceLinkedOpenHashSet();
                if (biomeHolder != null) {
                    Registry biomes = level.m_9598_().m_175515_(Registries.f_256952_);
                    IntOpenHashSet ids = new IntOpenHashSet(biomeHolder.biomes());
                    for (int i : ids.toIntArray()) {
                        biomeDetect.add(MapChecker.idToBiome((Registry<Biome>)biomes, i));
                    }
                }
                if ((ws = WeatherManager.getBiomeList((Level)level)) != null) {
                    for (Holder holder : biomeDetect) {
                        WeatherManager.BiomeWeather biomeWeather = WeatherManager.getBiomeWeather((Level)level, (Holder<Biome>)holder);
                        if (biomeWeather == null) continue;
                        biomeSnowyUpdate.put(holder, IntIntImmutablePair.of((int)biomeWeather.snowDepth, (int)0));
                    }
                }
            } else {
                biomeRainUpdate = new IdentityHashMap();
                int weatherTickFactor = WeatherManager.getWeatherTickFactor((Level)level) >> 2;
                this.snowDepthRecord.forEach((biome, pair) -> {
                    WeatherManager.BiomeWeather biomeWeather = WeatherManager.getBiomeWeather((Level)level, (Holder<Biome>)biome);
                    byte snowDepthAtBiome = biomeWeather.snowDepth;
                    long lastRainTime = biomeWeather.lastRainTime;
                    int snowDepthIncrease = snowDepthAtBiome - pair.leftInt();
                    int offsetAbs = Mth.m_14040_((int)snowDepthIncrease);
                    if ((snowDepthAtBiome < 3 || snowDepthAtBiome > 97) && offsetAbs != 0) {
                        biomeSnowyUpdate.put((Holder)biome, IntIntImmutablePair.of((int)snowDepthAtBiome, (int)0));
                    } else if (offsetAbs > 20) {
                        biomeSnowyUpdate.put((Holder)biome, IntIntImmutablePair.of((int)snowDepthAtBiome, (int)snowDepthIncrease));
                    }
                    if (pair.rightLong() < lastRainTime - (long)weatherTickFactor) {
                        biomeRainUpdate.put(biome, lastRainTime);
                    }
                });
            }
        } else {
            biomeRainUpdate = null;
        }
        return Pair.of(biomeSnowyUpdate, biomeRainUpdate);
    }

    public void updateSnowDepthRecord(ServerLevel level) {
        this.updateBiomeWhenEndTick(level);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == WEATHER_STATUS_KEEPER_CAPABILITY) {
            if (this.cast == null) {
                this.cast = LazyOptional.of(() -> this);
            }
            return this.cast.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        RegistryOps registryOps;
        Optional result;
        Object var5_4;
        if (!EclipticUtil.canSnowyBlockInteract()) {
            new CompoundTag();
        }
        if (this.cacheTag != null) {
            return this.cacheTag;
        }
        Level level = WeatherManager.fetchLevelIfNull(null);
        if (level != null && (var5_4 = (result = CODEC.encodeStart((DynamicOps)(registryOps = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)level.m_9598_())), (Object)this).result()).orElse(null)) instanceof CompoundTag) {
            CompoundTag compoundTag;
            this.cacheTag = compoundTag = (CompoundTag)var5_4;
            return compoundTag;
        }
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (!EclipticUtil.canSnowyBlockInteract()) {
            return;
        }
        if (!this.biomeUse.isEmpty()) {
            return;
        }
        Level level = WeatherManager.fetchLevelIfNull(null);
        if (level != null) {
            RegistryOps registryOps = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)level.m_9598_());
            Optional result = CODEC.parse((DynamicOps)registryOps, (Object)nbt).result();
            result.ifPresent(this::copyFrom);
        }
    }

    public void copyFrom(WeatherStatusKeeper keeper) {
        this.snowDepthRecord.clear();
        this.snowDepthRecord.putAll(keeper.snowDepthRecord);
    }

    @Generated
    public Map<Holder<Biome>, IntLongMutablePair> getSnowDepthRecord() {
        return this.snowDepthRecord;
    }

    @Generated
    public Set<Holder<Biome>> getBiomeUse() {
        return this.biomeUse;
    }

    @Generated
    public boolean isChange() {
        return this.change;
    }

    @Generated
    public LazyOptional<WeatherStatusKeeper> getCast() {
        return this.cast;
    }

    @Generated
    public void setChange(boolean change) {
        this.change = change;
    }

    @Generated
    public void setCast(LazyOptional<WeatherStatusKeeper> cast) {
        this.cast = cast;
    }

    @Generated
    public void setCacheTag(CompoundTag cacheTag) {
        this.cacheTag = cacheTag;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeatherStatusKeeper)) {
            return false;
        }
        WeatherStatusKeeper other = (WeatherStatusKeeper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isChange() != other.isChange()) {
            return false;
        }
        Map<Holder<Biome>, IntLongMutablePair> this$snowDepthRecord = this.getSnowDepthRecord();
        Map<Holder<Biome>, IntLongMutablePair> other$snowDepthRecord = other.getSnowDepthRecord();
        if (this$snowDepthRecord == null ? other$snowDepthRecord != null : !((Object)this$snowDepthRecord).equals(other$snowDepthRecord)) {
            return false;
        }
        Set<Holder<Biome>> this$biomeUse = this.getBiomeUse();
        Set<Holder<Biome>> other$biomeUse = other.getBiomeUse();
        if (this$biomeUse == null ? other$biomeUse != null : !((Object)this$biomeUse).equals(other$biomeUse)) {
            return false;
        }
        LazyOptional<WeatherStatusKeeper> this$cast = this.getCast();
        LazyOptional<WeatherStatusKeeper> other$cast = other.getCast();
        return !(this$cast == null ? other$cast != null : !this$cast.equals(other$cast));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WeatherStatusKeeper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isChange() ? 79 : 97);
        Map<Holder<Biome>, IntLongMutablePair> $snowDepthRecord = this.getSnowDepthRecord();
        result = result * 59 + ($snowDepthRecord == null ? 43 : ((Object)$snowDepthRecord).hashCode());
        Set<Holder<Biome>> $biomeUse = this.getBiomeUse();
        result = result * 59 + ($biomeUse == null ? 43 : ((Object)$biomeUse).hashCode());
        LazyOptional<WeatherStatusKeeper> $cast = this.getCast();
        result = result * 59 + ($cast == null ? 43 : $cast.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WeatherStatusKeeper(snowDepthRecord=" + String.valueOf(this.getSnowDepthRecord()) + ", biomeUse=" + String.valueOf(this.getBiomeUse()) + ", change=" + this.isChange() + ", cast=" + String.valueOf(this.getCast()) + ")";
    }
}

