/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.snow;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyMapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyStatusHandler;
import com.teamtea.eclipticseasons.common.core.snow.WeatherStatusKeeper;
import com.teamtea.eclipticseasons.common.network.SimpleNetworkHandler;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnowyStatusKeeper
implements Cloneable,
ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final int FLAG_NONE = 0;
    public static final int FLAG_SNOW = 1;
    public static final int FLAG_NOT_RECORD = -1;
    public static final Codec<SnowyStatusKeeper> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)Codec.LONG.listOf().fieldOf("map").forGetter(o -> new ArrayList(o.posMap.keySet())), (App)Codec.BYTE.listOf().optionalFieldOf("status", List.of()).forGetter(o -> o.posMap.values().stream().map(Integer::byteValue).toList())).apply((Applicative)ins, SnowyStatusKeeper::new));
    private final Long2IntLinkedOpenHashMap posMap = new Long2IntLinkedOpenHashMap();
    private final Long2IntLinkedOpenHashMap stepCount = new Long2IntLinkedOpenHashMap();
    private final LongArrayList posListUpdate = new LongArrayList();
    private final IntArrayList statusListUpdate = new IntArrayList();
    private boolean change = false;
    public static final SnowyStatusKeeper EMPTY = SnowyStatusKeeper.create();
    public static final Capability<SnowyStatusKeeper> SNOWY_STATUS_KEEPER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<SnowyStatusKeeper>(){});
    private LazyOptional<SnowyStatusKeeper> cast = null;
    private transient CompoundTag cacheTag = null;

    protected SnowyStatusKeeper() {
        this(List.of(), List.of());
    }

    public static SnowyStatusKeeper create() {
        return new SnowyStatusKeeper();
    }

    public SnowyStatusKeeper(List<Long> posList, List<Byte> status) {
        this.posMap.defaultReturnValue(-1);
        if (posList.size() == status.size() || status.isEmpty()) {
            int pairsSize = posList.size();
            for (int i = 0; i < pairsSize; ++i) {
                Long pair = posList.get(i);
                this.posMap.put(pair.longValue(), status.isEmpty() ? 1 : (int)status.get(i).byteValue());
            }
        }
        this.stepCount.defaultReturnValue(-1);
    }

    public boolean isSnowyBlock(BlockPos pos) {
        return this.getPosMap().containsKey(pos.m_121878_());
    }

    public void set(BlockPos pos, int flag) {
        long aLong = pos.m_121878_();
        if (this.set(aLong, flag)) {
            this.posListUpdate.add(aLong);
            this.statusListUpdate.add(flag);
            this.setChange();
            if (!this.stepCount.isEmpty() && flag == 0) {
                this.stepCount.remove(aLong);
            }
        }
    }

    public boolean set(long pos, int flag) {
        return switch (flag) {
            case 0 -> {
                if (this.posMap.remove(pos) != -1) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (this.posMap.put(pos, flag) != flag) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public void stepAndCheck(BlockPos pos) {
        int result;
        long aLong = pos.m_121878_();
        int n = result = !this.isSnowyBlock(pos) ? 0 : this.stepCount.addTo(aLong, 1);
        if (result > 8) {
            this.set(pos, 0);
        }
    }

    public void updateAndSend(ServerLevel serverLevel, LevelChunk chunk) {
        if (EclipticUtil.canSnowyBlockInteract() && this.change) {
            chunk.m_8092_(true);
            if (!this.posListUpdate.isEmpty()) {
                SimpleNetworkHandler.send(serverLevel.m_7726_().f_8325_.m_183262_(chunk.m_7697_(), false), new SnowyStatusHandler(false, this, chunk.m_7697_()));
                this.posListUpdate.clear();
                this.statusListUpdate.clear();
            }
        }
        this.change = false;
    }

    protected void setChange() {
        this.change = true;
        this.cacheTag = null;
    }

    public void tickChunk(ServerLevel level, LevelChunk chunk, ChunkPos chunkPos, BlockPos checkPos, ChunkInfoMap chunkInfoMap, WeatherStatusKeeper weatherStatusKeeper) {
        if (!EclipticUtil.canSnowyBlockInteract()) {
            return;
        }
        int height = chunkInfoMap.getHeight(checkPos);
        int surfaceHeight = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, checkPos.m_123341_(), checkPos.m_123343_());
        if (height <= (checkPos = new BlockPos(checkPos.m_123341_(), height < surfaceHeight ? level.m_213780_().m_216332_(0, surfaceHeight - height) + height : height, checkPos.m_123343_())).m_123342_()) {
            Holder<Biome> biome = MapChecker.getSurfaceBiomeByChunk((Level)level, chunk, checkPos);
            weatherStatusKeeper.getBiomeUse().add(biome);
            BlockState state = chunk.m_8055_(checkPos);
            int flag = MapChecker.getDefaultBlockTypeFlag(state);
            WeatherManager.SnowRenderStatus snowStatus = flag == 0 ? WeatherManager.SnowRenderStatus.SNOW_MELT : WeatherManager.getSnowStatus(level, (Biome)biome.m_203334_(), checkPos, EclipticUtil.isRainingOrSnowingWithSurfaceBiome((Level)level, (Biome)biome.m_203334_(), checkPos));
            boolean forceMelt = false;
            if (snowStatus != WeatherManager.SnowRenderStatus.SNOW_MELT) {
                if (SnowyMapChecker.isTooLight((BlockAndTintGetter)level, checkPos, state, flag)) {
                    snowStatus = WeatherManager.SnowRenderStatus.SNOW_MELT;
                    forceMelt = true;
                }
                if (!forceMelt && !MapChecker.notLightAbove((Level)level, checkPos, 4)) {
                    snowStatus = WeatherManager.SnowRenderStatus.SNOW_MELT;
                    forceMelt = true;
                }
            }
            switch (snowStatus) {
                case SNOW: {
                    if ((long)WeatherManager.getSnowDepthAtBiome((Level)level, (Biome)biome.m_203334_()) <= Math.abs(state.m_60726_(checkPos) % 100L)) break;
                    this.set(checkPos, 1);
                    break;
                }
                case SNOW_MELT: {
                    if (!forceMelt && (long)WeatherManager.getSnowDepthAtBiome((Level)level, (Biome)biome.m_203334_()) > Math.abs(state.m_60726_(checkPos) % 100L) || chunk.m_8055_(checkPos).m_204336_(BlockTags.f_144279_)) break;
                    this.set(checkPos, 0);
                }
            }
        }
    }

    public boolean checkPosValid(ChunkAccess chunk) {
        boolean anyIllgegalPos = false;
        ChunkPos chunkPos = chunk.m_7697_();
        int startX = chunkPos.m_45604_();
        int startZ = chunkPos.m_45605_();
        int endX = chunkPos.m_45608_();
        int endZ = chunkPos.m_45609_();
        int minBuildHeight = chunk.m_141937_();
        int maxBuildHeight = chunk.m_151558_();
        LongIterator it = this.getPosMap().keySet().longIterator();
        while (it.hasNext()) {
            long key = it.nextLong();
            int x = BlockPos.m_121983_((long)key);
            int z = BlockPos.m_122015_((long)key);
            int y = BlockPos.m_122008_((long)key);
            boolean valid = x >= startX && x <= endX && z >= startZ && z <= endZ && y >= minBuildHeight && y < maxBuildHeight;
            if (valid) continue;
            it.remove();
            anyIllgegalPos = true;
        }
        if (anyIllgegalPos) {
            this.setChange();
        }
        return !anyIllgegalPos;
    }

    public SnowyStatusKeeper clone() {
        SnowyStatusKeeper newKepper = SnowyStatusKeeper.create();
        newKepper.posMap.putAll((Map)this.posMap);
        return newKepper;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == SNOWY_STATUS_KEEPER_CAPABILITY) {
            if (this.cast == null) {
                this.cast = LazyOptional.of(() -> this);
            }
            return this.cast.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        RegistryOps registryOps;
        Optional result;
        Object var5_4;
        if (!EclipticUtil.canSnowyBlockInteract()) {
            new CompoundTag();
        }
        if (this.cacheTag != null) {
            return this.cacheTag;
        }
        Level level = WeatherManager.fetchLevelIfNull(null);
        if (level != null && (var5_4 = (result = CODEC.encodeStart((DynamicOps)(registryOps = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)level.m_9598_())), (Object)this).result()).orElse(null)) instanceof CompoundTag) {
            CompoundTag compoundTag;
            this.cacheTag = compoundTag = (CompoundTag)var5_4;
            return compoundTag;
        }
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (!EclipticUtil.canSnowyBlockInteract()) {
            return;
        }
        if (!this.posMap.isEmpty() || !this.stepCount.isEmpty()) {
            return;
        }
        Level level = WeatherManager.fetchLevelIfNull(null);
        if (level != null) {
            RegistryOps registryOps = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)level.m_9598_());
            Optional result = CODEC.parse((DynamicOps)registryOps, (Object)nbt).result();
            result.ifPresent(this::copyFrom);
        }
    }

    public void copyFrom(SnowyStatusKeeper keeper) {
        this.posMap.clear();
        this.posMap.putAll((Map)keeper.posMap);
    }

    @Generated
    public Long2IntLinkedOpenHashMap getPosMap() {
        return this.posMap;
    }

    @Generated
    public Long2IntLinkedOpenHashMap getStepCount() {
        return this.stepCount;
    }

    @Generated
    public LongArrayList getPosListUpdate() {
        return this.posListUpdate;
    }

    @Generated
    public IntArrayList getStatusListUpdate() {
        return this.statusListUpdate;
    }

    @Generated
    public boolean isChange() {
        return this.change;
    }

    @Generated
    public LazyOptional<SnowyStatusKeeper> getCast() {
        return this.cast;
    }

    @Generated
    public void setChange(boolean change) {
        this.change = change;
    }

    @Generated
    public void setCast(LazyOptional<SnowyStatusKeeper> cast) {
        this.cast = cast;
    }

    @Generated
    public void setCacheTag(CompoundTag cacheTag) {
        this.cacheTag = cacheTag;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnowyStatusKeeper)) {
            return false;
        }
        SnowyStatusKeeper other = (SnowyStatusKeeper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isChange() != other.isChange()) {
            return false;
        }
        Long2IntLinkedOpenHashMap this$posMap = this.getPosMap();
        Long2IntLinkedOpenHashMap other$posMap = other.getPosMap();
        if (this$posMap == null ? other$posMap != null : !this$posMap.equals(other$posMap)) {
            return false;
        }
        Long2IntLinkedOpenHashMap this$stepCount = this.getStepCount();
        Long2IntLinkedOpenHashMap other$stepCount = other.getStepCount();
        if (this$stepCount == null ? other$stepCount != null : !this$stepCount.equals(other$stepCount)) {
            return false;
        }
        LongArrayList this$posListUpdate = this.getPosListUpdate();
        LongArrayList other$posListUpdate = other.getPosListUpdate();
        if (this$posListUpdate == null ? other$posListUpdate != null : !this$posListUpdate.equals(other$posListUpdate)) {
            return false;
        }
        IntArrayList this$statusListUpdate = this.getStatusListUpdate();
        IntArrayList other$statusListUpdate = other.getStatusListUpdate();
        if (this$statusListUpdate == null ? other$statusListUpdate != null : !this$statusListUpdate.equals(other$statusListUpdate)) {
            return false;
        }
        LazyOptional<SnowyStatusKeeper> this$cast = this.getCast();
        LazyOptional<SnowyStatusKeeper> other$cast = other.getCast();
        return !(this$cast == null ? other$cast != null : !this$cast.equals(other$cast));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnowyStatusKeeper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isChange() ? 79 : 97);
        Long2IntLinkedOpenHashMap $posMap = this.getPosMap();
        result = result * 59 + ($posMap == null ? 43 : $posMap.hashCode());
        Long2IntLinkedOpenHashMap $stepCount = this.getStepCount();
        result = result * 59 + ($stepCount == null ? 43 : $stepCount.hashCode());
        LongArrayList $posListUpdate = this.getPosListUpdate();
        result = result * 59 + ($posListUpdate == null ? 43 : $posListUpdate.hashCode());
        IntArrayList $statusListUpdate = this.getStatusListUpdate();
        result = result * 59 + ($statusListUpdate == null ? 43 : $statusListUpdate.hashCode());
        LazyOptional<SnowyStatusKeeper> $cast = this.getCast();
        result = result * 59 + ($cast == null ? 43 : $cast.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SnowyStatusKeeper(posMap=" + String.valueOf(this.getPosMap()) + ", stepCount=" + String.valueOf(this.getStepCount()) + ", posListUpdate=" + String.valueOf(this.getPosListUpdate()) + ", statusListUpdate=" + String.valueOf(this.getStatusListUpdate()) + ", change=" + this.isChange() + ", cast=" + String.valueOf(this.getCast()) + ")";
    }
}

