/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.snow;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.misc.IChunkBiomeHolder;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.core.map.BiomeHolder;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyStatusHandler;
import com.teamtea.eclipticseasons.common.core.snow.SnowyStatusKeeper;
import com.teamtea.eclipticseasons.common.core.snow.WeatherStatusKeeper;
import com.teamtea.eclipticseasons.common.network.SimpleNetworkHandler;
import com.teamtea.eclipticseasons.config.CommonConfig;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

public class SnowyMapChecker {
    @NotNull
    public static SnowyStatusKeeper getSnowyStatusKeeper(ChunkAccess chunk) {
        LevelChunk levelChunk;
        if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk1;
            levelChunk = levelChunk1 = (LevelChunk)chunk;
        } else if (chunk instanceof ImposterProtoChunk) {
            ImposterProtoChunk imposterProtoChunk = (ImposterProtoChunk)chunk;
            levelChunk = imposterProtoChunk.m_62768_();
        } else {
            levelChunk = new EmptyLevelChunk(ClientCon.getUseLevel(), chunk.m_7697_(), (Holder)ClientCon.getUseLevel().m_9598_().m_175515_(Registries.f_256952_).m_246971_(Biomes.f_48202_));
        }
        LevelChunk levelChunk2 = levelChunk;
        return (SnowyStatusKeeper)levelChunk2.getCapability(SnowyStatusKeeper.SNOWY_STATUS_KEEPER_CAPABILITY, null).orElseGet(SnowyStatusKeeper::create);
    }

    @NotNull
    public static WeatherStatusKeeper getWeatherStatusKeeper(ChunkAccess chunk) {
        LevelChunk levelChunk;
        if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk1;
            levelChunk = levelChunk1 = (LevelChunk)chunk;
        } else if (chunk instanceof ImposterProtoChunk) {
            ImposterProtoChunk imposterProtoChunk = (ImposterProtoChunk)chunk;
            levelChunk = imposterProtoChunk.m_62768_();
        } else {
            levelChunk = new EmptyLevelChunk(ClientCon.getUseLevel(), chunk.m_7697_(), (Holder)ClientCon.getUseLevel().m_9598_().m_175515_(Registries.f_256952_).m_246971_(Biomes.f_48202_));
        }
        LevelChunk levelChunk2 = levelChunk;
        return (WeatherStatusKeeper)levelChunk2.getCapability(WeatherStatusKeeper.WEATHER_STATUS_KEEPER_CAPABILITY, null).orElseGet(WeatherStatusKeeper::create);
    }

    @NotNull
    public static SnowyStatusKeeper getSnowyStatusKeeperCopy(LevelChunk chunk) {
        if (!EclipticUtil.canSnowyBlockInteract()) {
            return SnowyStatusKeeper.EMPTY;
        }
        return SnowyMapChecker.getSnowyStatusKeeper((ChunkAccess)chunk);
    }

    public static void updatePos(Level level, LevelChunk chunk, BlockPos pos, BlockState state, BlockState oldState, Block block) {
        if (EclipticUtil.canSnowyBlockInteract()) {
            boolean blockDestroyOrReplace = false;
            if (state.m_60795_()) {
                blockDestroyOrReplace = true;
            } else if (MapChecker.solidTest(state)) {
                SnowyMapChecker.removeSnowyStatus(level, chunk, pos);
                SnowyMapChecker.removeSnowyStatus(level, chunk, pos.m_7495_());
            } else if (((Boolean)CommonConfig.Snow.snowyUnderSnowLike.get()).booleanValue() && state.m_204336_(BlockTags.f_144279_)) {
                SnowyMapChecker.setSnowyStatus(level, chunk, pos.m_7495_());
            } else if (!oldState.m_60713_(block)) {
                blockDestroyOrReplace = true;
            }
            if (blockDestroyOrReplace) {
                SnowyMapChecker.removeSnowyStatus(level, chunk, pos);
                if (((Boolean)CommonConfig.Snow.snowyUnderSnowLike.get()).booleanValue() && oldState.m_204336_(BlockTags.f_144279_)) {
                    SnowyMapChecker.removeSnowyStatus(level, chunk, pos.m_7495_());
                }
            }
        }
    }

    public static void updateAllChunks(ServerLevel level) {
        if (!EclipticUtil.canSnowyBlockInteract()) {
            return;
        }
        int biomeDataVersion = EclipticUtil.getBiomeDataVersion((Level)level);
        for (ChunkHolder chunk : level.m_7726_().f_8325_.m_140416_()) {
            LevelChunk latestChunk = chunk.m_212234_();
            if (!(latestChunk instanceof IChunkBiomeHolder)) continue;
            IChunkBiomeHolder chunkBiomeHolder = (IChunkBiomeHolder)latestChunk;
            BiomeHolder biomeHolder = chunkBiomeHolder.eclipticseasons$getBiomeHolder();
            if (biomeHolder != null && biomeHolder.version() != biomeDataVersion) {
                biomeHolder = null;
            }
            SnowyMapChecker.forceChunkUpdateHeight(level, (ChunkAccess)latestChunk, MapChecker.getChunkInfoMapOrCreate((Level)level, latestChunk.m_7697_()), biomeHolder, false);
        }
    }

    public static void removeSnowyStatus(ServerLevel level, BlockPos pos) {
        if (MapChecker.isLoaded((Level)level, pos)) {
            SnowyMapChecker.removeSnowyStatus((Level)level, level.m_46745_(pos), pos);
        }
    }

    public static void removeSnowyStatus(Level level, LevelChunk chunk, BlockPos pos) {
        if (EclipticUtil.canSnowyBlockInteract()) {
            SnowyStatusKeeper keeper = SnowyMapChecker.getSnowyStatusKeeper((ChunkAccess)chunk);
            if (level.f_46443_) {
                keeper.set(pos.m_121878_(), 0);
            } else {
                keeper.set(pos, 0);
            }
        }
    }

    public static void setSnowyStatus(Level level, LevelChunk chunk, BlockPos pos) {
        if (EclipticUtil.canSnowyBlockInteract()) {
            SnowyStatusKeeper keeper = SnowyMapChecker.getSnowyStatusKeeper((ChunkAccess)chunk);
            if (level.f_46443_) {
                keeper.set(pos.m_121878_(), 1);
            } else {
                keeper.set(pos, 1);
            }
        }
    }

    public static void forceChunkUpdateHeight(ServerLevel level, ChunkAccess chunk, ChunkInfoMap chunkMap, @Nullable BiomeHolder biomeHolder, boolean loadingChunk) {
        if (!EclipticUtil.canSnowyBlockInteract() || !((Boolean)CommonConfig.Snow.forceChunkUpdate.get()).booleanValue()) {
            return;
        }
        ChunkPos chunkPos = chunk.m_7697_();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(chunkPos.m_45604_(), 0, chunkPos.m_45605_());
        SnowyStatusKeeper keeper = SnowyMapChecker.getSnowyStatusKeeper(chunk);
        WeatherStatusKeeper weatherStatusKeeper = SnowyMapChecker.getWeatherStatusKeeper(chunk);
        boolean checkIfBiomeCacheAnyMore = false;
        Pair<Map<Holder<Biome>, IntIntImmutablePair>, Map<Holder<Biome>, Long>> biomeSnowyUpdate = weatherStatusKeeper.collectSnowyUpdate(level, biomeHolder);
        if (chunkMap != null) {
            for (int i = chunkPos.m_45604_(); i <= chunkPos.m_45608_(); ++i) {
                for (int j = chunkPos.m_45605_(); j <= chunkPos.m_45609_(); ++j) {
                    checkPos.m_142451_(i);
                    checkPos.m_142443_(j);
                    int k = chunkMap.getHeight(i, j);
                    checkPos.m_142448_(k);
                    checkIfBiomeCacheAnyMore = SnowyMapChecker.isCheckIfBiomeCacheAnyMore(level, chunk, biomeHolder, biomeSnowyUpdate, checkPos, keeper, weatherStatusKeeper, k);
                }
            }
        }
        SnowyMapChecker.postAfterChunkUpdate(level, chunk, keeper, weatherStatusKeeper, checkIfBiomeCacheAnyMore, loadingChunk);
    }

    private static boolean isCheckIfBiomeCacheAnyMore(ServerLevel level, ChunkAccess chunk, BiomeHolder biomeHolder, Pair<Map<Holder<Biome>, IntIntImmutablePair>, Map<Holder<Biome>, Long>> pair, BlockPos.MutableBlockPos checkPos, SnowyStatusKeeper keeper, WeatherStatusKeeper weatherStatusKeeper, int solidHeight) {
        Map biomeSnowyUpdate = (Map)pair.getFirst();
        Map rainUpdateMap = (Map)pair.getSecond();
        if (!biomeSnowyUpdate.isEmpty()) {
            boolean rainInMissingTime;
            Holder<Biome> biome = MapChecker.getSurfaceBiome((Level)level, (BlockPos)checkPos, biomeHolder);
            weatherStatusKeeper.getBiomeUse().add(biome);
            boolean bl = rainInMissingTime = rainUpdateMap == null || rainUpdateMap.containsKey(biome);
            if (rainInMissingTime) {
                IntIntImmutablePair snowDepthUse = biomeSnowyUpdate.getOrDefault(biome, null);
                int heightSurface = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, checkPos.m_123341_(), checkPos.m_123343_());
                for (int posH = solidHeight; posH <= heightSurface; ++posH) {
                    checkPos.m_142448_(posH);
                    BlockState state = chunk.m_8055_((BlockPos)checkPos);
                    int flag = MapChecker.getDefaultBlockTypeFlag(state);
                    if (flag == 0) continue;
                    if (SnowyMapChecker.isTooLight((BlockAndTintGetter)level, (BlockPos)checkPos, state, flag)) {
                        keeper.set((BlockPos)checkPos, 0);
                        continue;
                    }
                    if (snowDepthUse == null) {
                        if (!MapChecker.isAboveSnowLine((Level)level, (Biome)biome.m_203334_(), (BlockPos)checkPos)) continue;
                        keeper.set((BlockPos)checkPos, 1);
                        continue;
                    }
                    if (snowDepthUse.rightInt() == 0) {
                        if ((long)snowDepthUse.leftInt() > Math.abs(state.m_60726_((BlockPos)checkPos) % 100L) || MapChecker.isAboveSnowLine((Level)level, (Biome)biome.m_203334_(), (BlockPos)checkPos)) {
                            keeper.set((BlockPos)checkPos, 1);
                            continue;
                        }
                        keeper.set((BlockPos)checkPos, 0);
                        continue;
                    }
                    int cut = snowDepthUse.rightInt() + (snowDepthUse.leftInt() - snowDepthUse.rightInt()) / 4;
                    if (cut > 0) {
                        if ((long)cut <= Math.abs(state.m_60726_((BlockPos)checkPos) % 100L) && !MapChecker.isAboveSnowLine((Level)level, (Biome)biome.m_203334_(), (BlockPos)checkPos)) continue;
                        keeper.set((BlockPos)checkPos, 1);
                        continue;
                    }
                    if ((long)(-cut) > Math.abs(state.m_60726_((BlockPos)checkPos) % 100L)) continue;
                    keeper.set((BlockPos)checkPos, 0);
                }
            }
            return true;
        }
        return false;
    }

    private static void postAfterChunkUpdate(ServerLevel level, ChunkAccess chunk, SnowyStatusKeeper keeper, WeatherStatusKeeper weatherStatusKeeper, boolean checkIfBiomeCacheAnyMore, boolean loadingChunk) {
        boolean shouldClear;
        weatherStatusKeeper.updateSnowDepthRecord(level);
        keeper.checkPosValid(chunk);
        if (checkIfBiomeCacheAnyMore && (shouldClear = weatherStatusKeeper.getSnowDepthRecord().keySet().removeIf(holder -> !weatherStatusKeeper.getBiomeUse().contains(holder)))) {
            keeper.setChange();
        }
        if (!loadingChunk && chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            weatherStatusKeeper.updateAndSend(level, levelChunk);
            keeper.updateAndSend(level, levelChunk);
            keeper.getStepCount().clear();
        }
    }

    @Deprecated
    public static void sendChunkLoginInfo$1_20_1(ServerLevel serverLevel, LevelChunk chunk, ChunkPos chunkPos, ServerPlayer player) {
        if (!EclipticUtil.canSnowyBlockInteract()) {
            return;
        }
        SnowyStatusKeeper snowyStatusKeeper = SnowyMapChecker.getSnowyStatusKeeper((ChunkAccess)chunk);
        SimpleNetworkHandler.send(player, new SnowyStatusHandler(true, snowyStatusKeeper, chunkPos));
    }

    public static boolean isTooLight(BlockAndTintGetter level, BlockPos pos, BlockState state, int blockType) {
        return SnowyMapChecker.isTooLight(level, pos, null, state, blockType);
    }

    public static boolean isTooLight(BlockAndTintGetter level, BlockPos pos, @Nullable BlockPos.MutableBlockPos mutableBlockPos, BlockState state, int blockType) {
        if (((Boolean)CommonConfig.Snow.notSnowyNearGlowingBlock.get()).booleanValue()) {
            int aboveOffset = 1 - MapChecker.getSnowOffset(state, blockType);
            if (mutableBlockPos != null) {
                mutableBlockPos.m_142448_(pos.m_123342_() + aboveOffset);
                pos = mutableBlockPos;
            } else {
                pos = pos.m_6630_(aboveOffset);
            }
            return level.m_45517_(LightLayer.BLOCK, pos) >= (Integer)CommonConfig.Snow.notSnowyNearGlowingBlockLevel.get();
        }
        return false;
    }

    public static boolean shouldCheckSnowyStatus(Level level, BlockPos pos) {
        return EclipticUtil.canSnowyBlockInteract() && MapChecker.isLoaded(level, pos);
    }

    public static boolean isSnowyBlock(Level level, BlockPos pos) {
        return SnowyMapChecker.getSnowyStatusKeeper((ChunkAccess)level.m_46745_(pos)).isSnowyBlock(pos);
    }

    public static boolean isSnowyBlock(SnowyStatusKeeper keeper, BlockPos pos) {
        return keeper.isSnowyBlock(pos);
    }

    public static void onEntityStepOn(Entity entity, Level level, BlockPos pos, BlockState blockstate) {
        if (!EclipticUtil.canSnowyBlockInteract()) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (!((Boolean)CommonConfig.Snow.stepMelt.get()).booleanValue()) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (MapChecker.getDefaultBlockTypeFlag(blockstate) != 0 && level.m_46467_() % 8L == 0L && SnowyMapChecker.shouldCheckSnowyStatus((Level)serverLevel, pos)) {
                LevelChunk chunkAt = level.m_46745_(pos);
                SnowyStatusKeeper keeper = SnowyMapChecker.getSnowyStatusKeeper((ChunkAccess)chunkAt);
                keeper.stepAndCheck(pos);
                BlockPos.MutableBlockPos above = pos.m_122032_();
                for (int count = 1; count < 4; ++count) {
                    int flagAbove;
                    above.m_142448_(pos.m_123342_() + count);
                    BlockState stateAbove = chunkAt.m_8055_((BlockPos)above);
                    if (stateAbove.m_60795_() || (flagAbove = MapChecker.getDefaultBlockTypeFlag(stateAbove)) == 0) break;
                    keeper.stepAndCheck((BlockPos)above);
                }
            }
        }
    }
}

