/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.snow;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.misc.ESSortInfo;
import com.teamtea.eclipticseasons.api.data.season.SnowDefinition;
import com.teamtea.eclipticseasons.api.util.SimpleUtil;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SnowChecker {
    public static final Map<Block, List<SnowDefinition>> SNOW_DEFINITION_MAP = new IdentityHashMap<Block, List<SnowDefinition>>(1024);
    public static final Map<BlockState, SnowDefinition.Info> statemap = new IdentityHashMap<BlockState, SnowDefinition.Info>(4096);

    @NotNull
    public static SnowDefinition.Info getUncacheSnow(BlockState blockState) {
        SnowDefinition.Info sno = statemap.get(blockState);
        if (sno == null) {
            SnowDefinition snowDefinition = null;
            List<SnowDefinition> snowDefinitions = SNOW_DEFINITION_MAP.get(blockState.m_60734_());
            if (snowDefinitions != null) {
                for (SnowDefinition definition : snowDefinitions) {
                    if (definition.getMap().isEmpty()) {
                        snowDefinition = definition;
                        break;
                    }
                    boolean allMatch = true;
                    for (SnowDefinition.PropertyTester tester : definition.getMap()) {
                        if (tester.matches(blockState) != tester.isReverse()) continue;
                        allMatch = false;
                        break;
                    }
                    if (!allMatch) continue;
                    snowDefinition = definition;
                    break;
                }
            }
            sno = snowDefinition == null ? SnowDefinition.Info.EMPTY : snowDefinition.getInfo();
            statemap.put(blockState, sno);
        }
        return sno == null ? SnowDefinition.Info.EMPTY : sno;
    }

    public static void clearOnClientExitOrServerClose() {
        SNOW_DEFINITION_MAP.clear();
        statemap.clear();
    }

    public static void resetUpdate(RegistryAccess registryAccess, boolean isServer) {
        statemap.clear();
        Optional snowDefinitions = registryAccess.m_6632_(ESRegistries.SNOW_DEFINITIONS);
        if (snowDefinitions.isEmpty()) {
            SimpleUtil.warningForModWrongCalling(ESRegistries.SNOW_DEFINITIONS);
        } else {
            SNOW_DEFINITION_MAP.clear();
            if (ClientCon.snowDefCache != null) {
                ClientCon.snowDefCache.build(registryAccess, SnowDefinition.class);
            }
            for (SnowDefinition snowDefinition : ESSortInfo.sorted2(registryAccess.m_175515_(ESRegistries.SNOW_DEFINITIONS))) {
                snowDefinition.fillMap(SNOW_DEFINITION_MAP);
            }
            EclipticSeasons.logger("Has registered extra snow definitions with size %s.".formatted(SNOW_DEFINITION_MAP.size()));
        }
    }
}

