/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.map;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BiomeHolder
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    private final int[] biomes;
    private boolean hasUpdated;
    private int version;
    public static final int FLAG_NEED_VERSION = -1;
    public static final int FLAG_FILL_SMALL = -2;
    public static final Codec<BiomeHolder> CODEC = RecordCodecBuilder.create(snowyRemoverInstance -> snowyRemoverInstance.group((App)Codec.INT.listOf().fieldOf("blocks").forGetter(snowyRemover -> IntList.of((int[])snowyRemover.biomes())), (App)Codec.BOOL.fieldOf("has_updated").forGetter(BiomeHolder::hasUpdated), (App)Codec.INT.fieldOf("version").forGetter(BiomeHolder::version)).apply((Applicative)snowyRemoverInstance, (biomes, hasUpdated, v) -> {
        int[] biomeArryas;
        if (biomes instanceof IntList) {
            IntList intList = (IntList)biomes;
            biomeArryas = intList.toIntArray();
        } else {
            biomeArryas = new int[biomes.size()];
            for (int i = 0; i < biomes.size(); ++i) {
                biomeArryas[i] = (Integer)biomes.get(i);
            }
        }
        return new BiomeHolder(biomeArryas, (boolean)hasUpdated, (int)v);
    }));
    public static final Capability<BiomeHolder> BIOME_HOLDER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<BiomeHolder>(){});
    private LazyOptional<BiomeHolder> cast = null;
    private int cacheVersion = Integer.MIN_VALUE;
    private boolean cacheUpdate = false;
    private CompoundTag cacheTag = null;
    public static final Map<ChunkPos, BiomeHolder> BIOME_HOLDER_MAP = new HashMap<ChunkPos, BiomeHolder>();

    public BiomeHolder(int[] biomes, boolean hasUpdated, int version) {
        this.biomes = biomes;
        this.hasUpdated = hasUpdated;
        this.version = version;
    }

    public static BiomeHolder prepareBiomes(Level serverLevel, ChunkPos chunkPos, int biomeDataVersion, boolean registryUpdate) {
        int[] newBiomes = new int[256];
        boolean near = true;
        Registry biomeRegistry = serverLevel.m_9598_().m_175515_(Registries.f_256952_);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        block0: for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int xm = chunkPos.m_151382_(i);
                int zm = chunkPos.m_151391_(j);
                mutableBlockPos.m_122178_(xm, 0, zm);
                Holder<Biome> unCachedSurfaceBiome = MapChecker.getUnCachedSurfaceBiome(serverLevel, (BlockPos)mutableBlockPos);
                int n = newBiomes[i * 16 + j] = registryUpdate ? MapChecker.biomeToId((Registry<Biome>)biomeRegistry, (Biome)unCachedSurfaceBiome.m_203334_()) : MapChecker.biomeToId(serverLevel, (Biome)unCachedSurfaceBiome.m_203334_());
                if (!near) continue block0;
            }
        }
        return new BiomeHolder(newBiomes, near, biomeDataVersion);
    }

    public static BiomeHolder fillSmallBiomes(Level serverLevel, ChunkPos chunkPos, BiomeHolder oldHolder, int biomeDataVersion) {
        int[] newBiomes = new int[256];
        boolean near = true;
        int[] oldBiomes = oldHolder.biomes;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        block0: for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Holder<Biome> biomeHolder = MapChecker.idToBiome(serverLevel, oldBiomes[i * 16 + j]);
                if (MapChecker.isSmallBiome(biomeHolder)) {
                    int xm = chunkPos.m_151382_(i);
                    int zm = chunkPos.m_151391_(j);
                    mutableBlockPos.m_122178_(xm, 0, zm);
                    newBiomes[i * 16 + j] = MapChecker.biomeToId(serverLevel, (Biome)MapChecker.getUnCachedSurfaceBiome(serverLevel, (BlockPos)mutableBlockPos).m_203334_());
                    if (near) continue;
                    continue block0;
                }
                newBiomes[i * 16 + j] = oldBiomes[i * 16 + j];
            }
        }
        return new BiomeHolder(newBiomes, near, biomeDataVersion);
    }

    public int getBiomeId(BlockPos blockPos) {
        return this.hasUpdated ? this.biomes[(blockPos.m_123341_() & 0xF) * 16 + (blockPos.m_123343_() & 0xF)] : -1;
    }

    public static BiomeHolder empty() {
        return new BiomeHolder(new int[256], false, 0);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == BIOME_HOLDER_CAPABILITY) {
            if (this.cast == null) {
                this.cast = LazyOptional.of(() -> this);
            }
            return this.cast.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        if (this.cacheUpdate == this.hasUpdated && this.cacheVersion == this.version && this.cacheTag != null) {
            return this.cacheTag;
        }
        Optional result = CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).result();
        Object var3_2 = result.orElse(null);
        if (var3_2 instanceof CompoundTag) {
            CompoundTag compoundTag;
            this.cacheTag = compoundTag = (CompoundTag)var3_2;
            this.cacheUpdate = this.hasUpdated;
            this.cacheVersion = this.version;
            return compoundTag;
        }
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (this.version != 0 && !this.hasUpdated) {
            return;
        }
        Optional result = CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt).result();
        result.ifPresent(this::copyFrom);
    }

    public void copyFrom(BiomeHolder biomeHolder) {
        System.arraycopy(biomeHolder.biomes, 0, this.biomes, 0, biomeHolder.biomes.length);
        this.version = biomeHolder.version;
        this.hasUpdated = biomeHolder.hasUpdated;
    }

    public int[] biomes() {
        return this.biomes;
    }

    public boolean hasUpdated() {
        return this.hasUpdated;
    }

    public int version() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BiomeHolder that = (BiomeHolder)obj;
        return Arrays.equals(this.biomes, that.biomes) && this.hasUpdated == that.hasUpdated && this.version == that.version;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.biomes), this.hasUpdated, this.version);
    }

    public String toString() {
        return "BiomeHolder[biomes=" + Arrays.toString(this.biomes) + ", hasUpdated=" + this.hasUpdated + ", version=" + this.version + "]";
    }
}

