/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.biome;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.climate.BiomeClimateSettings;
import com.teamtea.eclipticseasons.api.constant.climate.ISnowTerm;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.tag.ClimateTypeBiomeTags;
import com.teamtea.eclipticseasons.api.constant.tag.ClimateTypeFilters;
import com.teamtea.eclipticseasons.api.data.climate.BiomesClimateSettings;
import com.teamtea.eclipticseasons.api.data.misc.ESSortInfo;
import com.teamtea.eclipticseasons.api.data.season.SeasonCycle;
import com.teamtea.eclipticseasons.api.data.season.SeasonPhase;
import com.teamtea.eclipticseasons.api.data.weather.CustomRain;
import com.teamtea.eclipticseasons.api.data.weather.CustomRainBuilder;
import com.teamtea.eclipticseasons.api.data.weather.CustomSnowTerm;
import com.teamtea.eclipticseasons.api.misc.IBiomeTagHolder;
import com.teamtea.eclipticseasons.api.misc.RegistryFilter;
import com.teamtea.eclipticseasons.api.util.SimpleUtil;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class BiomeClimateManager {
    public static final Map<Biome, BiomeClimateSettings> BIOME_CLIMATE_MAP = new IdentityHashMap<Biome, BiomeClimateSettings>();
    public static final Map<Biome, TagKey<Biome>> BIOME_TAG_KEY_MAP = new IdentityHashMap<Biome, TagKey<Biome>>(128);
    public static final Map<Biome, Boolean> SMALL_BIOME_MAP = new IdentityHashMap<Biome, Boolean>(16);
    public static final Map<Biome, Map<SolarTerm, Holder<SeasonPhase>>> SEASON_PHASE_MAP = new IdentityHashMap<Biome, Map<SolarTerm, Holder<SeasonPhase>>>();
    public static final Map<Biome, TagKey<Biome>> BIOME_COLOR_TAG_KEY_MAP = new IdentityHashMap<Biome, TagKey<Biome>>(128);
    public static final Map<Biome, Map<SolarTerm, CustomRain>> CUSTOME_BIOME_RAIN_MAP = new IdentityHashMap<Biome, Map<SolarTerm, CustomRain>>();
    public static final Map<Biome, ISnowTerm> CUSTOM_SNOW_TERM_MAP = new IdentityHashMap<Biome, ISnowTerm>();
    public static final Map<Biome, Holder<Biome>> WEATHER_REGION_MAP = new IdentityHashMap<Biome, Holder<Biome>>();
    public static final Map<Biome, Integer> SNOW_LINE_MAP = new IdentityHashMap<Biome, Integer>();
    public static final BiomeClimateSettings EMPTY = new BiomeClimateSettings();
    public static final float SNOW_LEVEL = 0.15f;
    public static final float FROZEN_OCEAN_MELT_LEVEL = 0.1f;

    public static void resetBiomeTags(RegistryAccess registryAccess, boolean isServer) {
        Optional registry = registryAccess.m_6632_(Registries.f_256952_);
        if (registry.isEmpty()) {
            SimpleUtil.warningForModWrongCalling(Registries.f_256952_);
        } else {
            BiomeClimateManager.putTag(registryAccess, isServer);
            BiomeClimateManager.putColorTag(registryAccess, isServer);
            BiomeClimateManager.resetAgroTag(registryAccess, isServer);
        }
    }

    public static void resetBiomeTemps(RegistryAccess registryAccess, boolean isServer) {
        Optional registry6;
        Optional registry = registryAccess.m_6632_(ESRegistries.BIOME_CLIMATE_SETTING);
        Optional registry2 = registryAccess.m_6632_(ESRegistries.SEASON_PHASE);
        Optional registry3 = registryAccess.m_6632_(ESRegistries.SEASON_CYCLE);
        Optional registry4 = registryAccess.m_6632_(ESRegistries.BIOME_RAIN);
        Optional registry5 = registryAccess.m_6632_(ESRegistries.SNOW_TERM);
        Optional optional = registry6 = isServer ? registryAccess.m_6632_(ESRegistries.WEATHER_REGION) : null;
        if (registry.isEmpty()) {
            SimpleUtil.warningForModWrongCalling(ESRegistries.BIOME_CLIMATE_SETTING);
        } else if (registry2.isEmpty()) {
            SimpleUtil.warningForModWrongCalling(ESRegistries.SEASON_PHASE);
        } else if (registry3.isEmpty()) {
            SimpleUtil.warningForModWrongCalling(ESRegistries.SEASON_CYCLE);
        } else if (registry4.isEmpty()) {
            SimpleUtil.warningForModWrongCalling(ESRegistries.BIOME_RAIN);
        } else if (registry5.isEmpty()) {
            SimpleUtil.warningForModWrongCalling(ESRegistries.SNOW_TERM);
        } else if (registry6 != null && registry6.isEmpty()) {
            SimpleUtil.warningForModWrongCalling(ESRegistries.WEATHER_REGION);
        } else {
            if (isServer) {
                BiomeClimateManager.resetSomeMap(registryAccess, (Registry)registry6.get(), WEATHER_REGION_MAP, customRainBuilder -> Pair.of(customRainBuilder.sub(), customRainBuilder.core()), (map, pair) -> map.put((Biome)((Holder)pair.getFirst()).m_203334_(), (Holder)pair.getSecond()), () -> null, (biome, map) -> map);
            }
            if (!isServer && ClientCon.biomeDataPackCache != null) {
                ClientCon.biomeDataPackCache.build(registryAccess, BiomesClimateSettings.class);
            }
            BiomeClimateManager.resetSomeMap(registryAccess, (Registry)registry.get(), BIOME_CLIMATE_MAP, customRainBuilder -> Pair.of(customRainBuilder.biomes(), (Object)customRainBuilder), (map, pair) -> {
                List biomesClimateSettingsList = map.computeIfAbsent((Biome)((Holder)pair.getFirst()).m_203334_(), k -> new ArrayList());
                biomesClimateSettingsList.add((BiomesClimateSettings)pair.getSecond());
            }, List::of, BiomeClimateSettings::new);
            if (!isServer && ClientCon.seasonCycleCache != null) {
                ClientCon.seasonCycleCache.build(registryAccess, SeasonCycle.class);
            }
            BiomeClimateManager.resetSomeMap(registryAccess, (Registry)registry3.get(), SEASON_PHASE_MAP, customRainBuilder -> Pair.of(customRainBuilder.biomes(), customRainBuilder.localMapping().combine()), (map, pair) -> map.put((Biome)((Holder)pair.getFirst()).m_203334_(), (Enum2ObjectMap)pair.getSecond()), () -> new Enum2ObjectMap(SolarTerm.class), (biome, map) -> map);
            if (!isServer && ClientCon.biomeRainCache != null) {
                ClientCon.biomeRainCache.build(registryAccess, CustomRainBuilder.class);
            }
            BiomeClimateManager.resetSomeMap(registryAccess, (Registry)registry4.get(), CUSTOME_BIOME_RAIN_MAP, customRainBuilder -> Pair.of(customRainBuilder.biomes(), customRainBuilder.build()), (map, pair) -> map.put((Biome)((Holder)pair.getFirst()).m_203334_(), (Map)pair.getSecond()), Map::of, (biome, map) -> map);
            if (!isServer && ClientCon.snowTermCache != null) {
                ClientCon.snowTermCache.build(registryAccess, CustomSnowTerm.class);
            }
            BiomeClimateManager.resetSomeMap(registryAccess, (Registry)registry5.get(), CUSTOM_SNOW_TERM_MAP, customRainBuilder -> Pair.of(customRainBuilder.biomes(), (Object)customRainBuilder), (map, pair) -> map.put((Biome)((Holder)pair.getFirst()).m_203334_(), (CustomSnowTerm)pair.getSecond()), () -> null, (biome, map) -> map);
            BiomeClimateManager.setSnowLine(registryAccess, SNOW_LINE_MAP);
        }
    }

    public static <T, U, R, S> void resetSomeMap(RegistryAccess registryAccess, Registry<T> registry, Map<Biome, S> useMap, Function<T, Pair<HolderSet<Biome>, U>> biomeTransfer, BiConsumer<Map<Biome, R>, Pair<Holder<Biome>, U>> singleDeal, Supplier<R> emptyInstance, BiFunction<Biome, R, S> mapSaver) {
        useMap.clear();
        IdentityHashMap biomeUIdentityHashMap = new IdentityHashMap();
        for (T value : ESSortInfo.sorted2(registry)) {
            Pair<HolderSet<Biome>, U> pair = biomeTransfer.apply(value);
            for (Holder next : (HolderSet)pair.getFirst()) {
                singleDeal.accept(biomeUIdentityHashMap, Pair.of((Object)next, (Object)pair.getSecond()));
            }
        }
        Optional biomes = registryAccess.m_6632_(Registries.f_256952_);
        Object objects = emptyInstance.get();
        biomes.ifPresent(biomeRegistry -> biomeRegistry.forEach(biome -> useMap.put((Biome)biome, (Object)mapSaver.apply((Biome)biome, (Object)biomeUIdentityHashMap.getOrDefault(biome, objects)))));
    }

    public static void setSnowLine(RegistryAccess registryAccess, Map<Biome, Integer> biomeIntegerMap) {
        Optional biomeRegistry = registryAccess.m_6632_(Registries.f_256952_);
        if (biomeRegistry.isPresent()) {
            biomeIntegerMap.clear();
            for (List serializable : (List)CommonConfig.Snow.biomeSnowLines.get()) {
                String biomeOrTag = String.valueOf(serializable.get(0));
                int snowLineHeight = Integer.parseInt(String.valueOf(serializable.get(1)));
                if (biomeOrTag.startsWith("#")) {
                    TagKey biomeTagKey = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(biomeOrTag.substring(1, biomeOrTag.length() - 1)));
                    Optional tag = ((Registry)biomeRegistry.get()).m_203431_(biomeTagKey);
                    if (!tag.isPresent()) continue;
                    for (Holder biomeHolder : (HolderSet.Named)tag.get()) {
                        biomeIntegerMap.putIfAbsent((Biome)biomeHolder.m_203334_(), snowLineHeight);
                    }
                    continue;
                }
                Optional holder = ((Registry)biomeRegistry.get()).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(biomeOrTag)));
                if (!holder.isPresent()) continue;
                biomeIntegerMap.putIfAbsent((Biome)((Holder.Reference)holder.get()).m_203334_(), snowLineHeight);
            }
        }
    }

    public static BiomeClimateSettings getBiomeClimateSettings(Biome biome, boolean isServer) {
        BiomeClimateSettings v = BIOME_CLIMATE_MAP.get(biome);
        return v != null ? v : EMPTY;
    }

    public static Map<SolarTerm, CustomRain> getCustomRain(Biome biome, boolean isServer) {
        Map<SolarTerm, CustomRain> v = CUSTOME_BIOME_RAIN_MAP.get(biome);
        return v != null ? v : Map.of();
    }

    @Nullable
    public static ISnowTerm getCustomSnowTerm(Biome biome, boolean isServer) {
        return CUSTOM_SNOW_TERM_MAP.get(biome);
    }

    public static int getSnowLine(Biome biome, boolean isServer) {
        Integer i = SNOW_LINE_MAP.get(biome);
        return i == null ? Integer.MAX_VALUE : i;
    }

    @Deprecated(forRemoval=true, since="0.11")
    public static void updateTemperature(Level level, SolarTerm solarTermIndex) {
    }

    @Deprecated(forRemoval=true, since="0.11")
    public static float agent$GetBaseTemperature(Biome biome) {
        return biome.m_47554_();
    }

    @Deprecated(forRemoval=true, since="0.11")
    public static float fixTemp(Level level, Biome biome, float temp) {
        return temp;
    }

    public static boolean agent$hasPrecipitation(Biome biome) {
        return ((IBiomeTagHolder)biome).eclipticseasons$getBindTag() != ClimateTypeBiomeTags.RAINLESS;
    }

    @Nullable
    public static Holder<Biome> getHolder(RegistryAccess registryAccess, Biome biome) {
        return registryAccess.m_175515_(Registries.f_256952_).m_203611_().filter(biomeReference -> biomeReference.m_203334_() == biome).findFirst().orElse(null);
    }

    @Nullable
    public static Holder<Biome> getHolder(Registry<Biome> registryAccess, Biome biome) {
        return registryAccess.m_203611_().filter(biomeReference -> biomeReference.m_203334_() == biome).findFirst().orElse(null);
    }

    public static TagKey<Biome> getTag(Biome biome) {
        return BIOME_TAG_KEY_MAP.getOrDefault(biome, ClimateTypeBiomeTags.RAINLESS);
    }

    public static TagKey<Biome> getColorTag(Biome biome) {
        return BIOME_COLOR_TAG_KEY_MAP.getOrDefault(biome, ClimateTypeBiomeTags.NONE_COLOR_CHANGE);
    }

    public static Holder<Biome> getWeatherRegionOnwer(Biome biome) {
        return WEATHER_REGION_MAP.getOrDefault(biome, null);
    }

    public static void resetAgroTag(RegistryAccess registryAccess, boolean isServer) {
        BiomeClimateManager.applyBiomeTags(registryAccess, new HashSet<TagKey<Biome>>(ClimateTypeBiomeTags.OVERWORLD_AGRO_BIOME_TYPES), ClimateTypeFilters.OVERWORLD_AGRO_BIOME_PRESENT);
    }

    public static void putColorTag(RegistryAccess registryAccess, boolean isServer) {
        BiomeClimateManager.applyBiomeTags(registryAccess, BIOME_COLOR_TAG_KEY_MAP, new HashSet<TagKey<Biome>>(ClimateTypeBiomeTags.BIOME_COLOR_TYPES), ClimateTypeFilters.COLOR_BIOME_PRESENT, holder -> ClimateTypeBiomeTags.NONE_COLOR_CHANGE, (biome, tag) -> ((IBiomeTagHolder)biome).eclipticseasons$setColorTag((TagKey<Biome>)tag));
    }

    public static void putTag(RegistryAccess registryAccess, boolean isServer) {
        for (Biome biome2 : SMALL_BIOME_MAP.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == isServer).map(Map.Entry::getKey).toList()) {
            SMALL_BIOME_MAP.remove(biome2);
        }
        Optional biomeRegistry = registryAccess.m_6632_(Registries.f_256952_);
        if (biomeRegistry.isPresent()) {
            Optional biomeNamed = ((Registry)biomeRegistry.get()).m_203431_(ClimateTypeBiomeTags.IS_SMALL);
            if (biomeNamed.isPresent()) {
                for (Holder holder2 : (HolderSet.Named)biomeNamed.get()) {
                    SMALL_BIOME_MAP.put((Biome)holder2.m_203334_(), isServer);
                    ((IBiomeTagHolder)holder2.m_203334_()).eclipticseasons$setSmall(true);
                }
            }
            for (TagKey tagKey : ClimateTypeBiomeTags.BIOME_TYPES) {
                TagKey<Biome> oldTag = ClimateTypeBiomeTags.create(tagKey.f_203868_().m_135815_().replace("rain/", ""));
                Optional oldTagApplied = ((Registry)biomeRegistry.get()).m_203431_(oldTag);
                if (!oldTagApplied.isPresent() || ((HolderSet.Named)oldTagApplied.get()).m_203632_() <= 0) continue;
                Object message = "[%s] was deprecated now, please use [%s] instead.".formatted(oldTag.f_203868_(), tagKey.f_203868_());
                message = (String)message + "\nBiome list: " + String.join((CharSequence)",", ((HolderSet.Named)oldTagApplied.get()).m_203614_().map(h -> h.m_203543_().map(ResourceKey::m_135782_).map(ResourceLocation::toString).orElse(null)).filter(Objects::nonNull).toList());
                EclipticSeasons.LOGGER.error((String)message);
            }
        }
        BiomeClimateManager.applyBiomeTags(registryAccess, BIOME_TAG_KEY_MAP, new HashSet<TagKey<Biome>>(ClimateTypeBiomeTags.BIOME_TYPES), ClimateTypeFilters.BIOME_PRESENT, holder -> {
            int size = ClimateTypeBiomeTags.COMMON_BIOME_TYPES.size();
            int index = Mth.m_14045_((int)Mth.m_14143_((float)(((Biome)holder.m_203334_()).getModifiedClimateSettings().f_47683_() * (float)size)), (int)0, (int)(size - 1));
            if (!((Biome)holder.m_203334_()).getModifiedClimateSettings().f_263819_()) {
                index = 0;
            }
            return ClimateTypeBiomeTags.COMMON_BIOME_TYPES.get(index);
        }, (biome, tag) -> ((IBiomeTagHolder)biome).eclipticseasons$setTag((TagKey<Biome>)tag));
    }

    public static void applyBiomeTags(RegistryAccess registryAccess, Set<TagKey<Biome>> knownTags, Map<TagKey<Biome>, RegistryFilter<Biome>> filters) {
        BiomeClimateManager.applyBiomeTags(registryAccess, new IdentityHashMap<Biome, TagKey<Biome>>(), knownTags, filters, holder -> null, (biome, tag) -> {});
    }

    public static void applyBiomeTags(RegistryAccess registryAccess, Map<Biome, TagKey<Biome>> useMap, Set<TagKey<Biome>> knownTags, Map<TagKey<Biome>, RegistryFilter<Biome>> filters, Function<Holder<Biome>, TagKey<Biome>> defaultTag, BiConsumer<Biome, TagKey<Biome>> callback) {
        useMap.clear();
        Optional biomeRegistry = registryAccess.m_6632_(Registries.f_256952_);
        if (biomeRegistry.isEmpty()) {
            return;
        }
        Registry registry = (Registry)biomeRegistry.get();
        HashSet<Holder.Reference> biomeNotSet = new HashSet<Holder.Reference>();
        for (Holder.Reference reference : registry.m_203611_().toList()) {
            Optional<TagKey> tag = knownTags.stream().filter(arg_0 -> ((Holder.Reference)reference).m_203656_(arg_0)).findFirst();
            if (tag.isPresent()) {
                useMap.put((Biome)reference.m_203334_(), (TagKey<Biome>)((TagKey)tag.get()));
                continue;
            }
            biomeNotSet.add(reference);
        }
        for (Map.Entry entry : filters.entrySet()) {
            for (Holder holder : ((RegistryFilter)entry.getValue()).toHolders(registry)) {
                useMap.putIfAbsent((Biome)holder.m_203334_(), (TagKey<Biome>)((TagKey)entry.getKey()));
                biomeNotSet.remove(holder);
            }
        }
        for (Holder holder : biomeNotSet) {
            TagKey<Biome> apply = defaultTag.apply((Holder<Biome>)holder);
            if (apply == null) continue;
            useMap.put((Biome)holder.m_203334_(), apply);
        }
        useMap.forEach(callback);
        BiomeClimateManager.updateTagInVanilla(knownTags, useMap, (Registry<Biome>)registry);
    }

    public static void updateTagInVanilla(Set<TagKey<Biome>> biomeTypes, Map<Biome, TagKey<Biome>> useMap, Registry<Biome> biomeRegistry) {
        if (((Boolean)CommonConfig.Debug.disableUniqueRebindingBiomeTags.get()).booleanValue()) {
            return;
        }
        Map<TagKey, List> biomeMap = biomeRegistry.m_203612_().filter(p -> !biomeTypes.contains(p.getFirst())).collect(Collectors.toMap(Pair::getFirst, p -> ((HolderSet.Named)p.getSecond()).m_203614_().toList()));
        useMap.forEach((biome, biomeTagKey) -> {
            Holder<Biome> holder = BiomeClimateManager.getHolder(biomeRegistry, biome);
            if (holder != null) {
                List holders = biomeMap.computeIfAbsent((TagKey)biomeTagKey, b -> new ArrayList());
                holders.add(holder);
            }
        });
        biomeRegistry.m_203652_(biomeMap);
    }

    public static void clearOnClientExitOrServerClose() {
        WEATHER_REGION_MAP.clear();
        BIOME_CLIMATE_MAP.clear();
        SMALL_BIOME_MAP.clear();
        BIOME_TAG_KEY_MAP.clear();
        SEASON_PHASE_MAP.clear();
        CUSTOME_BIOME_RAIN_MAP.clear();
        CUSTOM_SNOW_TERM_MAP.clear();
    }
}

