/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core;

import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;

public class SolarHolders {
    public static final Map<Level, SolarDataManager> DATA_MANAGER_MAP = new IdentityHashMap<Level, SolarDataManager>();

    @Nullable
    public static SolarDataManager getSaveData(Level level) {
        return DATA_MANAGER_MAP.getOrDefault(level, null);
    }

    public static LazyOptional<SolarDataManager> getSaveDataLazy(Level level) {
        SolarDataManager saveData = SolarHolders.getSaveData(level);
        return LazyOptional.of((NonNullSupplier)(saveData == null ? null : () -> saveData));
    }

    public static void createSaveData(Level level, SolarDataManager solarDataManager) {
        DATA_MANAGER_MAP.put(level, solarDataManager);
    }
}

