/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.climate.BiomeRain;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.api.util.SimpleUtil;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.snow.SnowyMapChecker;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.common.misc.MapExporter;
import com.teamtea.eclipticseasons.common.network.SimpleNetworkHandler;
import com.teamtea.eclipticseasons.common.network.message.EmptyMessage;
import com.teamtea.eclipticseasons.common.network.message.UpdateTempChangeMessage;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.TimeCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="eclipticseasons")
public class CommandHandler {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"time").requires(sourceStack -> sourceStack.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"night").executes(source -> TimeCommand.m_139077_((CommandSourceStack)((CommandSourceStack)source.getSource()), (int)EclipticUtil.getNightTime((Level)((CommandSourceStack)source.getSource()).m_81372_()))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ecliptic").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"solar").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"day", (ArgumentType)IntegerArgumentType.integer()).executes(commandContext -> CommandHandler.setDay((CommandSourceStack)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"day")))))).then(Commands.m_82127_((String)"get").executes(commandContext -> {
            int solar = EclipticUtil.getNowSolarDay((Level)((CommandSourceStack)commandContext.getSource()).m_81372_());
            ((CommandSourceStack)commandContext.getSource()).m_288197_(() -> Component.m_237113_((String)("" + solar)), true);
            return 0;
        }))).then(Commands.m_82127_((String)"setSnowTempChange").then(Commands.m_82129_((String)"tempChange", (ArgumentType)FloatArgumentType.floatArg((float)-0.25f, (float)0.25f)).executes(commandContext -> CommandHandler.setTempChange((CommandSourceStack)commandContext.getSource(), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"tempChange")))))).then(Commands.m_82127_((String)"getSnowTempChange").executes(commandContext -> {
            float snowTempChange = EclipticUtil.getSnowTempChange((Level)((CommandSourceStack)commandContext.getSource()).m_81372_());
            ((CommandSourceStack)commandContext.getSource()).m_288197_(() -> Component.m_237113_((String)("" + snowTempChange)), true);
            return 0;
        }))).then(Commands.m_82127_((String)"setTerm").then(Commands.m_82129_((String)"term", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            String pre = "";
            try {
                pre = (String)context.getArgument("term", String.class);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String finalPre = pre;
            for (SolarTerm solarTerm : SolarTerm.collectValues()) {
                if (solarTerm == SolarTerm.NONE) continue;
                MutableComponent translation = solarTerm.getTranslation();
                String s = solarTerm.getName();
                if (!s.contains(finalPre.toLowerCase(Locale.ROOT))) continue;
                builder.suggest(s, (Message)Component.m_237110_((String)"%s%s%s%s", (Object[])new Object[]{Component.m_237113_((String)"[").m_130940_(ChatFormatting.WHITE), translation.m_130940_(solarTerm.getSeason().getColor()).m_130940_(ChatFormatting.WHITE), Component.m_237113_((String)"] ").m_130940_(ChatFormatting.WHITE), solarTerm.getAlternationText()}));
            }
            return builder.buildFuture();
        }).executes(commandContext -> {
            String s = StringArgumentType.getString((CommandContext)commandContext, (String)"term");
            Enum ss = null;
            for (SolarTerm solarTerm : SolarTerm.collectValues()) {
                if (!solarTerm.getName().equals(s)) continue;
                ss = solarTerm;
                break;
            }
            int day = ss.ordinal() * (Integer)CommonConfig.Season.lastingDaysOfEachTerm.get();
            return CommandHandler.setDay((CommandSourceStack)commandContext.getSource(), day);
        })))).then(Commands.m_82127_((String)"getTerm").executes(commandContext -> {
            SolarTerm solar = EclipticUtil.getNowSolarTerm((Level)((CommandSourceStack)commandContext.getSource()).m_81372_());
            ((CommandSourceStack)commandContext.getSource()).m_288197_(solar::getTranslation, true);
            return 0;
        }))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"day", (ArgumentType)IntegerArgumentType.integer()).executes(commandContext -> CommandHandler.addDay((CommandSourceStack)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"day"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"weather").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"biome", (ArgumentType)ResourceOrTagArgument.m_247455_((CommandBuildContext)event.getBuildContext(), (ResourceKey)Registries.f_256952_)).then(Commands.m_82127_((String)"rain").executes(commandContext -> CommandHandler.setBiomeRain((CommandSourceStack)commandContext.getSource(), (Predicate<Holder<Biome>>)ResourceOrTagArgument.m_245464_((CommandContext)commandContext, (String)"biome", (ResourceKey)Registries.f_256952_), true, false)))).then(Commands.m_82127_((String)"thunder").executes(commandContext -> CommandHandler.setBiomeRain((CommandSourceStack)commandContext.getSource(), (Predicate<Holder<Biome>>)ResourceOrTagArgument.m_245464_((CommandContext)commandContext, (String)"biome", (ResourceKey)Registries.f_256952_), true, true)))).then(Commands.m_82127_((String)"clear").executes(commandContext -> CommandHandler.setBiomeRain((CommandSourceStack)commandContext.getSource(), (Predicate<Holder<Biome>>)ResourceOrTagArgument.m_245464_((CommandContext)commandContext, (String)"biome", (ResourceKey)Registries.f_256952_), false, false)))).then(Commands.m_82127_((String)"snow_depth").then(Commands.m_82129_((String)"depth", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(commandContext -> CommandHandler.setSnowDepth((CommandSourceStack)commandContext.getSource(), (ResourceOrTagArgument.Result<Biome>)ResourceOrTagArgument.m_245464_((CommandContext)commandContext, (String)"biome", (ResourceKey)Registries.f_256952_), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"depth")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"export").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"biome_map").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(stackCommandContext -> MapExporter.exportMap((CommandSourceStack)stackCommandContext.getSource(), BlockPosArgument.m_118242_((CommandContext)stackCommandContext, (String)"pos")))))).then(Commands.m_82127_((String)"humid_charts").then(Commands.m_82129_((String)"namespace", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            String pre = "";
            try {
                pre = (String)context.getArgument("namespace", String.class);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Registry biomes = ((CommandSourceStack)context.getSource()).m_81372_().m_9598_().m_175515_(Registries.f_256952_);
            Set collect = biomes.m_6566_().stream().map(ResourceLocation::m_135827_).collect(Collectors.toSet());
            for (String s : collect) {
                if (!s.contains(pre)) continue;
                builder.suggest(s);
            }
            return builder.buildFuture();
        }).executes(stackCommandContext -> {
            try {
                String s = StringArgumentType.getString((CommandContext)stackCommandContext, (String)"namespace");
                SimpleUtil.exportHumidityChart((Level)((CommandSourceStack)stackCommandContext.getSource()).m_81372_(), s);
                ((CommandSourceStack)stackCommandContext.getSource()).m_288197_(() -> Component.m_237113_((String)("Can find them in " + "%s/humid/%s".formatted("eclipticseasons", s))), true);
            }
            catch (Exception e) {
                ((CommandSourceStack)stackCommandContext.getSource()).m_81352_((Component)Component.m_237113_((String)e.getMessage()));
                return 1;
            }
            return 0;
        })))));
    }

    public static int setSnowDepth(CommandSourceStack sourceStack, ResourceOrTagArgument.Result<Biome> result, int depth) {
        ServerLevel level = sourceStack.m_81372_();
        ArrayList<WeatherManager.BiomeWeather> levelBiomeWeather = WeatherManager.getBiomeList((Level)level);
        if (levelBiomeWeather != null) {
            boolean found = false;
            for (WeatherManager.BiomeWeather biomeWeather : levelBiomeWeather) {
                if (!result.test(biomeWeather.biomeHolder)) continue;
                biomeWeather.snowDepth = (byte)depth;
                biomeWeather.lastRainTime = level.m_46467_();
                found = true;
            }
            if (found) {
                WeatherManager.sendBiomePacket(levelBiomeWeather, level.m_6907_());
                SnowyMapChecker.updateAllChunks(level);
                SimpleNetworkHandler.send(level.m_6907_(), new EmptyMessage());
            }
        }
        return 0;
    }

    public static int setBiomeRain(CommandSourceStack sourceStack, Predicate<Holder<Biome>> result, boolean setRain, boolean isThunder) throws CommandSyntaxException {
        ServerLevel level = sourceStack.m_81372_();
        ArrayList<WeatherManager.BiomeWeather> levelBiomeWeather = WeatherManager.getBiomeList((Level)level);
        if (levelBiomeWeather != null) {
            boolean found = false;
            int size = WeatherManager.getWeatherTickFactor((Level)level);
            SolarTerm solarTerm = EclipticSeasonsApi.getInstance().getSolarTerm((Level)level);
            for (WeatherManager.BiomeWeather biomeWeather : levelBiomeWeather) {
                if (!result.test(biomeWeather.biomeHolder)) continue;
                BiomeRain biomeRain = WeatherManager.getBiomeRain(level, solarTerm, biomeWeather.biomeHolder);
                biomeWeather.clearTime = setRain ? 0 : biomeRain.getRainDelay(level.m_213780_()) / size;
                biomeWeather.rainTime = setRain ? biomeRain.getRainDuration(level.m_213780_()) / size : 0;
                biomeWeather.lastRainTime = setRain ? level.m_46467_() : biomeWeather.lastRainTime;
                biomeWeather.thunderTime = isThunder ? biomeRain.getThunderDuration(level.m_213780_()) / size : 0;
                found = true;
            }
            if (found) {
                WeatherManager.sendBiomePacket(levelBiomeWeather, level.m_6907_());
            }
        }
        return 0;
    }

    private static int getDay(ServerLevel worldIn) {
        return SolarHolders.getSaveDataLazy((Level)worldIn).map(SolarDataManager::getSolarTermsDay).orElse(0);
    }

    public static int setDay(CommandSourceStack source, int day) {
        for (ServerLevel ServerLevel2 : List.of(source.m_81372_())) {
            SolarHolders.getSaveDataLazy((Level)ServerLevel2).ifPresent(data -> {
                data.setSolarTermsDay(day);
                data.sendAndUpdate(ServerLevel2);
            });
        }
        source.m_288197_(() -> Component.m_237110_((String)"commands.eclipticseasons.solar.set", (Object[])new Object[]{day}), true);
        return CommandHandler.getDay(source.m_81372_());
    }

    public static int setTempChange(CommandSourceStack source, float tempChange) {
        for (ServerLevel serverLevel : List.of(source.m_81372_())) {
            SolarHolders.getSaveDataLazy((Level)serverLevel).ifPresent(data -> {
                data.setSolarTempChange(tempChange);
                SimpleNetworkHandler.send(serverLevel.m_6907_(), new UpdateTempChangeMessage(tempChange));
            });
        }
        source.m_288197_(() -> Component.m_237113_((String)("" + tempChange)), true);
        return 0;
    }

    public static int addDay(CommandSourceStack source, int add) {
        for (ServerLevel ServerLevel2 : List.of(source.m_81372_())) {
            SolarHolders.getSaveDataLazy((Level)ServerLevel2).ifPresent(data -> {
                data.setSolarTermsDay(data.getSolarTermsDay() + add);
                data.sendAndUpdate(ServerLevel2);
                source.m_288197_(() -> Component.m_237110_((String)"commands.eclipticseasons.solar.set", (Object[])new Object[]{data.getSolarTermsDay()}), true);
            });
        }
        return CommandHandler.getDay(source.m_81372_());
    }
}

