/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block.blockentity;

import com.mojang.serialization.DynamicOps;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.craft.HumidityControl;
import com.teamtea.eclipticseasons.api.data.misc.ESSortInfo;
import com.teamtea.eclipticseasons.api.data.misc.PosAndBlockStateCheck;
import com.teamtea.eclipticseasons.api.util.SimpleUtil;
import com.teamtea.eclipticseasons.common.block.blockentity.base.SyncBlockEntity;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.crop.HumidityControlProvider;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class HumidityControlBlockEntity
extends SyncBlockEntity {
    protected HumidityControl humidityControl;
    protected int time = 0;

    public HumidityControlBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.humidity_control_entity_type.get(), pos, state);
    }

    public HumidityControlBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("time", this.time);
        if (this.humidityControl != null) {
            RegistryOps registryops = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)this.f_58857_.m_9598_());
            HumidityControl.CODEC.encodeStart((DynamicOps)registryops, (Object)this.humidityControl).resultOrPartial(EclipticSeasons::logger).ifPresent(tag1 -> tag.m_128365_("humidity_control", tag1));
        }
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.time = tag.m_128451_("time");
        if (tag.m_128441_("humidity_control")) {
            RegistryAccess registryAccess = SimpleUtil.getRegistryAccess(this);
            RegistryOps registryops = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)registryAccess);
            HumidityControl.CODEC.parse((DynamicOps)registryops, (Object)tag.m_128423_("humidity_control")).resultOrPartial(EclipticSeasons::logger).ifPresent(seasonQuest1 -> {
                this.humidityControl = seasonQuest1;
            });
        } else {
            this.humidityControl = null;
        }
    }

    public void m_7651_() {
        SolarDataManager manager = SolarHolders.getSaveData(this.f_58857_);
        if (manager != null) {
            manager.removeHumidityControlProvider(this.m_58899_());
        }
        super.m_7651_();
    }

    protected boolean isRecipeCacheValid(@NotNull HumidityControl humidityControl) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (PosAndBlockStateCheck c : humidityControl.checks()) {
                if (c.matches(serverLevel, this.m_58899_())) continue;
                return false;
            }
        }
        return true;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, HumidityControlBlockEntity blockEntity) {
        SolarDataManager manager = SolarHolders.getSaveData(level);
        int hl = blockEntity.getHumidityModifiedLevel();
        float rl = blockEntity.getHumidityModifiedRange();
        if (manager != null) {
            HumidityControlProvider nearHumidityControlProvider = manager.queryHumidityControlProvider(blockPos);
            if (nearHumidityControlProvider != null && (float)hl == nearHumidityControlProvider.getLevel() && rl == nearHumidityControlProvider.getRange()) {
                if (nearHumidityControlProvider.getRemainTime() < 10) {
                    nearHumidityControlProvider.addRemainTime(100);
                }
            } else if (hl != 0) {
                manager.addHumidityControlProvider(blockPos, new HumidityControlProvider(hl, rl, 240));
            } else if (nearHumidityControlProvider != null) {
                manager.removeHumidityControlProvider(blockPos);
            }
        }
        blockEntity.endTick();
        blockEntity.searchRecipe();
    }

    protected void searchRecipe() {
        if (this.humidityControl == null) {
            for (HumidityControl humidityControl : ESSortInfo.sorted2(this.f_58857_.m_9598_().m_175515_(ESRegistries.HUMIDITY_CONTROL))) {
                if (!this.isRecipeCacheValid(humidityControl)) continue;
                this.humidityControl = humidityControl;
                this.time = humidityControl.lasting_time();
                this.m_6596_();
                break;
            }
        }
    }

    protected boolean hasNoRecipe() {
        return this.humidityControl == null;
    }

    protected void endTick() {
        if (this.humidityControl != null && this.time <= 0) {
            this.endRecipe();
        } else if (this.humidityControl != null && this.isRecipeCacheValid(this.humidityControl)) {
            if (!this.humidityControl.noCost()) {
                --this.time;
                this.m_6596_();
            }
        } else if (this.humidityControl != null || this.time > 0) {
            this.resetRecipe();
        }
    }

    protected void endRecipe() {
        this.humidityControl = null;
        this.time = 0;
        this.m_6596_();
    }

    protected void resetRecipe() {
        this.humidityControl = null;
        this.time = 0;
        this.m_6596_();
    }

    public int getHumidityModifiedLevel() {
        return this.humidityControl != null && this.isRecipeCacheValid(this.humidityControl) ? this.humidityControl.level() : 0;
    }

    public int getHumidityModifiedRange() {
        return this.humidityControl != null && this.isRecipeCacheValid(this.humidityControl) ? this.humidityControl.range() : 0;
    }
}

