/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block;

import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.block.base.WallPlacedBlock;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.common.misc.SimpleVoxelShapeUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HygrometerBlock
extends WallPlacedBlock {
    public final VoxelShape[] shapes1 = new VoxelShape[4];
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;

    public HygrometerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        VoxelShape base = Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.75, (double)0.9375, (double)0.6875, (double)1.0);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.shapes1[direction.m_122416_()] = SimpleVoxelShapeUtils.rotateVoxelShape(base, Direction.Axis.Y, HygrometerBlock.getRotateYByFacing((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)));
        }
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapes1[((Direction)pState.m_61143_((Property)FACING)).m_122416_()];
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213898_(state, level, pos, random);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213897_(state, level, pos, random);
        HygrometerBlock.updateLevel(level, state, pos);
        level.m_186460_(pos, (Block)this, 200);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{POWER}));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return null;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return HygrometerBlock.getNewState(context.m_43725_(), super.m_5573_(context), context.m_8083_());
    }

    private static void updateLevel(ServerLevel level, BlockState state, BlockPos pos) {
        BlockState oldState = state;
        if ((state = HygrometerBlock.getNewState((Level)level, state, pos)) != oldState) {
            level.m_7731_(pos, state, 3);
            level.m_247517_(null, pos, SoundEvents.f_144225_, SoundSource.BLOCKS);
        }
    }

    private static BlockState getNewState(Level level, BlockState state, BlockPos pos) {
        SolarDataManager data = SolarHolders.getSaveData(level);
        if (data != null) {
            BlockPos checkPos = pos.m_121945_((Direction)state.m_61143_((Property)FACING));
            float chance = 0.0f;
            for (int i = 0; i < 20; ++i) {
                chance += CropGrowthHandler.isInRoom((LevelAccessor)level, checkPos, level.m_8055_(checkPos), Optional.of(HolderSet.m_205809_((Holder[])new Holder[]{state.m_60734_().m_204297_()}))) ? 1.0f : 0.0f;
            }
            float humidityAt = EclipticUtil.getHumidityLevelAt(level, data.getSolarTerm(), CropGrowthHandler.getCropBiome((LevelAccessor)level, pos), pos, !level.m_5776_());
            if (chance > 8.0f) {
                humidityAt += level.m_5776_() ? ClientCon.humidityModificationLevel : data.calculateHumidityModification(checkPos);
            }
            int p = HygrometerBlock.getPowerFromHumidityLevel(Humidity.getHumid(humidityAt).ordinal());
            state = (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(p));
        }
        return state;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.m_61143_((Property)POWER);
    }

    public static int getHumidityLevelFromPower(int power) {
        return Mth.m_14045_((int)Math.round((float)power * 4.0f / 15.0f), (int)0, (int)4);
    }

    public static int getPowerFromHumidityLevel(int humidityLevel) {
        return Math.round((float)humidityLevel * 15.0f / 4.0f);
    }
}

