/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block;

import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.client.particle.ColorParticleOptions;
import com.teamtea.eclipticseasons.common.block.base.SimpleEntityBlock;
import com.teamtea.eclipticseasons.common.block.blockentity.GreenHouseCoreBlockEntity;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import com.teamtea.eclipticseasons.common.registry.ItemRegistry;
import com.teamtea.eclipticseasons.common.registry.ParticleRegistry;
import com.teamtea.eclipticseasons.config.ClientConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class GreenHouseCoreBlock
extends SimpleEntityBlock {
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    private final Season season;

    public GreenHouseCoreBlock(Season season, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
        this.season = season;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{POWER}));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)BlockEntityRegistry.greenhouse_core_entity_type.get()).m_155264_(pPos, pState);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        if (!((Boolean)ClientConfig.Particle.seasonGreenhouse.get()).booleanValue()) {
            return;
        }
        int count = (Integer)ClientConfig.Particle.SeasonGreenhouseParticleSpawnCount.get();
        Direction direction = Direction.DOWN;
        Integer color = this.getSeason().getColor().m_126665_();
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        ColorParticleOptions colorParticleOption = new ColorParticleOptions(new Vector3f(r, g, b), 1.0f);
        colorParticleOption.updateType(ParticleRegistry.GREENHOUSE);
        for (int i = 0; i < count; ++i) {
            boolean inRoom;
            double z;
            double y;
            double d0 = (double)pos.m_123341_() + (random.m_188500_() * 32.0 - 16.0);
            double d1 = (double)pos.m_123342_() - 0.5 - random.m_188500_() * 10.0 + 2.0;
            double d2 = (double)pos.m_123343_() + (random.m_188500_() * 32.0 - 16.0);
            double d3 = (random.m_188500_() - 0.5) * 0.4;
            double x = d0 + (double)direction.m_122429_() * d3;
            BlockPos blockPos = new BlockPos((int)x, (int)(y = d1 + (double)direction.m_122430_() * d3), (int)(z = d2 + (double)direction.m_122431_() * d3));
            boolean bl = inRoom = level.m_46859_(blockPos) && CropGrowthHandler.isInRoom((LevelAccessor)level, blockPos, Blocks.f_50016_.m_49966_(), Optional.of(HolderSet.m_205809_((Holder[])new Holder[0])));
            if (!inRoom) continue;
            level.m_7106_((ParticleOptions)colorParticleOption, x, y, z, random.m_188583_() * 0.005, 0.005 + random.m_188500_() * 0.02, random.m_188583_() * 0.005);
        }
    }

    public Season getSeason() {
        return this.season;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level worldIn, BlockState state, BlockEntityType<T> blockEntityType) {
        return !worldIn.f_46443_ ? GreenHouseCoreBlock.m_152132_(blockEntityType, (BlockEntityType)BlockEntityRegistry.greenhouse_core_entity_type.get(), GreenHouseCoreBlockEntity::tick) : null;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.m_61143_((Property)POWER);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level level, @NotNull BlockPos pos, Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        if (pPlayer.m_6144_() && pPlayer.m_21120_(pHand).m_41619_()) {
            if (level instanceof ServerLevel) {
                level.m_247517_(null, pos, SoundEvents.f_144224_, SoundSource.BLOCKS);
                Item item = switch (this.getSeason()) {
                    case Season.SPRING -> (Item)ItemRegistry.spring_greenhouse_essence_item.get();
                    case Season.SUMMER -> (Item)ItemRegistry.summer_greenhouse_essence_item.get();
                    case Season.AUTUMN -> (Item)ItemRegistry.autumn_greenhouse_essence_item.get();
                    case Season.WINTER -> (Item)ItemRegistry.winter_greenhouse_essence_item.get();
                    default -> Items.f_41852_;
                };
                Block.m_49840_((Level)level, (BlockPos)pos.m_7494_(), (ItemStack)new ItemStack((ItemLike)item));
                level.m_46597_(pos, ((Block)BlockRegistry.greenhouse_core_container.get()).m_49966_());
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(pState, level, pos, pPlayer, pHand, pHit);
    }
}

