/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.data.climate.BiomesClimateSettings;
import com.teamtea.eclipticseasons.api.data.craft.HumidityControl;
import com.teamtea.eclipticseasons.api.data.crop.CropGrowControlBuilder;
import com.teamtea.eclipticseasons.api.data.misc.ESSortInfo;
import com.teamtea.eclipticseasons.api.data.season.SeasonCycle;
import com.teamtea.eclipticseasons.api.data.season.SnowDefinition;
import com.teamtea.eclipticseasons.api.data.weather.CustomRainBuilder;
import com.teamtea.eclipticseasons.api.data.weather.CustomSnowTerm;
import com.teamtea.eclipticseasons.api.event.CanPlantGrowEvent;
import com.teamtea.eclipticseasons.api.misc.IChunkBiomeHolder;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.advancement.SolarTermsRecord;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.biome.BiomeClimateManager;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.crop.CropInfoManager;
import com.teamtea.eclipticseasons.common.core.crop.NaturalPlantHandler;
import com.teamtea.eclipticseasons.common.core.map.BiomeHolder;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyMapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyStatusKeeper;
import com.teamtea.eclipticseasons.common.core.snow.WeatherStatusKeeper;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.common.network.SimpleNetworkHandler;
import com.teamtea.eclipticseasons.common.network.message.DataPackEventMessage;
import com.teamtea.eclipticseasons.common.network.message.HumidModifyMessage;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import com.teamtea.eclipticseasons.common.registry.ModAdvancements;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="eclipticseasons")
public class AllListener {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onTagsUpdatedEventEarly(TagsUpdatedEvent tagsUpdatedEvent) {
        ESSortInfo.resetUpdate(tagsUpdatedEvent.getRegistryAccess(), tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD);
        BiomeClimateManager.resetBiomeTags(tagsUpdatedEvent.getRegistryAccess(), tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD);
    }

    @SubscribeEvent
    public static void onTagsUpdatedEvent(TagsUpdatedEvent tagsUpdatedEvent) {
        BiomeClimateManager.resetBiomeTemps(tagsUpdatedEvent.getRegistryAccess(), tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD);
        WeatherManager.informUpdateBiomes(tagsUpdatedEvent.getRegistryAccess(), tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD);
        CropInfoManager.init(tagsUpdatedEvent);
        CropGrowthHandler.resetUpdate(tagsUpdatedEvent.getRegistryAccess(), tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD);
        NaturalPlantHandler.resetUpdate(tagsUpdatedEvent.getRegistryAccess(), tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD);
        SnowChecker.resetUpdate(tagsUpdatedEvent.getRegistryAccess(), tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD);
    }

    @SubscribeEvent
    public static void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        WeatherManager.BIOME_WEATHER_LIST.clear();
        WeatherManager.NEXT_CHECK_BIOME_MAP.clear();
        WeatherManager.BIOME_WEATHER_QUERY_LIST.clear();
    }

    @SubscribeEvent
    public static void onServerStoppingEvent(ServerStoppingEvent event) {
        CropGrowthHandler.clearOnClientExitOrServerClose();
        NaturalPlantHandler.clearOnClientExitOrServerClose();
        BiomeClimateManager.clearOnClientExitOrServerClose();
        SnowChecker.clearOnClientExitOrServerClose();
        ESSortInfo.clearOnClientExitOrServerClose();
    }

    @SubscribeEvent
    public static void onSleepFinishedTimeEvent(PlayerSleepInBedEvent event) {
        if (event.getResultStatus() == Player.BedSleepingProblem.NOT_POSSIBLE_NOW) {
            BlockPos pos = event.getPos();
            Level level = event.getEntity().m_9236_();
            if (pos != null && EclipticUtil.hasLocalWeather(level) && WeatherManager.isThunderAtBiome(level, pos)) {
                event.setResult((Player.BedSleepingProblem)null);
            }
        }
    }

    @SubscribeEvent
    public static void onSleepFinishedTimeEvent(SleepingTimeCheckEvent event) {
        if (event.getResult() == Event.Result.DEFAULT) {
            BlockPos pos = event.getSleepingLocation().orElse(null);
            Level level = event.getEntity().m_9236_();
            if (pos != null && EclipticUtil.hasLocalWeather(level) && WeatherManager.isThunderAtBiome(level, pos)) {
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public static void onSleepFinishedTimeEvent(SleepFinishedTimeEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            long newTime = event.getNewTime();
            long oldDayTime = level.m_46468_();
            WeatherManager.updateAfterSleep(level, newTime, oldDayTime);
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            if (((List)CommonConfig.Season.validDimensions.get()).contains(level.m_46472_().m_135782_().toString())) {
                MapChecker.validDimension.add((Level)level);
            }
            WeatherManager.createLevelBiomeWeatherList((Level)level);
            SolarHolders.createSaveData((Level)level, SolarDataManager.get(level));
        }
    }

    @SubscribeEvent
    public static void onLevelUnloadEvent(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            WeatherManager.BIOME_WEATHER_LIST.remove(level);
            WeatherManager.NEXT_CHECK_BIOME_MAP.remove(level);
            WeatherManager.BIOME_WEATHER_QUERY_LIST.remove(level);
            SolarHolders.DATA_MANAGER_MAP.remove(level);
            if (!level.m_5776_()) {
                // empty if block
            }
            MapChecker.validDimension.removeIf(l -> l.equals(level));
        }
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Watch event) {
        MapChecker.sendChunkLoginInfo(event.getLevel(), event.getChunk(), event.getPos(), event.getPlayer());
        SnowyMapChecker.sendChunkLoginInfo$1_20_1(event.getLevel(), event.getChunk(), event.getPos(), event.getPlayer());
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        ChunkAccess chunk = event.getChunk();
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            BiomeHolder biomeHolder = null;
            LevelAccessor levelAccessor2 = event.getLevel();
            if (levelAccessor2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelAccessor2;
                if (event.isNewChunk()) {
                    MapChecker.setNewChunk(serverLevel, chunk);
                }
                biomeHolder = MapChecker.getOrUpdateChunkBiomeData(serverLevel, (IChunkBiomeHolder)chunk, event.getChunk().m_7697_());
            }
            ChunkInfoMap chunkInfoMap = MapChecker.forceChunkUpdateHeight(level, chunk);
            if (EclipticUtil.canSnowyBlockInteract() && biomeHolder != null && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int biomeDataVersion = EclipticUtil.getBiomeDataVersion(level);
                if (biomeHolder.version() != biomeDataVersion || !biomeHolder.hasUpdated()) {
                    biomeHolder = null;
                }
                if (biomeHolder != null) {
                    SnowyMapChecker.forceChunkUpdateHeight(serverLevel, chunk, chunkInfoMap, biomeHolder, true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onChunkUnloadEvent(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            MapChecker.unloadChunk(level, event.getChunk().m_7697_());
            CropGrowthHandler.unloadChunk(level, event.getChunk().m_7697_());
        }
    }

    @SubscribeEvent
    public static void onChunkDataSaveEvent(ChunkDataEvent.Save event) {
        Level level;
        SolarDataManager data;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && (data = SolarHolders.getSaveData(level = (Level)levelAccessor)) != null) {
            data.saveChunk(event.getChunk().m_7697_(), event.getData());
        }
    }

    @SubscribeEvent
    public static void onChunkDataLoadEvent(ChunkDataEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            SolarHolders.getSaveDataLazy(level).ifPresent(solarDataManager -> solarDataManager.loadChunk(event.getChunk().m_7697_(), event.getData()));
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            Level level = event.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                SolarDataManager data = SolarHolders.getSaveData(event.level);
                if (data != null) {
                    data.tickLevel(serverLevel);
                }
            }
            MapChecker.tickLevel(event.level);
        }
    }

    @SubscribeEvent
    public static void onLevelTickPre(TickEvent.LevelTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START) && event.level instanceof ServerLevel) {
            WeatherManager.tickAverageWeather(event.level);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickPost(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            Level level;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (event.phase == TickEvent.Phase.START) {
                WeatherManager.tickPlayerSeasonEffect(serverPlayer);
            }
            if (event.phase == TickEvent.Phase.END && (level = serverPlayer.m_9236_()).m_46467_() % 20L == 0L) {
                ModAdvancements.parentNeedCriterion.trigger(serverPlayer);
                SolarDataManager data = SolarHolders.getSaveData(level);
                if (data != null) {
                    float v = data.calculateHumidityModification(serverPlayer.m_20183_());
                    SimpleNetworkHandler.send(serverPlayer, new HumidModifyMessage(serverPlayer.m_20183_(), Mth.m_14143_((float)v)));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!(event.getEntity() instanceof FakePlayer)) {
                WeatherManager.onLoggedIn(serverPlayer, true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            WeatherManager.onLoggedIn(serverPlayer, false);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Thread t = new Thread(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                WeatherManager.onLoggedIn(serverPlayer, false);
            });
            t.start();
        }
    }

    @SubscribeEvent
    public static void onCropGrowUp(CanPlantGrowEvent event) {
        CropGrowthHandler.beforeCropGrowUp(event);
    }

    @SubscribeEvent
    public static void onCropGrowUp(BlockEvent.CropGrowEvent.Pre event) {
        if (!CommonConfig.isForceCropCompatMode()) {
            CropGrowthHandler.beforeCropGrowUp(event);
        }
    }

    @SubscribeEvent
    public static void onSaplingGrowTree(SaplingGrowTreeEvent event) {
        CropGrowthHandler.beforeCropGrowUp(event);
    }

    @SubscribeEvent
    public static void onSaplingGrowTree(BonemealEvent event) {
        CropGrowthHandler.beforeCropGrowUp(event);
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesEvent(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(EclipticSeasons.rl("solar_term_holder"), (ICapabilityProvider)new SolarTermsRecord());
        }
    }

    @SubscribeEvent
    public static void onLevelChunkAttachCapabilitiesEvent(AttachCapabilitiesEvent<LevelChunk> event) {
        if (event.getObject() instanceof LevelChunk) {
            event.addCapability(EclipticSeasons.rl("biomes_holder"), (ICapabilityProvider)BiomeHolder.empty());
            event.addCapability(EclipticSeasons.rl("snowy_status"), (ICapabilityProvider)SnowyStatusKeeper.create());
            event.addCapability(EclipticSeasons.rl("weather_status"), (ICapabilityProvider)WeatherStatusKeeper.create());
        }
    }

    @SubscribeEvent
    public static void onOnDatapackSyncEvent(OnDatapackSyncEvent event) {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return;
        }
        RegistryAccess.Frozen registryAccess = ServerLifecycleHooks.getCurrentServer().m_206579_();
        ServerPlayer player = event.getPlayer();
        List serverPlayerList = player == null ? event.getPlayerList().m_11314_() : List.of(player);
        SimpleNetworkHandler.send(serverPlayerList, new DataPackEventMessage<HumidityControl>((RegistryAccess)registryAccess, ESRegistries.HUMIDITY_CONTROL, registryAccess.m_175515_(ESRegistries.HUMIDITY_CONTROL).m_6579_(), HumidityControl.CODEC));
        SimpleNetworkHandler.send(serverPlayerList, new DataPackEventMessage<BiomesClimateSettings>((RegistryAccess)registryAccess, ESRegistries.BIOME_CLIMATE_SETTING, registryAccess.m_175515_(ESRegistries.BIOME_CLIMATE_SETTING).m_6579_(), BiomesClimateSettings.CODEC));
        SimpleNetworkHandler.send(serverPlayerList, new DataPackEventMessage<SnowDefinition>((RegistryAccess)registryAccess, ESRegistries.SNOW_DEFINITIONS, registryAccess.m_175515_(ESRegistries.SNOW_DEFINITIONS).m_6579_(), SnowDefinition.CODEC));
        SimpleNetworkHandler.send(serverPlayerList, new DataPackEventMessage<SeasonCycle>((RegistryAccess)registryAccess, ESRegistries.SEASON_CYCLE, registryAccess.m_175515_(ESRegistries.SEASON_CYCLE).m_6579_(), SeasonCycle.CODEC));
        SimpleNetworkHandler.send(serverPlayerList, new DataPackEventMessage<CustomRainBuilder>((RegistryAccess)registryAccess, ESRegistries.BIOME_RAIN, registryAccess.m_175515_(ESRegistries.BIOME_RAIN).m_6579_(), CustomRainBuilder.CODEC));
        SimpleNetworkHandler.send(serverPlayerList, new DataPackEventMessage<CustomSnowTerm>((RegistryAccess)registryAccess, ESRegistries.SNOW_TERM, registryAccess.m_175515_(ESRegistries.SNOW_TERM).m_6579_(), CustomSnowTerm.CODEC));
        SimpleNetworkHandler.send(serverPlayerList, new DataPackEventMessage<AgroClimaticZone>((RegistryAccess)registryAccess, ESRegistries.AGRO_CLIMATE, registryAccess.m_175515_(ESRegistries.AGRO_CLIMATE).m_6579_(), AgroClimaticZone.CODEC));
        SimpleNetworkHandler.send(serverPlayerList, new DataPackEventMessage<CropGrowControlBuilder>((RegistryAccess)registryAccess, ESRegistries.CROP, registryAccess.m_175515_(ESRegistries.CROP).m_6579_(), CropGrowControlBuilder.CODEC));
    }
}

