/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.util;

import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.data.climate.BiomesClimateSettings;
import com.teamtea.eclipticseasons.api.data.craft.HumidityControl;
import com.teamtea.eclipticseasons.api.data.crop.CropGrowControlBuilder;
import com.teamtea.eclipticseasons.api.data.season.SeasonCycle;
import com.teamtea.eclipticseasons.api.data.season.SnowDefinition;
import com.teamtea.eclipticseasons.api.data.weather.CustomRainBuilder;
import com.teamtea.eclipticseasons.api.data.weather.CustomSnowTerm;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.common.misc.ClientAgent;
import com.teamtea.eclipticseasons.common.network.message.DataPackEventMessage;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongBooleanImmutablePair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class ClientCon {
    public static final Long2ObjectOpenHashMap<LongBooleanImmutablePair> roomCache = new Long2ObjectOpenHashMap();
    public static float humidityModificationLevel;
    private static Level useLevel;
    private static Level nextLevel;
    public static SolarTerm nowSolarTerm;
    public static Season nowSeason;
    public static int nowSolarYear;
    public static boolean isDay;
    public static boolean isEvening;
    public static boolean isNoon;
    public static int progress;
    public static final List<HumidityControl> humidityControls;
    public static DataPackEventMessage<BiomesClimateSettings> biomeDataPackCache;
    public static DataPackEventMessage<SnowDefinition> snowDefCache;
    public static DataPackEventMessage<SeasonCycle> seasonCycleCache;
    public static DataPackEventMessage<CustomRainBuilder> biomeRainCache;
    public static DataPackEventMessage<CustomSnowTerm> snowTermCache;
    public static DataPackEventMessage<AgroClimaticZone> aczCache;
    public static DataPackEventMessage<CropGrowControlBuilder> cropCache;
    public static ClientAgent agent;
    public static String ServerName;

    public static void tick(Level clientLevel) {
        if (MapChecker.isValidDimension(clientLevel)) {
            nowSolarTerm = EclipticUtil.getNowSolarTerm(clientLevel);
            nowSeason = EclipticSeasonsApi.getInstance().getAgroSeason(clientLevel, agent.getCameraEntity() == null ? BlockPos.f_121853_ : agent.getCameraEntity().m_20183_());
            isDay = EclipticUtil.isDay(clientLevel);
            isEvening = EclipticUtil.isEvening(clientLevel);
            isNoon = EclipticUtil.isNoon(clientLevel);
            SolarDataManager saveData = SolarHolders.getSaveData(clientLevel);
            if (saveData != null) {
                progress = Mth.m_14045_((int)Mth.m_14143_((float)(((float)saveData.getSolarTermDaysInPeriod() + (float)Mth.m_14143_((float)((float)((clientLevel.m_46468_() + 24000L) % 24000L) / 24000.0f * 10.0f)) / 10.0f) * 100.0f / (float)saveData.getSolarTermLastingDays())), (int)0, (int)100);
            }
            nowSolarYear = EclipticUtil.getNowSolarYear(clientLevel);
        } else {
            nowSolarTerm = SolarTerm.NONE;
            nowSeason = Season.NONE;
            isDay = false;
            isEvening = false;
            isNoon = false;
            progress = 0;
            nowSolarYear = 0;
        }
        if (!roomCache.isEmpty()) {
            long gameTime = clientLevel.m_46467_();
            roomCache.entrySet().removeIf(entry -> gameTime > ((LongBooleanImmutablePair)entry.getValue()).leftLong() + 100L);
        }
    }

    public static Level getUseLevel() {
        return useLevel;
    }

    public static void setUseLevel(Level level) {
        if (level == null) {
            useLevel = null;
            if (nextLevel != null) {
                useLevel = nextLevel;
                nextLevel = null;
            }
        } else if (useLevel == null) {
            useLevel = level;
        } else {
            nextLevel = level;
        }
    }

    public static void onClientPlayerExit() {
        humidityControls.clear();
        biomeDataPackCache = null;
        snowDefCache = null;
        seasonCycleCache = null;
        biomeRainCache = null;
        snowTermCache = null;
        aczCache = null;
        cropCache = null;
        roomCache.clear();
        humidityModificationLevel = 0.0f;
    }

    static {
        nowSolarTerm = SolarTerm.NONE;
        nowSeason = Season.NONE;
        nowSolarYear = 0;
        isDay = false;
        isEvening = false;
        isNoon = false;
        progress = 0;
        humidityControls = new ArrayList<HumidityControl>();
        agent = new ClientAgent(){};
        ServerName = "client";
    }
}

