/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.sound;

import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.solar.TimePeriod;
import com.teamtea.eclipticseasons.api.data.client.SeasonalBiomeAmbient;
import com.teamtea.eclipticseasons.client.sound.LoopSeasonalSoundInstance;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.client.util.ClientRef;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.AmbientSoundHandler;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;

public class SeasonalBiomeAmbientSoundsHandler
implements AmbientSoundHandler {
    private final LocalPlayer player;
    private final SoundManager soundManager;
    private final BiomeManager biomeManager;
    private final RandomSource random;
    @Nullable
    private Biome previousBiome;
    private Season previousSeason;
    private boolean previousIsDay;
    private final Set<LoopSeasonalSoundInstance> loopSounds = new HashSet<LoopSeasonalSoundInstance>();

    public SeasonalBiomeAmbientSoundsHandler(LocalPlayer localPlayer, SoundManager soundManager, BiomeManager biomeManager) {
        this.random = localPlayer.m_9236_().m_213780_();
        this.player = localPlayer;
        this.soundManager = soundManager;
        this.biomeManager = biomeManager;
    }

    public void m_7551_() {
        this.loopSounds.removeIf(AbstractTickableSoundInstance::m_7801_);
        Level level = this.player.m_9236_();
        boolean indoor = level.m_5518_().m_75814_(LightLayer.SKY).m_7768_(this.player.m_20183_()) < 12;
        Holder biome = this.biomeManager.m_204206_(this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_());
        SolarTerm solarTerm = ClientCon.nowSolarTerm;
        Season season = ClientCon.nowSeason;
        boolean isDayNow = ClientCon.isDay;
        if (biome.m_203334_() != this.previousBiome) {
            this.previousBiome = (Biome)biome.m_203334_();
        }
        if (season != this.previousSeason || isDayNow != this.previousIsDay) {
            this.previousSeason = season;
            this.previousIsDay = isDayNow;
        }
        SoundEvent soundEvent = null;
        if (MapChecker.isValidDimension(level)) {
            boolean raining = level.m_46471_();
            TimePeriod timePeriod = TimePeriod.fromTimeOfDay(level.m_46942_(1.0f));
            boolean inWater = this.player.m_20069_();
            ArrayList<SeasonalBiomeAmbient> seasonalBiomeAmbientList = new ArrayList<SeasonalBiomeAmbient>();
            for (SeasonalBiomeAmbient sound : ClientRef.sounds) {
                if (sound.isIndoor() != indoor || sound.isRain() != raining || (sound.getSeason() == Season.NONE ? !solarTerm.isInTerms(sound.getStart(), sound.getEnd()) : sound.getSeason() != season) || !sound.isIgnore_time() && (sound.getTimePeriod() == TimePeriod.NONE ? sound.isDay() != isDayNow : sound.getTimePeriod() != timePeriod)) continue;
                if (sound.isInwater() != inWater || !sound.getBiomes().m_203333_(biome) || sound.getSeed() > 0 && level.m_213780_().m_188503_(sound.getSeed()) > 0) continue;
                seasonalBiomeAmbientList.add(sound);
            }
            if (seasonalBiomeAmbientList.size() > 1) {
                seasonalBiomeAmbientList.sort(Comparator.comparing(SeasonalBiomeAmbient::getPriority));
            }
            SoundEvent soundEvent2 = soundEvent = seasonalBiomeAmbientList.isEmpty() ? null : (SoundEvent)((SeasonalBiomeAmbient)seasonalBiomeAmbientList.get(0)).getSound().m_203334_();
        }
        if (soundEvent != null) {
            boolean needAdd = true;
            for (LoopSeasonalSoundInstance soundInstance : this.loopSounds) {
                ResourceLocation key = soundInstance.m_7904_();
                boolean isTargetSound = key.equals((Object)soundEvent.m_11660_());
                if (isTargetSound) {
                    if (indoor) {
                        soundInstance.fadeOut();
                    } else if (!soundInstance.m_7801_()) {
                        soundInstance.fadeIn();
                    }
                    needAdd = false;
                    continue;
                }
                soundInstance.fadeOut();
            }
            if (needAdd && !indoor) {
                LoopSeasonalSoundInstance loopSoundInstance = new LoopSeasonalSoundInstance(soundEvent, this.loopSounds);
                this.loopSounds.add(loopSoundInstance);
                this.soundManager.m_120367_((SoundInstance)loopSoundInstance);
            }
        } else {
            this.loopSounds.forEach(LoopSeasonalSoundInstance::fadeOut);
        }
    }
}

