/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.model.bakequad;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.Arrays;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;

public class BakedQuadRetexturedLower
extends BakedQuad {
    private final TextureAtlasSprite texture;
    public static int uvIndex = 4;
    public static int verticeSpace = DefaultVertexFormat.f_85811_.m_86020_() / 4;
    private final boolean isSlabDown;
    private final float offset;

    public BakedQuadRetexturedLower(BakedQuad quad, TextureAtlasSprite textureIn, boolean isSlabDown) {
        this(quad, textureIn, isSlabDown, 0.5f);
    }

    public BakedQuadRetexturedLower(BakedQuad quad, TextureAtlasSprite textureIn, boolean isSlabDown, float offset) {
        super(Arrays.copyOf(quad.m_111303_(), quad.m_111303_().length), -1, FaceBakery.m_111612_((int[])quad.m_111303_()), textureIn, quad.m_111307_(), quad.hasAmbientOcclusion());
        this.texture = textureIn;
        this.isSlabDown = isSlabDown;
        this.offset = offset;
        this.remapQuad();
    }

    private void remapQuad() {
        Direction direction1 = this.m_111306_();
        for (int i = 0; i < 4; ++i) {
            int j = verticeSpace * i;
            float oldU = BakedQuadRetexturedLower.getUnInterpolatedU(this.f_111295_, Float.intBitsToFloat(this.f_111292_[j + uvIndex]));
            float oldV = BakedQuadRetexturedLower.getUnInterpolatedV(this.f_111295_, Float.intBitsToFloat(this.f_111292_[j + uvIndex + 1]));
            switch (direction1) {
                case NORTH: {
                    oldU = 1.0f - Float.intBitsToFloat(this.f_111292_[j]);
                    oldV = 1.0f - Float.intBitsToFloat(this.f_111292_[j + 1]);
                    break;
                }
                case WEST: {
                    oldU = Float.intBitsToFloat(this.f_111292_[j + 2]);
                    oldV = 1.0f - Float.intBitsToFloat(this.f_111292_[j + 1]);
                    break;
                }
                case SOUTH: {
                    oldU = Float.intBitsToFloat(this.f_111292_[j]);
                    oldV = 1.0f - Float.intBitsToFloat(this.f_111292_[j + 1]);
                    break;
                }
                case EAST: {
                    oldU = 1.0f - Float.intBitsToFloat(this.f_111292_[j + 2]);
                    oldV = 1.0f - Float.intBitsToFloat(this.f_111292_[j + 1]);
                    break;
                }
                case UP: {
                    oldU = Float.intBitsToFloat(this.f_111292_[j + 2]);
                    oldV = Float.intBitsToFloat(this.f_111292_[j]);
                    break;
                }
                case DOWN: {
                    oldU = 0.0f;
                    oldV = 0.0f;
                }
            }
            if (direction1.ordinal() > 1 && this.isSlabDown) {
                oldV -= this.offset;
            }
            oldU = Mth.m_14036_((float)oldU, (float)0.0f, (float)1.0f);
            oldV = Mth.m_14036_((float)oldV, (float)0.0f, (float)1.0f);
            this.f_111292_[j + BakedQuadRetexturedLower.uvIndex] = Float.floatToRawIntBits(this.texture.m_118367_((double)(oldU * 16.0f)));
            this.f_111292_[j + BakedQuadRetexturedLower.uvIndex + 1] = Float.floatToRawIntBits(this.texture.m_118393_((double)(oldV * 16.0f)));
        }
    }

    private static float getUnInterpolatedU(TextureAtlasSprite sprite, float u) {
        float f = sprite.m_118410_() - sprite.m_118409_();
        return (u - sprite.m_118409_()) / f * 16.0f;
    }

    private static float getUnInterpolatedV(TextureAtlasSprite sprite, float v) {
        float f = sprite.m_118412_() - sprite.m_118411_();
        return (v - sprite.m_118411_()) / f * 16.0f;
    }
}

