/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.debug;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.debug.OverlayEventHandler;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import java.util.ArrayList;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public final class DebugInfoRenderer {
    private final Minecraft mc;

    public DebugInfoRenderer(Minecraft mc) {
        this.mc = mc;
    }

    public void renderStatusBar(GuiGraphics matrixStack, int screenWidth, int screenHeight, LocalPlayer player, Holder<Biome> standBiome, SolarTerm solar, long dayTime, double env, double d, Humidity h, int solarTime) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        String solarS = "Solar Terms Day: " + String.valueOf(solar);
        String dayS = "Day Time: " + dayTime;
        String envS = "Env Temp: " + env;
        String dS = "Downfall: " + d;
        String jS = "Humidity: " + String.valueOf(h) + "\n" + EclipticUtil.getHumidityLevelAt(player.m_9236_(), player.m_20183_());
        String solarTimeS = "Solar Time: " + solarTime;
        int index = 0;
        String biomesS = "Biome: " + Component.m_237115_((String)Util.m_137492_((String)"biome", (ResourceLocation)((ResourceKey)standBiome.m_203543_().get()).m_135782_())).getString();
        this.drawInfo(matrixStack, screenWidth, screenHeight, solarS, index++);
        this.drawInfo(matrixStack, screenWidth, screenHeight, dayS, index++);
        this.drawInfo(matrixStack, screenWidth, screenHeight, biomesS, index++);
        this.drawInfo(matrixStack, screenWidth, screenHeight, envS, index++);
        this.drawInfo(matrixStack, screenWidth, screenHeight, dS, index++);
        this.drawInfo(matrixStack, screenWidth, screenHeight, jS, index++);
        this.drawInfo(matrixStack, screenWidth, screenHeight, solarTimeS, index++);
        block0: for (Level level : WeatherManager.BIOME_WEATHER_LIST.keySet()) {
            ArrayList<WeatherManager.BiomeWeather> biomeWeathers;
            if (level.m_46472_() != Level.f_46428_ || !(level instanceof ServerLevel) || (biomeWeathers = WeatherManager.getBiomeList(level)) == null) continue;
            for (WeatherManager.BiomeWeather biomeWeather : biomeWeathers) {
                if (!((Holder.Reference)biomeWeather.biomeHolder).m_205785_().m_135782_().equals((Object)((Holder.Reference)standBiome).m_205785_().m_135782_())) continue;
                SolarDataManager saveData = SolarHolders.getSaveData(level);
                if (saveData == null) continue block0;
                SolarTerm solarTerm = saveData.getSolarTerm();
                String solarTermS = "Solar Term: " + solarTerm.getTranslation().getString();
                String biomeRainS = "Biome Rain: " + String.valueOf(solarTerm.getBiomeRain(biomeWeather.biomeHolder));
                String snowTermS = "Snow Term: " + String.valueOf(SolarTerm.getSnowTerm((Biome)biomeWeather.biomeHolder.m_203334_(), true, EclipticUtil.getSnowTempChange(level)));
                this.drawInfo(matrixStack, screenWidth, screenHeight, "", index++);
                this.drawInfo(matrixStack, screenWidth, screenHeight, solarTermS, index++);
                this.drawInfo(matrixStack, screenWidth, screenHeight, biomeRainS, index++);
                this.drawInfo(matrixStack, screenWidth, screenHeight, snowTermS, index++);
                this.drawInfo(matrixStack, screenWidth, screenHeight, "", index++);
                String rainTimeS = "Rain Time: " + biomeWeather.rainTime;
                String clearTimeS = "Clear Time: " + biomeWeather.clearTime;
                String thunderTimeS = "Thunder Time: " + biomeWeather.thunderTime;
                String snowDepthS = "Snow Depth: " + biomeWeather.snowDepth;
                this.drawInfo(matrixStack, screenWidth, screenHeight, rainTimeS, index++);
                this.drawInfo(matrixStack, screenWidth, screenHeight, clearTimeS, index++);
                this.drawInfo(matrixStack, screenWidth, screenHeight, thunderTimeS, index++);
                this.drawInfo(matrixStack, screenWidth, screenHeight, snowDepthS, index++);
                continue block0;
            }
        }
        RenderSystem.enableBlend();
        this.mc.m_91097_().m_174784_(OverlayEventHandler.DEFAULT);
    }

    private void drawInfo(GuiGraphics matrixStack, int screenWidth, int screenHeight, String s, int index) {
        matrixStack.m_280488_(this.mc.f_91062_, s, screenWidth / 2 - this.mc.f_91062_.m_92895_(s) / 2, index * 9 + 3, 0xFFFFFF);
    }
}

