/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.core;

import com.teamtea.eclipticseasons.api.misc.client.IExtraRendererContextOwner;
import com.teamtea.eclipticseasons.client.model.ISnowyReplaceModel;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class ExtraRendererContext {
    BakedModel originalModel = null;
    BakedModel extraModel = null;
    @Nonnull
    ModelData modelData = ModelData.EMPTY;
    boolean replace = false;
    public static final ExtraRendererContext EMPTY = new ExtraRendererContext();

    public void resetAll() {
        this.setExtraModel(null);
        this.setOriginalModel(null);
        this.setModelData(ModelData.EMPTY);
        this.setReplace(false);
    }

    public static Boolean getModelForAmbientOcclusion(Object context, BlockState state, RenderType renderType) {
        ISnowyReplaceModel snowyBakedModelWrapper;
        ExtraRendererContext rendererHolder = IExtraRendererContextOwner.of(context);
        BakedModel bakedModel = rendererHolder.getExtraModel();
        if (bakedModel instanceof ISnowyReplaceModel && (snowyBakedModelWrapper = (ISnowyReplaceModel)bakedModel).getBindBlockType() == 998) {
            return true;
        }
        return null;
    }

    @Generated
    public ExtraRendererContext() {
    }

    @Generated
    public BakedModel getOriginalModel() {
        return this.originalModel;
    }

    @Generated
    public BakedModel getExtraModel() {
        return this.extraModel;
    }

    @Nonnull
    @Generated
    public ModelData getModelData() {
        return this.modelData;
    }

    @Generated
    public boolean isReplace() {
        return this.replace;
    }

    @Generated
    public ExtraRendererContext setOriginalModel(BakedModel originalModel) {
        this.originalModel = originalModel;
        return this;
    }

    @Generated
    public ExtraRendererContext setExtraModel(BakedModel extraModel) {
        this.extraModel = extraModel;
        return this;
    }

    @Generated
    public ExtraRendererContext setModelData(@Nonnull ModelData modelData) {
        if (modelData == null) {
            throw new NullPointerException("modelData is marked non-null but is null");
        }
        this.modelData = modelData;
        return this;
    }

    @Generated
    public ExtraRendererContext setReplace(boolean replace) {
        this.replace = replace;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtraRendererContext)) {
            return false;
        }
        ExtraRendererContext other = (ExtraRendererContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isReplace() != other.isReplace()) {
            return false;
        }
        BakedModel this$originalModel = this.getOriginalModel();
        BakedModel other$originalModel = other.getOriginalModel();
        if (this$originalModel == null ? other$originalModel != null : !this$originalModel.equals(other$originalModel)) {
            return false;
        }
        BakedModel this$extraModel = this.getExtraModel();
        BakedModel other$extraModel = other.getExtraModel();
        if (this$extraModel == null ? other$extraModel != null : !this$extraModel.equals(other$extraModel)) {
            return false;
        }
        ModelData this$modelData = this.getModelData();
        ModelData other$modelData = other.getModelData();
        return !(this$modelData == null ? other$modelData != null : !this$modelData.equals(other$modelData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExtraRendererContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReplace() ? 79 : 97);
        BakedModel $originalModel = this.getOriginalModel();
        result = result * 59 + ($originalModel == null ? 43 : $originalModel.hashCode());
        BakedModel $extraModel = this.getExtraModel();
        result = result * 59 + ($extraModel == null ? 43 : $extraModel.hashCode());
        ModelData $modelData = this.getModelData();
        result = result * 59 + ($modelData == null ? 43 : $modelData.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExtraRendererContext(originalModel=" + String.valueOf(this.getOriginalModel()) + ", extraModel=" + String.valueOf(this.getExtraModel()) + ", modelData=" + String.valueOf(this.getModelData()) + ", replace=" + this.isReplace() + ")";
    }
}

