/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.teamtea.eclipticseasons.api.data.misc.ESSortInfo;
import com.teamtea.eclipticseasons.api.event.ESClientEntityTickEvent;
import com.teamtea.eclipticseasons.api.misc.IChunkBiomeHolder;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.core.ClientWeatherChecker;
import com.teamtea.eclipticseasons.client.render.WorldRenderer;
import com.teamtea.eclipticseasons.client.render.chunk.IceKeeper;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.client.util.ClientRef;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.biome.BiomeClimateManager;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.crop.CropInfoManager;
import com.teamtea.eclipticseasons.common.core.map.BiomeHolder;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowyStatusHandler;
import com.teamtea.eclipticseasons.common.core.solar.ClientSolarDataManager;
import com.teamtea.eclipticseasons.common.game.AnimalHooks;
import com.teamtea.eclipticseasons.common.misc.MapExporter;
import com.teamtea.eclipticseasons.config.ClientConfig;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="eclipticseasons", value={Dist.CLIENT})
public final class ClientEventHandler {
    private static long lastFreshTime = -1L;

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91074_ != null) {
            WorldRenderer.applyEffect(Minecraft.m_91087_().f_91063_, Minecraft.m_91087_().f_91074_);
        }
    }

    @SubscribeEvent
    public static void addTooltips(ItemTooltipEvent event) {
        if (((Boolean)ClientConfig.GUI.agriculturalInformation.get()).booleanValue()) {
            BlockItem blockItem;
            Item item = event.getItemStack().m_41720_();
            if (item instanceof BlockItem) {
                blockItem = (BlockItem)item;
                event.getToolTip().addAll(CropGrowthHandler.appendInfo(event.getEntity() != null ? event.getEntity().m_9236_() : null, blockItem.m_40614_().m_49966_()));
            } else {
                event.getToolTip().addAll(CropInfoManager.appendInfo(event.getItemStack().m_41720_()));
            }
            item = event.getItemStack().m_41720_();
            if (item instanceof SpawnEggItem) {
                blockItem = (SpawnEggItem)item;
                event.getToolTip().addAll(AnimalHooks.getBreedInfo(blockItem.m_43228_(event.getItemStack().m_41783_())));
            }
        }
    }

    @SubscribeEvent
    public static void onChunkUnloadEvent(ChunkEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ClientLevel) {
            ChunkAccess chunkAccess;
            SnowyStatusHandler orDefault1;
            ClientLevel clientLevel = (ClientLevel)levelAccessor;
            BiomeHolder orDefault = BiomeHolder.BIOME_HOLDER_MAP.getOrDefault(event.getChunk().m_7697_(), null);
            if (orDefault != null) {
                ((IChunkBiomeHolder)event.getChunk()).eclipticseasons$setBiomeHolder(orDefault);
            }
            if ((orDefault1 = (SnowyStatusHandler)SnowyStatusHandler.SNOWY_STATUS_HANDLER_HASH_MAP.getOrDefault(event.getChunk().m_7697_(), null)) != null && (chunkAccess = event.getChunk()) instanceof LevelChunk) {
                LevelChunk chunk = (LevelChunk)chunkAccess;
                SnowyStatusHandler.setChunkWithUpdate(orDefault1, chunk);
            }
        }
    }

    @SubscribeEvent
    public static void onChunkUnloadEvent(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)levelAccessor;
            BiomeHolder.BIOME_HOLDER_MAP.remove(event.getChunk().m_7697_());
            SnowyStatusHandler.SNOWY_STATUS_HANDLER_HASH_MAP.remove(event.getChunk().m_7697_());
        }
    }

    @SubscribeEvent
    public static void onLevelUnloadEvent(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)levelAccessor;
            MapChecker.unloadLevel((Level)clientLevel);
            ClientWeatherChecker.unloadLevel((Level)clientLevel);
            ClientCon.setUseLevel(null);
            IceKeeper.clearAll();
            BiomeHolder.BIOME_HOLDER_MAP.clear();
            SnowyStatusHandler.SNOWY_STATUS_HANDLER_HASH_MAP.clear();
        }
    }

    @SubscribeEvent
    public static void onPlayerExit(ClientPlayerNetworkEvent.LoggingOut event) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            CropGrowthHandler.clearOnClientExitOrServerClose();
            BiomeClimateManager.clearOnClientExitOrServerClose();
            ClientCon.onClientPlayerExit();
            ClientRef.onClientPlayerExit();
            SnowChecker.clearOnClientExitOrServerClose();
            ESSortInfo.clearOnClientExitOrServerClose();
        }
    }

    @SubscribeEvent
    public static void onTagsUpdatedEvent(TagsUpdatedEvent tagsUpdatedEvent) {
        if (tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED) {
            ClientRef.updateClientSide(tagsUpdatedEvent.getRegistryAccess());
        }
    }

    @SubscribeEvent
    public static void onLevelEventLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ClientLevel) {
            ClientLevel level = (ClientLevel)levelAccessor;
            if (((List)CommonConfig.Season.validDimensions.get()).contains(level.m_46472_().m_135782_().toString())) {
                MapChecker.validDimension.add((Level)level);
            }
            ClientCon.setUseLevel((Level)level);
            ClientCon.tick((Level)level);
            WeatherManager.createLevelBiomeWeatherList((Level)level);
            SolarHolders.createSaveData((Level)level, ClientSolarDataManager.get(level));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(ESClientEntityTickEvent event) {
        IceKeeper.checkIfPlayerStepInFrozenWater(event.getEntity());
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            if (event.phase.equals((Object)TickEvent.Phase.END)) {
                ClientWeatherChecker.tickAllCheck((Level)clientLevel);
                ClientCon.tick((Level)clientLevel);
                if (!(EclipticUtil.canSnowyBlockInteract() && !((Boolean)ClientConfig.Renderer.enhancementChunkRenderUpdate.get()).booleanValue() || !((Boolean)ClientConfig.Renderer.forceChunkRenderUpdate.get()).booleanValue() || clientLevel.m_46467_() - lastFreshTime <= 80L && clientLevel.m_46467_() >= lastFreshTime - 1L)) {
                    lastFreshTime = clientLevel.m_46467_();
                    Entity entity = Minecraft.m_91087_().f_91075_;
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        BlockPos pos = player.m_20097_();
                        SectionPos sectionPos = SectionPos.m_123199_((BlockPos)pos);
                        if (!((Boolean)ClientConfig.Renderer.enhancementChunkRenderUpdate.get()).booleanValue()) {
                            WorldRenderer.setSectionDirtyWithNeighbors(sectionPos);
                            WorldRenderer.setSectionDirtyRandomly(sectionPos);
                        } else if (clientLevel.m_213780_().m_188503_(2) == 0) {
                            WorldRenderer.setAllDirty(sectionPos);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStageEvent(RenderLevelStageEvent event) {
    }

    @SubscribeEvent
    public static void onRegisterClientCommandsEvent(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientCon.ServerName = event.getPlayer().f_108617_.m_245416_() == null ? "Client" : event.getPlayer().f_108617_.m_245416_().f_105362_;
    }

    @SubscribeEvent
    public static void onRegisterClientCommandsEvent(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"ecliptic").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"c_export").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(stackCommandContext -> MapExporter.exportMap((CommandSourceStack)stackCommandContext.getSource(), BlockPosArgument.m_264582_((CommandContext)stackCommandContext, (String)"pos"))))));
    }
}

