/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.util.fast;

import java.util.BitSet;
import org.jetbrains.annotations.NotNull;

public class Enum2IntMap<K extends Enum<K>> {
    private final int[] values;
    private final BitSet setFlags;
    private final Class<K> keyType;
    private final int defaultValue;

    public Enum2IntMap(Class<K> keyType) {
        this(keyType, -1);
    }

    public Enum2IntMap(Class<K> keyType, int defaultValue) {
        this.keyType = keyType;
        this.defaultValue = defaultValue;
        Enum[] constants = (Enum[])keyType.getEnumConstants();
        this.values = new int[constants.length];
        this.setFlags = new BitSet(constants.length);
    }

    public void put(K key, int value) {
        this.values[((Enum)key).ordinal()] = value;
        this.setFlags.set(((Enum)key).ordinal());
    }

    public int get(K key) {
        return this.setFlags.get(((Enum)key).ordinal()) ? this.values[((Enum)key).ordinal()] : this.defaultValue;
    }

    public boolean contains(K key) {
        return this.setFlags.get(((Enum)key).ordinal());
    }

    public void put(int index, int value) {
        this.values[index] = value;
        this.setFlags.set(index);
    }

    public int get(int index) {
        return index >= 0 && index < this.values.length && this.setFlags.get(index) ? this.values[index] : this.defaultValue;
    }

    public int getOrDefault(K key, int defaultValue) {
        return this.setFlags.get(((Enum)key).ordinal()) ? this.values[((Enum)key).ordinal()] : defaultValue;
    }

    public int getOrDefault(int index, int defaultValue) {
        return index >= 0 && index < this.values.length && this.setFlags.get(index) ? this.values[index] : defaultValue;
    }

    public int size() {
        return this.setFlags.cardinality();
    }

    public Class<K> getKeyType() {
        return this.keyType;
    }

    public int remove(K key) {
        int ordinal = ((Enum)key).ordinal();
        if (this.setFlags.get(ordinal)) {
            int oldValue = this.values[ordinal];
            this.setFlags.clear(ordinal);
            return oldValue;
        }
        return this.defaultValue;
    }

    public int remove(int index) {
        if (index >= 0 && index < this.values.length && this.setFlags.get(index)) {
            int oldValue = this.values[index];
            this.setFlags.clear(index);
            return oldValue;
        }
        return this.defaultValue;
    }

    public void fill(int value) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = value;
            this.setFlags.set(i);
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void putAll(@NotNull Enum2IntMap<K> newWeights) {
        int i = newWeights.setFlags.nextSetBit(0);
        while (i >= 0) {
            this.put(i, newWeights.values[i]);
            i = newWeights.setFlags.nextSetBit(i + 1);
        }
    }
}

