/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.util.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.RecordBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class LinkCompoundListCodec<K, V>
implements Codec<List<Pair<K, V>>> {
    private final Codec<K> keyCodec;
    private final Codec<V> elementCodec;

    public LinkCompoundListCodec(Codec<K> keyCodec, Codec<V> elementCodec) {
        this.keyCodec = keyCodec;
        this.elementCodec = elementCodec;
    }

    public <T> DataResult<Pair<List<Pair<K, V>>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getMapEntries(input).flatMap(map -> {
            ArrayList read = new ArrayList();
            LinkedHashMap failed = new LinkedHashMap();
            AtomicReference<DataResult> result = new AtomicReference<DataResult>(DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.experimental()));
            map.accept((key, value) -> {
                DataResult k = this.keyCodec.parse(ops, key);
                DataResult v = this.elementCodec.parse(ops, value);
                DataResult readEntry = k.apply2stable(Pair::new, v);
                readEntry.error().ifPresent(e -> failed.put(key, value));
                result.setPlain(((DataResult)result.getPlain()).apply2stable((u, e) -> {
                    read.add(e);
                    return u;
                }, readEntry));
            });
            ArrayList elements = read;
            Object errors = ops.createMap(failed);
            Pair pair = Pair.of(elements, (Object)errors);
            return result.getPlain().map(unit -> pair).setPartial((Object)pair);
        });
    }

    public <T> DataResult<T> encode(List<Pair<K, V>> input, DynamicOps<T> ops, T prefix) {
        RecordBuilder builder = ops.mapBuilder();
        for (Pair<K, V> pair : input) {
            builder.add(this.keyCodec.encodeStart(ops, pair.getFirst()), this.elementCodec.encodeStart(ops, pair.getSecond()));
        }
        return builder.build(prefix);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkCompoundListCodec that = (LinkCompoundListCodec)o;
        return Objects.equals(this.keyCodec, that.keyCodec) && Objects.equals(this.elementCodec, that.elementCodec);
    }

    public int hashCode() {
        return Objects.hash(this.keyCodec, this.elementCodec);
    }

    public String toString() {
        return "LinkCompoundListCodec[" + String.valueOf(this.keyCodec) + " -> " + String.valueOf(this.elementCodec) + "]";
    }
}

