/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.util;

import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import com.teamtea.eclipticseasons.api.constant.biome.Rainfall;
import com.teamtea.eclipticseasons.api.constant.biome.Temperature;
import com.teamtea.eclipticseasons.api.constant.climate.BiomeRain;
import com.teamtea.eclipticseasons.api.constant.climate.WeatherMode;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.client.core.ClientWeatherChecker;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.biome.BiomeClimateManager;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.solar.SolarAngelHelper;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.common.game.AnimalHooks;
import com.teamtea.eclipticseasons.common.misc.MapColorReplacer;
import com.teamtea.eclipticseasons.compat.vanilla.VanillaWeather;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class EclipticUtil {
    public static EclipticSeasonsApi INSTANCE = new EclipticSeasonsApi(){

        @Override
        public SolarTerm getSolarTerm(Level level) {
            return EclipticUtil.getNowSolarTerm(level);
        }

        @Override
        public Season getAgroSeason(Level level, BlockPos pos) {
            return AnimalHooks.getUseSeason(level, pos);
        }

        @Override
        public int getSolarDays(Level level) {
            return EclipticUtil.getNowSolarDay(level);
        }

        @Override
        public int getSolarYears(Level level) {
            return EclipticUtil.getNowSolarYear(level);
        }

        @Override
        public int getLastingDaysOfEachTerm(Level level) {
            return (Integer)CommonConfig.Season.lastingDaysOfEachTerm.get();
        }

        @Override
        public int getTimeInTerm(Level level) {
            return EclipticUtil.getTimeInSolarTerm(level);
        }

        @Override
        public boolean isSeasonEnabled(Level level) {
            return MapChecker.isValidDimension(level);
        }

        @Override
        public boolean hasLocalWeather(Level level) {
            return EclipticUtil.hasLocalWeather(level);
        }

        @Override
        public long getDayTime(Level level) {
            SolarDataManager data;
            if (MapChecker.isValidDimension(level) && ((Boolean)CommonConfig.Season.daylightChange.get()).booleanValue() && (data = SolarHolders.getSaveData(level)) != null) {
                long worldTime = level.m_46468_();
                int dayLevelTime = Math.toIntExact((worldTime + 18000L) % 24000L);
                return dayLevelTime > 12000 && dayLevelTime <= 18000 && data.isTodayLastDay() ? (long)data.getNextSolarTerm().getDayTime() : (long)data.getSolarTerm().getDayTime();
            }
            return 12000L;
        }

        @Override
        public boolean isDay(Level level) {
            return EclipticUtil.isDay(level);
        }

        @Override
        public boolean isNight(Level level) {
            return EclipticUtil.isNight(level);
        }

        @Override
        public int getNightTime(Level level) {
            return EclipticUtil.getNightTime(level);
        }

        @Override
        public boolean isNoon(Level level) {
            return EclipticUtil.isNoon(level);
        }

        @Override
        public boolean isEvening(Level level) {
            return EclipticUtil.isEvening(level);
        }

        @Override
        @Deprecated
        public boolean isSnowySurfaceAt(Level level, BlockPos pos) {
            if (CommonConfig.isSnowyWinter()) {
                BlockState state = level.m_8055_(pos);
                return MapChecker.shouldSnowAt(level, pos, state, level.m_213780_(), state.m_60726_(pos));
            }
            return false;
        }

        @Override
        public boolean isSnowyBlock(Level level, BlockState state, BlockPos pos) {
            return MapColorReplacer.getTopSnowColor((BlockGetter)level, state, pos) != null;
        }

        @Override
        public boolean isRainOrSnowAt(Level level, BlockPos pos) {
            if (this.hasLocalWeather(level) ? EclipticUtil.getRainOrSnow(level, (Biome)MapChecker.getSurfaceBiome(level, pos).m_203334_(), pos) == Biome.Precipitation.NONE : !level.m_46471_()) {
                return false;
            }
            if (!level.m_45527_(pos)) {
                return false;
            }
            return level.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() <= pos.m_123342_();
        }

        @Override
        public boolean isRainAt(Level level, BlockPos pos) {
            return level.m_46758_(pos);
        }

        @Override
        public boolean isSnowAt(Level level, BlockPos pos) {
            if (this.hasLocalWeather(level) ? EclipticUtil.getRainOrSnow(level, (Biome)MapChecker.getSurfaceBiome(level, pos).m_203334_(), pos) == Biome.Precipitation.NONE : !level.m_46471_() || VanillaWeather.handlePrecipitationAt(level, (Biome)MapChecker.getSurfaceBiome(level, pos).m_203334_(), pos) != Biome.Precipitation.SNOW) {
                return false;
            }
            if (!level.m_45527_(pos)) {
                return false;
            }
            return level.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() <= pos.m_123342_();
        }

        @Override
        public boolean isThunderAt(Level level, BlockPos pos) {
            if (this.hasLocalWeather(level)) {
                return WeatherManager.isThunderAt(level, pos);
            }
            if (!level.m_46470_()) {
                return false;
            }
            if (!level.m_45527_(pos)) {
                return false;
            }
            return level.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() <= pos.m_123342_();
        }

        @Override
        public Biome.Precipitation getPrecipitationAt(Level level, BlockPos pos) {
            if (this.hasLocalWeather(level)) {
                return WeatherManager.getPrecipitationAt(level, (Biome)MapChecker.getSurfaceBiome(level, pos).m_203334_(), pos);
            }
            return VanillaWeather.handlePrecipitationAt(level, (Biome)MapChecker.getSurfaceBiome(level, pos).m_203334_(), pos);
        }

        @Override
        public Biome.Precipitation getCurrentPrecipitationAt(Level level, BlockPos pos) {
            if (this.hasLocalWeather(level)) {
                return EclipticUtil.getRainOrSnow(level, (Biome)MapChecker.getSurfaceBiome(level, pos).m_203334_(), pos);
            }
            return VanillaWeather.getRainOrSnow(level, (Biome)MapChecker.getSurfaceBiome(level, pos).m_203334_(), pos);
        }

        @Override
        public boolean isRainingOrSnowing(Level level, BlockPos pos) {
            if (this.hasLocalWeather(level)) {
                return EclipticUtil.getRainOrSnow(level, (Biome)MapChecker.getSurfaceBiome(level, pos).m_203334_(), pos) != Biome.Precipitation.NONE;
            }
            return level.m_46471_();
        }

        @Override
        public boolean isThundering(Level level, BlockPos pos) {
            if (this.hasLocalWeather(level)) {
                return WeatherManager.isThunderAtBiome(level, (Biome)MapChecker.getSurfaceBiome(level, pos).m_203334_());
            }
            return level.m_46471_();
        }

        @Override
        public Humidity getBaseHumidity(Level level, BlockPos pos) {
            return EclipticUtil.getHumidityAt(level, pos);
        }

        @Override
        public Humidity getAdjustedHumidity(ServerLevel level, BlockPos checkPos) {
            float humidity = EclipticUtil.getHumidityLevelAt((Level)level, checkPos);
            humidity = EclipticUtil.getHumidityAfterCheck(level, checkPos, humidity);
            return Humidity.getHumid(humidity);
        }
    };

    public static SolarTerm getNowSolarTerm(Level level) {
        SolarDataManager sd = SolarHolders.getSaveData(level);
        if (sd != null) {
            return sd.getSolarTerm();
        }
        return SolarTerm.NONE;
    }

    public static int getNowSolarYear(Level level) {
        SolarDataManager sd = SolarHolders.getSaveData(level);
        if (sd != null) {
            return sd.getSolarYear();
        }
        return 0;
    }

    public static int getBiomeDataVersion(Level level) {
        SolarDataManager sd = SolarHolders.getSaveData(level);
        if (sd != null) {
            return sd.getBiomeDataVersion();
        }
        return 0;
    }

    public static float getSnowTempChange(Level level) {
        SolarDataManager sd;
        if (((Boolean)CommonConfig.Season.dynamicSnowTerm.get()).booleanValue() && (sd = SolarHolders.getSaveData(level)) != null) {
            return sd.getSolarTempChange();
        }
        return 0.0f;
    }

    public static boolean isDay(Level level) {
        long dayTime = level.m_6042_().f_63854_().orElse(SolarAngelHelper.getSolarAngelTime((LevelTimeAccess)level, level.m_46468_()));
        long termTime = EclipticUtil.getNowSolarTerm(level).getDayTime();
        long halfTermTime = termTime / 2L;
        if (termTime <= 12000L) {
            return 6000L - halfTermTime < dayTime && dayTime < 6000L + halfTermTime;
        }
        return dayTime >= 24000L + (6000L - halfTermTime) || dayTime <= 6000L + halfTermTime;
    }

    public static boolean isNight(Level level) {
        return !EclipticUtil.isDay(level);
    }

    public static int getNightTime(Level level) {
        long termTime = EclipticUtil.getNowSolarTerm(level).getDayTime();
        return (int)(6000L + termTime / 2L);
    }

    public static boolean isNoon(Level level) {
        long dayTime = level.m_6042_().f_63854_().orElse(SolarAngelHelper.getSolarAngelTime((LevelTimeAccess)level, level.m_46468_()));
        long termTime = EclipticUtil.getNowSolarTerm(level).getDayTime();
        return 6000L - termTime / 6L < dayTime && dayTime < 6000L + termTime / 4L;
    }

    public static boolean isEvening(Level level) {
        long dayTime = level.m_6042_().f_63854_().orElse(SolarAngelHelper.getSolarAngelTime((LevelTimeAccess)level, level.m_46468_()));
        long termTime = EclipticUtil.getNowSolarTerm(level).getDayTime();
        return 6000L + termTime * 2L / 5L < dayTime && dayTime < 6000L + termTime / 2L + (24000L - termTime) * 3L / 4L;
    }

    public static boolean useSolarWeather() {
        return CommonConfig.isUseSolarWeather();
    }

    public static boolean isSolarWeatherClosed() {
        return !EclipticUtil.useSolarWeather();
    }

    public static WeatherMode getWeatherMode(Level level) {
        if (!EclipticUtil.useSolarWeather()) {
            return WeatherMode.DEFAULT;
        }
        return MapChecker.isValidDimension(level) ? (CommonConfig.isEnableWeatherRegion() ? WeatherMode.REGION : WeatherMode.BIOME) : WeatherMode.DEFAULT;
    }

    public static boolean hasLocalWeather(Level level) {
        return EclipticUtil.getWeatherMode(level) != WeatherMode.DEFAULT;
    }

    public static boolean canSnowyBlockInteract() {
        return CommonConfig.isSnowInWorld();
    }

    public static float getHumidityAfterCheck(ServerLevel level, BlockPos checkPos, float env) {
        SolarDataManager data = SolarHolders.getSaveData((Level)level);
        if (data != null) {
            float chance = 0.0f;
            for (int i = 0; i < 20; ++i) {
                chance += CropGrowthHandler.isInRoom((LevelAccessor)level, checkPos, level.m_8055_(checkPos), Optional.empty()) ? 1.0f : 0.0f;
            }
            if (chance > 8.0f) {
                env += data.calculateHumidityModification(checkPos);
            } else if (chance == 0.0f && level.m_46758_(checkPos)) {
                env += 1.0f;
            }
        }
        return env;
    }

    public static int getNowSolarDay(Level level) {
        SolarDataManager sd = SolarHolders.getSaveData(level);
        if (sd != null) {
            return sd.getSolarTermsDay();
        }
        return 0;
    }

    public static int getTimeInSolarTerm(Level level) {
        SolarDataManager sd = SolarHolders.getSaveData(level);
        if (sd != null) {
            return sd.getSolarTermDaysInPeriod();
        }
        return 0;
    }

    public static boolean isRainingOrSnowingWithSurfaceBiome(Level level, Biome biome, BlockPos pos) {
        if (EclipticUtil.hasLocalWeather(level)) {
            return EclipticUtil.getRainOrSnow(level, biome, pos) != Biome.Precipitation.NONE;
        }
        return level.m_46471_();
    }

    public static boolean isHereWithSnow(Level level, BlockPos pos) {
        return WeatherManager.getSnowDepthAtBiome(level, (Biome)MapChecker.getSurfaceBiome(level, pos).m_203334_()) > 0;
    }

    public static Biome.Precipitation getRainOrSnow(Level level, Biome biome, BlockPos pos) {
        return level.m_5776_() && ClientWeatherChecker.isBiomeRainyLast(biome) ? WeatherManager.getPrecipitationAt(level, biome, pos) : WeatherManager.getRainOrSnow(level, biome, pos);
    }

    public static boolean isHereSunny(Level level, BlockPos pos) {
        return EclipticUtil.getRainOrSnow(level, (Biome)MapChecker.getSurfaceBiome(level, pos).m_203334_(), pos) == Biome.Precipitation.NONE;
    }

    public static boolean isHereRainy(Level level, BlockPos pos) {
        return EclipticUtil.getRainOrSnow(level, (Biome)MapChecker.getSurfaceBiome(level, pos).m_203334_(), pos) == Biome.Precipitation.RAIN;
    }

    public static boolean isHereSnowy(Level level, BlockPos pos) {
        return EclipticUtil.getRainOrSnow(level, (Biome)MapChecker.getSurfaceBiome(level, pos).m_203334_(), pos) == Biome.Precipitation.SNOW;
    }

    public static float getTemperatureFloat(Level level, Biome biome, BlockPos blockPos) {
        return EclipticUtil.getTemperatureFloat(level, EclipticUtil.getNowSolarTerm(level), biome, blockPos, !level.m_5776_());
    }

    public static float getTemperatureFloat(Level level, SolarTerm solarTerm, Biome biome, BlockPos blockPos, boolean isServer) {
        float modify = solarTerm.getSeason() == Season.SUMMER && EclipticUtil.isNoon(level) && level.m_45517_(LightLayer.SKY, blockPos.m_7494_()) > 12 ? solarTerm.getTemperatureChange() / 2.0f : 0.0f;
        return biome.m_47505_(blockPos) + BiomeClimateManager.getBiomeClimateSettings(biome, isServer).getTemperatureChange(solarTerm) + modify;
    }

    public static float getTemperatureFloatConstant(SolarTerm solarTerm, Biome biome, boolean isServer) {
        return BiomeClimateManager.getBiomeClimateSettings(biome, isServer).getTemperature(solarTerm);
    }

    public static float getDownfallFloat(Level level, Biome biome, BlockPos blockPos) {
        return EclipticUtil.getDownfallFloat(level, EclipticUtil.getNowSolarTerm(level), biome, blockPos, !level.m_5776_());
    }

    public static float getDownfallFloat(Level level, SolarTerm solarTerm, Biome biome, BlockPos blockPos, boolean isServer) {
        return BiomeClimateManager.getBiomeClimateSettings(biome, isServer).getDownfall(solarTerm);
    }

    public static float getDownfallFloatConstant(SolarTerm solarTerm, Biome biome, boolean isServer) {
        return BiomeClimateManager.getBiomeClimateSettings(biome, isServer).getDownfall(solarTerm);
    }

    public static Rainfall getRainfallAt(Level level, BlockPos pos) {
        Biome standBiome = (Biome)level.m_204166_(pos).m_203334_();
        return Rainfall.getRainfallLevel(EclipticUtil.getDownfallFloat(level, standBiome, pos));
    }

    public static Temperature getTemperatureAt(Level level, BlockPos pos) {
        Biome standBiome = (Biome)level.m_204166_(pos).m_203334_();
        return Temperature.getTemperatureLevel(EclipticUtil.getTemperatureFloat(level, standBiome, pos));
    }

    public static Humidity getHumidityAt(Level level, BlockPos pos) {
        Holder biome = level.m_204166_(pos);
        SolarTerm solarTerm = EclipticUtil.getNowSolarTerm(level);
        boolean serverSide = !level.m_5776_();
        return EclipticUtil.getHumidityAt(level, solarTerm, (Holder<Biome>)biome, pos, serverSide);
    }

    public static Humidity getHumidityConstant(SolarTerm solarTerm, Holder<Biome> biomeHolder, boolean serverSide) {
        Biome standBiome = (Biome)biomeHolder.m_203334_();
        float t = EclipticUtil.getTemperatureFloatConstant(solarTerm, standBiome, serverSide);
        BiomeRain biomeRain = solarTerm.getBiomeRain(biomeHolder);
        float r = (EclipticUtil.getDownfallFloatConstant(solarTerm, standBiome, serverSide) * 1.5f + biomeRain.getRainChance() * 0.5f) / 2.0f;
        return Humidity.getHumid(r, t);
    }

    public static float getHumidityConstantFloat(SolarTerm solarTerm, Holder<Biome> biomeHolder, boolean serverSide) {
        Biome standBiome = (Biome)biomeHolder.m_203334_();
        float t = EclipticUtil.getTemperatureFloatConstant(solarTerm, standBiome, serverSide);
        BiomeRain biomeRain = solarTerm.getBiomeRain(biomeHolder);
        float r = (EclipticUtil.getDownfallFloatConstant(solarTerm, standBiome, serverSide) * 1.5f + biomeRain.getRainChance() * 0.5f) / 2.0f;
        return Humidity.getFloatHumidLevel(r, t);
    }

    public static Humidity getHumidityAt(Level level, SolarTerm solarTerm, Holder<Biome> biome, BlockPos pos, boolean serverSide) {
        return Humidity.getHumid(EclipticUtil.getHumidityLevelAt(level, solarTerm, biome, pos, serverSide));
    }

    public static float getHumidityLevelAt(Level level, BlockPos pos) {
        Holder biome = level.m_204166_(pos);
        SolarTerm solarTerm = EclipticUtil.getNowSolarTerm(level);
        boolean serverSide = !level.m_5776_();
        return EclipticUtil.getHumidityLevelAt(level, solarTerm, (Holder<Biome>)biome, pos, serverSide);
    }

    public static float getHumidityLevelAt(Level level, SolarTerm solarTerm, Holder<Biome> biome, BlockPos pos, boolean serverSide) {
        Biome standBiome = (Biome)biome.m_203334_();
        float t = EclipticUtil.getTemperatureFloat(level, solarTerm, standBiome, pos, serverSide);
        BiomeRain biomeRain = solarTerm.getBiomeRain(biome);
        float r = (EclipticUtil.getDownfallFloat(level, solarTerm, standBiome, pos, serverSide) * 1.5f + biomeRain.getRainChance() * 0.5f) / 2.0f;
        return Humidity.getFloatHumidLevel(r, t);
    }
}

