/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.client.model.seasonal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.misc.util.HolderMappable;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import com.teamtea.eclipticseasons.api.util.codec.ESExtraCodec;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import com.teamtea.eclipticseasons.client.model.LocalSeasonStatusModel;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public class SeasonBlockDefinition
implements HolderMappable<HolderSet<Block>, SeasonBlockDefinition> {
    public static final ResourceLocation GRASS_BLOCK = EclipticSeasons.rl("grass_block");
    public static final Codec<SeasonBlockDefinition> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)CodecUtil.holderSetCodec(Registries.f_256747_).fieldOf("blocks").forGetter(o -> o.blocks), (App)CodecUtil.holderCodec(ESRegistries.AGRO_CLIMATE).optionalFieldOf("climate").forGetter(o -> o.climate), (App)CodecUtil.holderSetCodec(Registries.f_256952_).optionalFieldOf("biomes", (Object)HolderSet.m_205809_((Holder[])new Holder[0])).forGetter(o -> o.biomes), (App)Slice.CODEC.listOf().fieldOf("slices").forGetter(o -> o.slices)).apply((Applicative)ins, SeasonBlockDefinition::new));
    private final HolderSet<Block> blocks;
    private final Optional<Holder<AgroClimaticZone>> climate;
    private final HolderSet<Biome> biomes;
    private final List<Slice> slices;
    private Enum2ObjectMap<SolarTerm, List<FlatSliceHolder>> flatSliceEnumMap = null;

    public boolean hasBuild() {
        return this.flatSliceEnumMap != null;
    }

    public SeasonBlockDefinition build() {
        this.flatSliceEnumMap = new Enum2ObjectMap(SolarTerm.class);
        for (Slice slice : this.slices) {
            FlatSliceHolder otherHolder;
            FlatSliceHolder firstSliceHolder;
            SolarTerm end;
            SolarTerm start2;
            FlatSlice flatSlice = new FlatSlice(slice.mid.equals((Object)LocalSeasonStatusModel.EMPTY) ? null : slice.mid, slice.emptyAbove, slice.transitionModels.equals(Slice.EMPTY_PAIR) ? null : slice.transitionModels);
            AgroClimaticZone climate = this.getClimate().map(Holder::m_203334_).orElse(null);
            SolarTerm solarTerm = slice.start.isValid() ? slice.start : (slice.solarTerm.isValid() ? slice.solarTerm : (slice.season.isValid() ? slice.season.getFirstSolarTerm(climate) : (start2 = slice.startSeason.isValid() ? slice.endSeason.getFirstSolarTerm(climate) : SolarTerm.NONE)));
            SolarTerm solarTerm2 = slice.end.isValid() ? slice.end : (slice.solarTerm.isValid() ? slice.solarTerm : (slice.season.isValid() ? slice.season.getEndSolarTerm(climate) : (end = slice.endSeason.isValid() ? slice.endSeason.getEndSolarTerm(climate) : SolarTerm.NONE)));
            if (!start2.isValid() || !end.isValid()) continue;
            if (start2 != end && flatSlice.transitionModels != null) {
                firstSliceHolder = new FlatSliceHolder(start2, start2, flatSlice);
                otherHolder = new FlatSliceHolder(start2.getNextSolarTerm(), end, new FlatSlice((ResourceLocation)flatSlice.transitionModels.getSecond(), flatSlice.emptyAbove, null));
            } else {
                otherHolder = firstSliceHolder = new FlatSliceHolder(start2, end, flatSlice);
            }
            for (SolarTerm solarTerm3 : SolarTerm.collectValues()) {
                if (start2 == solarTerm3) {
                    this.flatSliceEnumMap.compute(solarTerm3, (solarTerm1, flatSliceHolders) -> {
                        if (flatSliceHolders == null) {
                            flatSliceHolders = new ArrayList<FlatSliceHolder>();
                        }
                        flatSliceHolders.add(firstSliceHolder);
                        return flatSliceHolders;
                    });
                    continue;
                }
                if (!solarTerm3.isInTerms(start2, end)) continue;
                this.flatSliceEnumMap.compute(solarTerm3, (solarTerm1, flatSliceHolders) -> {
                    if (flatSliceHolders == null) {
                        flatSliceHolders = new ArrayList<FlatSliceHolder>();
                    }
                    flatSliceHolders.add(otherHolder);
                    return flatSliceHolders;
                });
            }
        }
        return this;
    }

    @Override
    public Pair<HolderSet<Block>, SeasonBlockDefinition> asHolderMapping() {
        return Pair.of(this.blocks, (Object)this.build());
    }

    @Generated
    public SeasonBlockDefinition(HolderSet<Block> blocks, Optional<Holder<AgroClimaticZone>> climate, HolderSet<Biome> biomes, List<Slice> slices) {
        this.blocks = blocks;
        this.climate = climate;
        this.biomes = biomes;
        this.slices = slices;
    }

    @Generated
    public HolderSet<Block> getBlocks() {
        return this.blocks;
    }

    @Generated
    public Optional<Holder<AgroClimaticZone>> getClimate() {
        return this.climate;
    }

    @Generated
    public HolderSet<Biome> getBiomes() {
        return this.biomes;
    }

    @Generated
    public List<Slice> getSlices() {
        return this.slices;
    }

    @Generated
    public Enum2ObjectMap<SolarTerm, List<FlatSliceHolder>> getFlatSliceEnumMap() {
        return this.flatSliceEnumMap;
    }

    @Generated
    public void setFlatSliceEnumMap(Enum2ObjectMap<SolarTerm, List<FlatSliceHolder>> flatSliceEnumMap) {
        this.flatSliceEnumMap = flatSliceEnumMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeasonBlockDefinition)) {
            return false;
        }
        SeasonBlockDefinition other = (SeasonBlockDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HolderSet<Block> this$blocks = this.getBlocks();
        HolderSet<Block> other$blocks = other.getBlocks();
        if (this$blocks == null ? other$blocks != null : !this$blocks.equals(other$blocks)) {
            return false;
        }
        Optional<Holder<AgroClimaticZone>> this$climate = this.getClimate();
        Optional<Holder<AgroClimaticZone>> other$climate = other.getClimate();
        if (this$climate == null ? other$climate != null : !((Object)this$climate).equals(other$climate)) {
            return false;
        }
        HolderSet<Biome> this$biomes = this.getBiomes();
        HolderSet<Biome> other$biomes = other.getBiomes();
        if (this$biomes == null ? other$biomes != null : !this$biomes.equals(other$biomes)) {
            return false;
        }
        List<Slice> this$slices = this.getSlices();
        List<Slice> other$slices = other.getSlices();
        if (this$slices == null ? other$slices != null : !((Object)this$slices).equals(other$slices)) {
            return false;
        }
        Enum2ObjectMap<SolarTerm, List<FlatSliceHolder>> this$flatSliceEnumMap = this.getFlatSliceEnumMap();
        Enum2ObjectMap<SolarTerm, List<FlatSliceHolder>> other$flatSliceEnumMap = other.getFlatSliceEnumMap();
        return !(this$flatSliceEnumMap == null ? other$flatSliceEnumMap != null : !((Object)this$flatSliceEnumMap).equals(other$flatSliceEnumMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SeasonBlockDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HolderSet<Block> $blocks = this.getBlocks();
        result = result * 59 + ($blocks == null ? 43 : $blocks.hashCode());
        Optional<Holder<AgroClimaticZone>> $climate = this.getClimate();
        result = result * 59 + ($climate == null ? 43 : ((Object)$climate).hashCode());
        HolderSet<Biome> $biomes = this.getBiomes();
        result = result * 59 + ($biomes == null ? 43 : $biomes.hashCode());
        List<Slice> $slices = this.getSlices();
        result = result * 59 + ($slices == null ? 43 : ((Object)$slices).hashCode());
        Enum2ObjectMap<SolarTerm, List<FlatSliceHolder>> $flatSliceEnumMap = this.getFlatSliceEnumMap();
        result = result * 59 + ($flatSliceEnumMap == null ? 43 : $flatSliceEnumMap.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SeasonBlockDefinition(blocks=" + String.valueOf(this.getBlocks()) + ", climate=" + String.valueOf(this.getClimate()) + ", biomes=" + String.valueOf(this.getBiomes()) + ", slices=" + String.valueOf(this.getSlices()) + ", flatSliceEnumMap=" + String.valueOf(this.getFlatSliceEnumMap()) + ")";
    }

    public static class Slice {
        public static final Pair<ResourceLocation, ResourceLocation> EMPTY_PAIR = Pair.of((Object)LocalSeasonStatusModel.EMPTY, (Object)LocalSeasonStatusModel.EMPTY);
        public static final Codec<Slice> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)ESExtraCodec.SOLAR_TERM.optionalFieldOf("start", (Object)SolarTerm.NONE).forGetter(o -> o.start), (App)ESExtraCodec.SOLAR_TERM.optionalFieldOf("end", (Object)SolarTerm.NONE).forGetter(o -> o.end), (App)ESExtraCodec.SOLAR_TERM.optionalFieldOf("solar_term", (Object)SolarTerm.NONE).forGetter(o -> o.solarTerm), (App)ESExtraCodec.SEASON.optionalFieldOf("start_season", (Object)Season.NONE).forGetter(o -> o.startSeason), (App)ESExtraCodec.SEASON.optionalFieldOf("end_season", (Object)Season.NONE).forGetter(o -> o.endSeason), (App)ESExtraCodec.SEASON.optionalFieldOf("season", (Object)Season.NONE).forGetter(o -> o.season), (App)ResourceLocation.f_135803_.optionalFieldOf("mid", (Object)LocalSeasonStatusModel.EMPTY).forGetter(o -> o.mid), (App)CodecUtil.pairCodec(ResourceLocation::new, a -> new ResourceLocation(a)).optionalFieldOf("transition_models", EMPTY_PAIR).forGetter(o -> o.transitionModels), (App)Codec.BOOL.optionalFieldOf("empty_above", (Object)true).forGetter(o -> o.emptyAbove)).apply((Applicative)ins, Slice::new));
        private final SolarTerm start;
        private final SolarTerm end;
        private final SolarTerm solarTerm;
        private final Season startSeason;
        private final Season endSeason;
        private final Season season;
        private final ResourceLocation mid;
        private final Pair<ResourceLocation, ResourceLocation> transitionModels;
        private final boolean emptyAbove;

        @Generated
        private static SolarTerm $default$start() {
            return SolarTerm.NONE;
        }

        @Generated
        private static SolarTerm $default$end() {
            return SolarTerm.NONE;
        }

        @Generated
        private static SolarTerm $default$solarTerm() {
            return SolarTerm.NONE;
        }

        @Generated
        private static Season $default$startSeason() {
            return Season.NONE;
        }

        @Generated
        private static Season $default$endSeason() {
            return Season.NONE;
        }

        @Generated
        private static Season $default$season() {
            return Season.NONE;
        }

        @Generated
        private static ResourceLocation $default$mid() {
            return LocalSeasonStatusModel.EMPTY;
        }

        @Generated
        private static Pair<ResourceLocation, ResourceLocation> $default$transitionModels() {
            return EMPTY_PAIR;
        }

        @Generated
        private static boolean $default$emptyAbove() {
            return true;
        }

        @Generated
        Slice(SolarTerm start2, SolarTerm end, SolarTerm solarTerm, Season startSeason, Season endSeason, Season season, ResourceLocation mid, Pair<ResourceLocation, ResourceLocation> transitionModels, boolean emptyAbove) {
            this.start = start2;
            this.end = end;
            this.solarTerm = solarTerm;
            this.startSeason = startSeason;
            this.endSeason = endSeason;
            this.season = season;
            this.mid = mid;
            this.transitionModels = transitionModels;
            this.emptyAbove = emptyAbove;
        }

        @Generated
        public static SliceBuilder builder() {
            return new SliceBuilder();
        }

        @Generated
        public SolarTerm getStart() {
            return this.start;
        }

        @Generated
        public SolarTerm getEnd() {
            return this.end;
        }

        @Generated
        public SolarTerm getSolarTerm() {
            return this.solarTerm;
        }

        @Generated
        public Season getStartSeason() {
            return this.startSeason;
        }

        @Generated
        public Season getEndSeason() {
            return this.endSeason;
        }

        @Generated
        public Season getSeason() {
            return this.season;
        }

        @Generated
        public ResourceLocation getMid() {
            return this.mid;
        }

        @Generated
        public Pair<ResourceLocation, ResourceLocation> getTransitionModels() {
            return this.transitionModels;
        }

        @Generated
        public boolean isEmptyAbove() {
            return this.emptyAbove;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Slice)) {
                return false;
            }
            Slice other = (Slice)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEmptyAbove() != other.isEmptyAbove()) {
                return false;
            }
            SolarTerm this$start = this.getStart();
            SolarTerm other$start = other.getStart();
            if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
                return false;
            }
            SolarTerm this$end = this.getEnd();
            SolarTerm other$end = other.getEnd();
            if (this$end == null ? other$end != null : !this$end.equals(other$end)) {
                return false;
            }
            SolarTerm this$solarTerm = this.getSolarTerm();
            SolarTerm other$solarTerm = other.getSolarTerm();
            if (this$solarTerm == null ? other$solarTerm != null : !this$solarTerm.equals(other$solarTerm)) {
                return false;
            }
            Season this$startSeason = this.getStartSeason();
            Season other$startSeason = other.getStartSeason();
            if (this$startSeason == null ? other$startSeason != null : !this$startSeason.equals(other$startSeason)) {
                return false;
            }
            Season this$endSeason = this.getEndSeason();
            Season other$endSeason = other.getEndSeason();
            if (this$endSeason == null ? other$endSeason != null : !this$endSeason.equals(other$endSeason)) {
                return false;
            }
            Season this$season = this.getSeason();
            Season other$season = other.getSeason();
            if (this$season == null ? other$season != null : !this$season.equals(other$season)) {
                return false;
            }
            ResourceLocation this$mid = this.getMid();
            ResourceLocation other$mid = other.getMid();
            if (this$mid == null ? other$mid != null : !this$mid.equals(other$mid)) {
                return false;
            }
            Pair<ResourceLocation, ResourceLocation> this$transitionModels = this.getTransitionModels();
            Pair<ResourceLocation, ResourceLocation> other$transitionModels = other.getTransitionModels();
            return !(this$transitionModels == null ? other$transitionModels != null : !this$transitionModels.equals(other$transitionModels));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Slice;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEmptyAbove() ? 79 : 97);
            SolarTerm $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : $start.hashCode());
            SolarTerm $end = this.getEnd();
            result = result * 59 + ($end == null ? 43 : $end.hashCode());
            SolarTerm $solarTerm = this.getSolarTerm();
            result = result * 59 + ($solarTerm == null ? 43 : $solarTerm.hashCode());
            Season $startSeason = this.getStartSeason();
            result = result * 59 + ($startSeason == null ? 43 : $startSeason.hashCode());
            Season $endSeason = this.getEndSeason();
            result = result * 59 + ($endSeason == null ? 43 : $endSeason.hashCode());
            Season $season = this.getSeason();
            result = result * 59 + ($season == null ? 43 : $season.hashCode());
            ResourceLocation $mid = this.getMid();
            result = result * 59 + ($mid == null ? 43 : $mid.hashCode());
            Pair<ResourceLocation, ResourceLocation> $transitionModels = this.getTransitionModels();
            result = result * 59 + ($transitionModels == null ? 43 : $transitionModels.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SeasonBlockDefinition.Slice(start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ", solarTerm=" + String.valueOf(this.getSolarTerm()) + ", startSeason=" + String.valueOf(this.getStartSeason()) + ", endSeason=" + String.valueOf(this.getEndSeason()) + ", season=" + String.valueOf(this.getSeason()) + ", mid=" + String.valueOf(this.getMid()) + ", transitionModels=" + String.valueOf(this.getTransitionModels()) + ", emptyAbove=" + this.isEmptyAbove() + ")";
        }

        @Generated
        public static class SliceBuilder {
            @Generated
            private boolean start$set;
            @Generated
            private SolarTerm start$value;
            @Generated
            private boolean end$set;
            @Generated
            private SolarTerm end$value;
            @Generated
            private boolean solarTerm$set;
            @Generated
            private SolarTerm solarTerm$value;
            @Generated
            private boolean startSeason$set;
            @Generated
            private Season startSeason$value;
            @Generated
            private boolean endSeason$set;
            @Generated
            private Season endSeason$value;
            @Generated
            private boolean season$set;
            @Generated
            private Season season$value;
            @Generated
            private boolean mid$set;
            @Generated
            private ResourceLocation mid$value;
            @Generated
            private boolean transitionModels$set;
            @Generated
            private Pair<ResourceLocation, ResourceLocation> transitionModels$value;
            @Generated
            private boolean emptyAbove$set;
            @Generated
            private boolean emptyAbove$value;

            @Generated
            SliceBuilder() {
            }

            @Generated
            public SliceBuilder start(SolarTerm start2) {
                this.start$value = start2;
                this.start$set = true;
                return this;
            }

            @Generated
            public SliceBuilder end(SolarTerm end) {
                this.end$value = end;
                this.end$set = true;
                return this;
            }

            @Generated
            public SliceBuilder solarTerm(SolarTerm solarTerm) {
                this.solarTerm$value = solarTerm;
                this.solarTerm$set = true;
                return this;
            }

            @Generated
            public SliceBuilder startSeason(Season startSeason) {
                this.startSeason$value = startSeason;
                this.startSeason$set = true;
                return this;
            }

            @Generated
            public SliceBuilder endSeason(Season endSeason) {
                this.endSeason$value = endSeason;
                this.endSeason$set = true;
                return this;
            }

            @Generated
            public SliceBuilder season(Season season) {
                this.season$value = season;
                this.season$set = true;
                return this;
            }

            @Generated
            public SliceBuilder mid(ResourceLocation mid) {
                this.mid$value = mid;
                this.mid$set = true;
                return this;
            }

            @Generated
            public SliceBuilder transitionModels(Pair<ResourceLocation, ResourceLocation> transitionModels) {
                this.transitionModels$value = transitionModels;
                this.transitionModels$set = true;
                return this;
            }

            @Generated
            public SliceBuilder emptyAbove(boolean emptyAbove) {
                this.emptyAbove$value = emptyAbove;
                this.emptyAbove$set = true;
                return this;
            }

            @Generated
            public Slice build() {
                SolarTerm start$value = this.start$value;
                if (!this.start$set) {
                    start$value = Slice.$default$start();
                }
                SolarTerm end$value = this.end$value;
                if (!this.end$set) {
                    end$value = Slice.$default$end();
                }
                SolarTerm solarTerm$value = this.solarTerm$value;
                if (!this.solarTerm$set) {
                    solarTerm$value = Slice.$default$solarTerm();
                }
                Season startSeason$value = this.startSeason$value;
                if (!this.startSeason$set) {
                    startSeason$value = Slice.$default$startSeason();
                }
                Season endSeason$value = this.endSeason$value;
                if (!this.endSeason$set) {
                    endSeason$value = Slice.$default$endSeason();
                }
                Season season$value = this.season$value;
                if (!this.season$set) {
                    season$value = Slice.$default$season();
                }
                ResourceLocation mid$value = this.mid$value;
                if (!this.mid$set) {
                    mid$value = Slice.$default$mid();
                }
                Pair<ResourceLocation, ResourceLocation> transitionModels$value = this.transitionModels$value;
                if (!this.transitionModels$set) {
                    transitionModels$value = Slice.$default$transitionModels();
                }
                boolean emptyAbove$value = this.emptyAbove$value;
                if (!this.emptyAbove$set) {
                    emptyAbove$value = Slice.$default$emptyAbove();
                }
                return new Slice(start$value, end$value, solarTerm$value, startSeason$value, endSeason$value, season$value, mid$value, transitionModels$value, emptyAbove$value);
            }

            @Generated
            public String toString() {
                return "SeasonBlockDefinition.Slice.SliceBuilder(start$value=" + String.valueOf(this.start$value) + ", end$value=" + String.valueOf(this.end$value) + ", solarTerm$value=" + String.valueOf(this.solarTerm$value) + ", startSeason$value=" + String.valueOf(this.startSeason$value) + ", endSeason$value=" + String.valueOf(this.endSeason$value) + ", season$value=" + String.valueOf(this.season$value) + ", mid$value=" + String.valueOf(this.mid$value) + ", transitionModels$value=" + String.valueOf(this.transitionModels$value) + ", emptyAbove$value=" + this.emptyAbove$value + ")";
            }
        }
    }

    public record FlatSlice(@Nullable ResourceLocation mid, boolean emptyAbove, @Nullable Pair<ResourceLocation, ResourceLocation> transitionModels) {
    }

    public record FlatSliceHolder(SolarTerm start, SolarTerm end, FlatSlice flatSlice) {
    }
}

