/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.solar.color.base;

import com.teamtea.eclipticseasons.api.constant.solar.color.base.SolarTermColor;
import com.teamtea.eclipticseasons.client.util.ColorHelper;
import net.minecraft.world.level.FoliageColor;

public enum RainySolarTermColors implements SolarTermColor
{
    BEGINNING_OF_SPRING,
    RAIN_WATER,
    INSECTS_AWAKENING,
    SPRING_EQUINOX,
    FRESH_GREEN(8370190, 0.16f),
    GRAIN_RAIN(8370190, 0.32f),
    BEGINNING_OF_SUMMER(8370190, 0.48f),
    LESSER_FULLNESS(8370190, 0.64f, 8370190, 0.1f),
    GRAIN_IN_EAR(8370190, 0.8f, 8370190, 0.2f),
    SUMMER_SOLSTICE(8370190, 0.8f, 8370190, 0.3f),
    LESSER_HEAT(ColorHelper.simplyMixColor(8370190, 0.8f, 13734463, 0.2f), 0.8f, 8370190, 0.4f),
    GREATER_HEAT(8370190, 0.5f, 16765952, 0.25f),
    BEGINNING_OF_AUTUMN(8370190, 0.5f, 16765952, 0.5f),
    END_OF_HEAT(8370190, 0.5f, 16765952, 0.75f),
    WHITE_DEW(8370190, 0.5f, 16765952, 1.0f),
    AUTUMNAL_EQUINOX(8370190, 0.4f, 16765952, 1.0f),
    COLD_DEW(8370190, 0.3f, 16765952, 1.0f),
    FIRST_FROST(8370190, 0.2f, ColorHelper.simplyMixColor(16765952, 0.8f, 12689779, 0.2f), 1.0f),
    BEGINNING_OF_WINTER(8370190, 0.1f, ColorHelper.simplyMixColor(16765952, 0.6f, 12689779, 0.4f), 1.0f),
    LIGHT_SNOW,
    HEAVY_SNOW,
    WINTER_SOLSTICE,
    LESSER_COLD,
    GREATER_COLD,
    NONE;

    private final int rainyColor;
    private final float rainyMix;
    private final int birchColor;
    private static final RainySolarTermColors[] values;

    private RainySolarTermColors(int rainyColorIn, float rainyMixIn, int birchColorIn, float birchAlphaIn) {
        this.rainyColor = rainyColorIn;
        this.rainyMix = rainyMixIn;
        this.birchColor = ColorHelper.simplyMixColor(birchColorIn, birchAlphaIn, FoliageColor.m_46113_(), 1.0f - birchAlphaIn);
    }

    private RainySolarTermColors(int rainyColorIn, float rainyMixIn) {
        this.rainyColor = rainyColorIn;
        this.rainyMix = rainyMixIn;
        this.birchColor = FoliageColor.m_46113_();
    }

    private RainySolarTermColors() {
        this.rainyColor = 0;
        this.rainyMix = 0.0f;
        this.birchColor = FoliageColor.m_46113_();
    }

    public static RainySolarTermColors[] collectValues() {
        return values;
    }

    public static RainySolarTermColors get(int index) {
        return RainySolarTermColors.collectValues()[index];
    }

    @Override
    public int getGrassColor() {
        return this.rainyColor;
    }

    @Override
    public float getMix() {
        return this.rainyMix;
    }

    @Override
    public int getLeaveColor() {
        return this.birchColor;
    }

    static {
        values = RainySolarTermColors.values();
    }
}

