/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.climate;

import com.teamtea.eclipticseasons.api.constant.climate.BiomeRain;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import java.util.Locale;

public enum TemperateRain implements BiomeRain
{
    BEGINNING_OF_SPRING(0.3f),
    RAIN_WATER(0.5f, 0.08f),
    INSECTS_AWAKENING(0.55f, 0.15f),
    SPRING_EQUINOX(0.5f, 0.1f),
    FRESH_GREEN(0.65f, 0.05f),
    GRAIN_RAIN(0.75f),
    BEGINNING_OF_SUMMER(0.9f),
    LESSER_FULLNESS(0.7f, 0.1f),
    GRAIN_IN_EAR(0.6f, 0.15f),
    SUMMER_SOLSTICE(0.7f, 0.25f),
    LESSER_HEAT(0.65f, 0.2f),
    GREATER_HEAT(0.5f, 0.05f),
    BEGINNING_OF_AUTUMN(0.42f),
    END_OF_HEAT(0.4f),
    WHITE_DEW(0.35f),
    AUTUMNAL_EQUINOX(0.32f),
    COLD_DEW(0.3f),
    FIRST_FROST(0.25f),
    BEGINNING_OF_WINTER(0.3f),
    LIGHT_SNOW(0.4f, 0.05f),
    HEAVY_SNOW(0.5f),
    WINTER_SOLSTICE(0.45f),
    LESSER_COLD(0.4f),
    GREATER_COLD(0.2f),
    NONE(0.0f, 0.0f);

    private final float rainChane;
    private final float thunderChance;
    private static final TemperateRain[] values;

    private TemperateRain(float rainChane) {
        this(rainChane, 0.0f);
    }

    private TemperateRain(float rainChane, float thunderChance) {
        this.rainChane = rainChane;
        this.thunderChance = thunderChance;
    }

    public String getName() {
        return this.toString().toLowerCase(Locale.ROOT);
    }

    @Override
    public float getRainChance() {
        return this.rainChane;
    }

    @Override
    public float getThunderChance() {
        return this.thunderChance;
    }

    @Override
    public SolarTerm getSolarTerm() {
        return SolarTerm.collectValues()[this.ordinal()];
    }

    @Override
    public Season getSeason() {
        return Season.collectValues()[this.ordinal() / 6];
    }

    public static TemperateRain[] collectValues() {
        return values;
    }

    static {
        values = TemperateRain.values();
    }
}

