/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.biome;

import com.teamtea.eclipticseasons.api.misc.ITranslatable;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public enum Temperature implements ITranslatable
{
    FREEZING(Float.NEGATIVE_INFINITY, 0.15f, -0.8f, 0.15f),
    COLD(0.15f, 0.4f),
    COOL(0.4f, 0.65f),
    WARM(0.65f, 0.9f),
    HOT(0.9f, 1.25f),
    HEAT(1.25f, Float.POSITIVE_INFINITY, 1.25f, 2.1f);

    private float min;
    private float max;
    private float limitMin;
    private float limitMax;
    private static final Temperature[] temperature;

    private Temperature(float min, float max) {
        this.min = min;
        this.max = max;
        this.limitMin = min;
        this.limitMax = max;
    }

    private Temperature(float min, float max, float limitMin, float limitMax) {
        this.min = min;
        this.max = max;
        this.limitMin = limitMin;
        this.limitMax = limitMax;
    }

    public int getId() {
        return this.ordinal() + 1;
    }

    @Override
    public String getName() {
        return this.toString().toLowerCase(Locale.ROOT);
    }

    public boolean isInTemperature(float temp) {
        return this.min < temp && temp <= this.max;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public float getLimitedMin() {
        return this.limitMin;
    }

    public float getLimitedMax() {
        return this.limitMax;
    }

    public float getWidth() {
        return this.max - this.min;
    }

    public static Temperature[] collectValues() {
        return temperature;
    }

    @Override
    public Component getTranslation() {
        return Component.m_237115_((String)("info.eclipticseasons.environment.temperature." + this.getName()));
    }

    public static Temperature getTemperatureLevel(float temp) {
        for (Temperature t : Temperature.collectValues()) {
            if (!t.isInTemperature(temp)) continue;
            return t;
        }
        return FREEZING;
    }

    public static float getTemperature(float temp) {
        for (Temperature t : Temperature.collectValues()) {
            if (!t.isInTemperature(temp)) continue;
            return Mth.m_14036_((float)((temp - t.getLimitedMin()) / (t.getLimitedMax() - t.getLimitedMin())), (float)0.0f, (float)1.0f) * 1.0f + (float)t.ordinal();
        }
        return 0.0f;
    }

    static {
        temperature = Temperature.values();
    }
}

