/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;

public class RenderUtils {
    public static void setupBlend() {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    public static void drawRect(int x, int y, int width, int height, int color) {
        RenderUtils.drawRect(x, y, width, height, color, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color, float zLevel) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.applyModelViewMatrix();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderUtils.setupBlend();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_((double)x, (double)y, (double)zLevel).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_((double)x, (double)(y + height), (double)zLevel).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), (double)zLevel).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, (double)zLevel).m_85950_(r, g, b, a).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }
}

