/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.config.entry.EntryBaseEntry;
import com.iafenvoy.jupiter.config.entry.ListBaseEntry;
import com.iafenvoy.jupiter.config.entry.MapBaseEntry;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.interfaces.IConfigEnumEntry;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.ButtonWidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.EntryWidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.ListWidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.MapWidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.SeparatorWidgetBuilder;
import com.iafenvoy.jupiter.render.widget.builder.TextFieldWidgetBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WidgetBuilderManager {
    private static final Map<ConfigType<?>, Function<IConfigEntry<?>, WidgetBuilder<?>>> BUILDERS = new HashMap();

    public static <T> void register(ConfigType<T> type, Function<IConfigEntry<T>, WidgetBuilder<T>> builder) {
        BUILDERS.put(type, builder);
    }

    public static <T> WidgetBuilder<T> get(IConfigEntry<T> entry) {
        return BUILDERS.get(entry.getType()).apply(entry);
    }

    static {
        WidgetBuilderManager.register(ConfigTypes.SEPARATOR, SeparatorWidgetBuilder::new);
        WidgetBuilderManager.register(ConfigTypes.BOOLEAN, config -> new ButtonWidgetBuilder(config, button -> config.setValue((Boolean)config.getValue() == false), () -> Component.m_130674_((String)((Boolean)config.getValue() != false ? "\u00a7atrue" : "\u00a7cfalse"))));
        WidgetBuilderManager.register(ConfigTypes.INTEGER, TextFieldWidgetBuilder::new);
        WidgetBuilderManager.register(ConfigTypes.DOUBLE, TextFieldWidgetBuilder::new);
        WidgetBuilderManager.register(ConfigTypes.STRING, TextFieldWidgetBuilder::new);
        WidgetBuilderManager.register(ConfigTypes.ENUM, config -> new ButtonWidgetBuilder(config, button -> config.setValue(((IConfigEnumEntry)config.getValue()).cycle(true)), () -> ((IConfigEnumEntry)config.getValue()).getDisplayText()));
        WidgetBuilderManager.register(ConfigTypes.LIST_STRING, config -> new ListWidgetBuilder((ListBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.LIST_INTEGER, config -> new ListWidgetBuilder((ListBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.LIST_DOUBLE, config -> new ListWidgetBuilder((ListBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.MAP_STRING, config -> new MapWidgetBuilder((MapBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.MAP_INTEGER, config -> new MapWidgetBuilder((MapBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.MAP_DOUBLE, config -> new MapWidgetBuilder((MapBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.ENTRY_STRING, config -> new EntryWidgetBuilder((EntryBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.ENTRY_INTEGER, config -> new EntryWidgetBuilder((EntryBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.ENTRY_DOUBLE, config -> new EntryWidgetBuilder((EntryBaseEntry)config));
        WidgetBuilderManager.register(ConfigTypes.IDENTIFIER, TextFieldWidgetBuilder::new);
    }
}

