/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.tooltips.client.filter.ItemFilter;
import dev.obscuria.tooltips.client.label.LabelProvider;
import dev.obscuria.tooltips.content.registry.TooltipRegistries;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record TooltipLabel(int priority, LabelProvider provider, ItemFilter filter) implements Comparable<TooltipLabel>
{
    public static final Codec<TooltipLabel> DIRECT_CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.INT.fieldOf("priority").forGetter(TooltipLabel::priority), (App)LabelProvider.CODEC.fieldOf("provider").forGetter(TooltipLabel::provider), (App)ItemFilter.CODEC.fieldOf("filter").forGetter(TooltipLabel::filter)).apply((Applicative)codec, TooltipLabel::new));

    public boolean isFor(ItemStack stack) {
        return this.filter.test(stack);
    }

    public ClientTooltipComponent create(ItemStack stack) {
        return this.provider.create(stack);
    }

    @Override
    public int compareTo(TooltipLabel other) {
        return Integer.compare(this.priority, other.priority);
    }

    @Nullable
    public static TooltipLabel findFor(ItemStack stack) {
        for (TooltipLabel label : TooltipRegistries.Resource.TOOLTIP_LABEL.listElements()) {
            if (!label.isFor(stack)) continue;
            return label;
        }
        return null;
    }
}

