/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.utility;

import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class KegRecipeWrapper
extends RecipeWrapper {
    private final IFluidHandler tank;

    public KegRecipeWrapper(IItemHandlerModifiable itemHandler, IFluidHandler fluidHandler) {
        super(itemHandler);
        this.tank = fluidHandler;
    }

    public FluidStack getFluid(int slot) {
        return this.tank.getFluidInTank(slot);
    }

    public void fillFluid(Fluid fluid, int amount) {
        this.tank.fill(new FluidStack(fluid, amount), IFluidHandler.FluidAction.EXECUTE);
    }

    public FluidStack drainFluid(int slot, int amount) {
        FluidStack stack = this.tank.getFluidInTank(slot);
        return stack.isEmpty() ? FluidStack.EMPTY : this.tank.drain(amount, IFluidHandler.FluidAction.EXECUTE);
    }

    public FluidStack drainFluidNoUpdate(int index, int amount) {
        FluidStack stack = this.tank.getFluidInTank(index);
        return stack.isEmpty() ? FluidStack.EMPTY : this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE);
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.tank.getTanks(); ++i) {
            if (this.tank.getFluidInTank(i).isEmpty()) continue;
            return false;
        }
        return super.m_7983_();
    }

    public void m_6211_() {
        for (int i = 0; i < this.tank.getTanks(); ++i) {
            this.tank.drain(this.tank.getTankCapacity(i), IFluidHandler.FluidAction.EXECUTE);
        }
    }
}

