/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.model.CoasterWrappedModel;
import umpaz.brewinandchewin.client.renderer.texture.BnCTextureModifiers;
import umpaz.brewinandchewin.client.renderer.texture.modifier.TextureModifier;
import umpaz.brewinandchewin.common.block.CoasterBlock;
import umpaz.brewinandchewin.common.block.entity.CoasterBlockEntity;

public class CoasterBlockEntityRenderer
implements BlockEntityRenderer<CoasterBlockEntity> {
    private static final Map<ResourceLocation, List<ModelEntry>> ITEM_TO_MODELS = new HashMap<ResourceLocation, List<ModelEntry>>();
    private static final Set<ResourceLocation> ERRONEOUS_ENTRIES = new HashSet<ResourceLocation>();

    public static void resetCache() {
        ITEM_TO_MODELS.clear();
        ERRONEOUS_ENTRIES.clear();
    }

    public static List<ModelEntry> getModelEntries(ResourceLocation itemId) {
        return ITEM_TO_MODELS.get(itemId);
    }

    public static void addToModelMap(ResourceLocation itemId, List<ModelEntry> models) {
        ITEM_TO_MODELS.put(itemId, models);
    }

    public CoasterBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    private void poseUtil(PoseStack poseStack, int fullCount, int curCount, RandomSource seededRandom, boolean invisible) {
        Vector2f translateVec = switch (fullCount) {
            default -> new Vector2f();
            case 2 -> {
                if (curCount == 0) {
                    yield new Vector2f(-0.2f, -0.15f);
                }
                yield new Vector2f(0.2f, 0.15f);
            }
            case 3 -> {
                if (curCount == 0) {
                    yield new Vector2f(0.05f, 0.25f);
                }
                if (curCount == 1) {
                    yield new Vector2f(-0.25f, -0.15f);
                }
                yield new Vector2f(0.25f, -0.25f);
            }
            case 4 -> curCount == 0 ? new Vector2f(0.2f, 0.25f) : (curCount == 1 ? new Vector2f(-0.25f, 0.2f) : (curCount == 2 ? new Vector2f(0.25f, -0.2f) : new Vector2f(-0.2f, -0.25f)));
        };
        float rotation = switch (fullCount) {
            default -> 0.0f;
            case 2 -> {
                if (curCount == 0) {
                    yield 190.0f;
                }
                yield 10.0f;
            }
            case 3 -> {
                if (curCount == 0) {
                    yield -20.0f;
                }
                if (curCount == 1) {
                    yield 220.0f;
                }
                yield 100.0f;
            }
            case 4 -> curCount == 0 ? -5.0f : (curCount == 1 ? 265.0f : (curCount == 2 ? 85.0f : 175.0f));
        };
        poseStack.m_272245_(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, rotation + seededRandom.m_188501_() * 20.0f - 10.0f), 0.5f + translateVec.x(), 0.0f, 0.5f + translateVec.y());
        poseStack.m_85837_((double)translateVec.x(), invisible ? 0.0 : 0.0625, (double)translateVec.y());
    }

    public void render(CoasterBlockEntity entity, float tickDelta, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        int count = (int)entity.getItems().stream().filter(i -> !i.m_41619_()).count();
        poseStack.m_272245_(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, -22.5f * (float)((Integer)entity.m_58900_().m_61143_((Property)CoasterBlock.ROTATION)).intValue()), 0.5f, 0.0f, 0.5f);
        LegacyRandomSource random = new LegacyRandomSource(entity.m_58899_().m_121878_());
        if (!((Boolean)entity.m_58900_().m_61143_((Property)CoasterBlock.INVISIBLE)).booleanValue() || count == 0) {
            poseStack.m_85836_();
            ResourceLocation modelId = (Integer)entity.m_58900_().m_61143_((Property)CoasterBlock.SIZE) > 1 ? new ResourceLocation("brewinandchewin", "block/coaster_tray") : new ResourceLocation("brewinandchewin", "block/coaster");
            Minecraft.m_91087_().m_91289_().m_110937_().tesselateBlock((BlockAndTintGetter)entity.m_58904_(), Minecraft.m_91087_().m_91304_().getModel(modelId), entity.m_58900_(), entity.m_58899_(), poseStack, buffer.m_6299_(RenderType.m_110463_()), false, (RandomSource)random, entity.m_58899_().m_121878_(), combinedOverlay, ModelData.EMPTY, null);
            poseStack.m_85849_();
        }
        int tintIndex = -1;
        for (int i2 = 0; i2 < count; ++i2) {
            ItemStack stack = (ItemStack)entity.getItems().get(i2);
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
            List<ModelEntry> modelEntries = CoasterBlockEntityRenderer.getModelEntries(itemId);
            poseStack.m_85836_();
            this.poseUtil(poseStack, count, i2, (RandomSource)random, (Boolean)entity.m_58900_().m_61143_((Property)CoasterBlock.INVISIBLE));
            if (modelEntries != null) {
                for (ModelEntry modelEntry : modelEntries) {
                    BakedModel coasterModel = CoasterBlockEntityRenderer.getCoasterModel(itemId, modelEntry);
                    int color = -1;
                    RenderType renderType = RenderType.m_110463_();
                    for (int j = 0; j < modelEntry.modifiers().size(); ++j) {
                        for (TextureModifier textureModifier : modelEntry.modifiers()) {
                            color = textureModifier.color((BlockAndTintGetter)entity.m_58904_(), entity.m_58900_(), entity.m_58899_(), stack, color);
                            renderType = textureModifier.renderType((BlockAndTintGetter)entity.m_58904_(), entity.m_58900_(), entity.m_58899_(), stack, renderType);
                        }
                    }
                    ModelData data = ModelData.EMPTY;
                    if (color != -1) {
                        data = ModelData.builder().with(CoasterWrappedModel.TINT_INDEX, (Object)(++tintIndex)).build();
                    }
                    VertexConsumer consumer = buffer.m_6299_(renderType);
                    Minecraft.m_91087_().m_91289_().m_110937_().tesselateBlock((BlockAndTintGetter)entity.m_58904_(), coasterModel, entity.m_58900_(), entity.m_58899_(), poseStack, consumer, false, (RandomSource)random, entity.m_58899_().m_121878_(), combinedOverlay, data, renderType);
                }
            } else {
                poseStack.m_85837_(0.51, 0.05, 0.5);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, entity.m_58904_(), (int)entity.m_58899_().m_121878_());
            }
            poseStack.m_85849_();
        }
    }

    public static BakedModel getCoasterModel(ResourceLocation itemId, ModelEntry modelEntry) {
        BakedModel model = Minecraft.m_91087_().m_91304_().getModel(modelEntry.model());
        if (model == Minecraft.m_91087_().m_91304_().m_119409_() && !ERRONEOUS_ENTRIES.contains(modelEntry.model())) {
            BrewinAndChewin.LOG.error("Failed to get model '{}'", (Object)modelEntry.model());
            ERRONEOUS_ENTRIES.add(modelEntry.model());
        }
        return model;
    }

    public record ModelEntry(ResourceLocation model, List<? extends TextureModifier> modifiers) {
        private static final Codec<ModelEntry> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.f_135803_.fieldOf("model").forGetter(ModelEntry::model), (App)BnCTextureModifiers.CODEC.listOf().optionalFieldOf("texture_modifiers", List.of()).forGetter(modelEntry -> modelEntry.modifiers())).apply((Applicative)inst, ModelEntry::new));
        public static final Codec<List<ModelEntry>> LIST_CODEC = Codec.either((Codec)ResourceLocation.f_135803_, (Codec)DIRECT_CODEC.listOf()).xmap(either -> (List)either.map(resourceLocation -> List.of(new ModelEntry((ResourceLocation)resourceLocation, List.of())), Function.identity()), modelEntry -> {
            if (modelEntry.size() == 1 && ((ModelEntry)modelEntry.get(0)).modifiers().isEmpty()) {
                return Either.left((Object)((ModelEntry)modelEntry.get(0)).model());
            }
            return Either.right((Object)modelEntry);
        });
    }
}

