/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.PeppermintBlock;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class EncrustedPeppermintFeature
extends Feature<NoneFeatureConfiguration> {
    public EncrustedPeppermintFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        RandomSource randomSource = context.m_225041_();
        return this.tryPlacePeppermint(level, pos, randomSource);
    }

    private boolean tryPlacePeppermint(WorldGenLevel level, BlockPos pos, RandomSource randomSource) {
        if (level.m_8055_(pos).m_60795_()) {
            ArrayList<Direction> possiblities = new ArrayList<Direction>();
            for (Direction possible : Direction.values()) {
                BlockPos check = pos.m_121945_(possible);
                if (!this.isSameChunk(pos, check) || !level.m_8055_(check).m_60713_((Block)ACBlockRegistry.CAKE_LAYER.get())) continue;
                possiblities.add(possible.m_122424_());
            }
            Direction direction = EncrustedPeppermintFeature.selectDirection(possiblities, randomSource);
            if (direction != null) {
                Block peppermint = randomSource.m_188501_() > 0.7f ? (Block)ACBlockRegistry.LARGE_PEPPERMINT.get() : (Block)ACBlockRegistry.SMALL_PEPPERMINT.get();
                level.m_7731_(pos, (BlockState)peppermint.m_49966_().m_61124_((Property)PeppermintBlock.FACING, (Comparable)direction), 3);
                return true;
            }
        }
        return false;
    }

    private boolean isSameChunk(BlockPos pos, BlockPos check) {
        return SectionPos.m_123171_((int)pos.m_123341_()) == SectionPos.m_123171_((int)check.m_123341_()) && SectionPos.m_123171_((int)pos.m_123343_()) == SectionPos.m_123171_((int)check.m_123343_());
    }

    private static Direction selectDirection(List<Direction> directionList, RandomSource randomSource) {
        if (directionList.size() <= 0) {
            return null;
        }
        if (directionList.size() <= 1) {
            return directionList.get(0);
        }
        return directionList.get(randomSource.m_188503_(directionList.size() - 1));
    }
}

