/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.blockentity;

import com.github.alexmodguy.alexscaves.client.model.ConversionCrucibleModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.SugarStaffHexRenderer;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ConversionCrucibleBlockEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ConversionCrucibleBlockRenderer<T extends ConversionCrucibleBlockEntity>
implements BlockEntityRenderer<T> {
    private static final ConversionCrucibleModel MODEL = new ConversionCrucibleModel();
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves", "textures/entity/conversion_crucible.png");
    private static final ResourceLocation TEXTURE_OVERLAY = new ResourceLocation("alexscaves", "textures/entity/conversion_crucible_active.png");
    private static final ResourceLocation TEXTURE_FLUID = new ResourceLocation("alexscaves", "textures/entity/conversion_crucible_fluid.png");
    private static final ResourceLocation TEXTURE_HEX = new ResourceLocation("alexscaves", "textures/entity/sugar_staff_hex.png");
    protected final RandomSource random = RandomSource.m_216327_();

    public ConversionCrucibleBlockRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(T crucible, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float conversionProgress = ((ConversionCrucibleBlockEntity)((Object)crucible)).getConversionProgress(partialTicks);
        float splashProgress = ((ConversionCrucibleBlockEntity)((Object)crucible)).getSplashProgress(partialTicks);
        float showItemProgress = ((ConversionCrucibleBlockEntity)((Object)crucible)).getItemDisplayProgress(partialTicks) * (1.0f - splashProgress);
        float conversionProgressSq = conversionProgress * conversionProgress;
        float conversionProgressSqrt = (float)Math.sqrt(conversionProgress);
        float ageInTicks = (float)((ConversionCrucibleBlockEntity)((Object)crucible)).tickCount + partialTicks;
        ItemStack displayStack = ((ConversionCrucibleBlockEntity)((Object)crucible)).getDisplayItem();
        int intcolor = ((ConversionCrucibleBlockEntity)((Object)crucible)).getConvertingToColor();
        float r = (float)((intcolor & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((intcolor & 0xFF00) >> 8) / 255.0f;
        float b = (float)((intcolor & 0xFF) >> 0) / 255.0f;
        float bob1 = (float)(Math.sin(ageInTicks * 0.5f) * 0.25) + 0.75f;
        float bob2 = ((float)(Math.sin(ageInTicks * 0.25f) * 0.25) + 0.75f) * 0.4f;
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 1.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
        MODEL.hideBeam(true);
        MODEL.hideSauce(true);
        MODEL.m_6973_(null, splashProgress, conversionProgress, ageInTicks, 0.0f, 0.0f);
        MODEL.setFilledLevel(((ConversionCrucibleBlockEntity)((Object)crucible)).getFilledLevel());
        MODEL.m_7695_(poseStack, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        if (conversionProgress > 0.0f) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 1.3f, 0.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(ageInTicks * 15.0f));
            poseStack.m_85841_(15.0f * conversionProgress, 15.0f * conversionProgress, 15.0f * conversionProgress);
            for (int i = 0; i < 5; ++i) {
                float f = (1.0f - (float)i / 5.0f) * 0.5f;
                float bob3 = (float)(Math.sin(ageInTicks * 0.5f + (float)i) * (double)0.005f);
                SugarStaffHexRenderer.renderHex(poseStack, bufferIn, ACRenderTypes.getVoidBeingCloud(TEXTURE_HEX), f * conversionProgressSqrt, r, g, b);
                poseStack.m_252880_(0.0f, -0.005f - bob3 * 0.03f, 0.0f);
            }
            poseStack.m_85849_();
        }
        if (((ConversionCrucibleBlockEntity)((Object)crucible)).getFilledLevel() > 0) {
            MODEL.hideBeam(true);
            MODEL.hideSauce(false);
            MODEL.m_7695_(poseStack, bufferIn.m_6299_(ACRenderTypes.getVoidBeingCloud(TEXTURE_FLUID)), combinedLightIn, combinedOverlayIn, r, g, b, 1.0f);
        }
        MODEL.hideBeam(false);
        MODEL.hideSauce(true);
        MODEL.m_7695_(poseStack, bufferIn.m_6299_(ACRenderTypes.getVoidBeingCloud(TEXTURE_OVERLAY)), combinedLightIn, combinedOverlayIn, r, g, b, Math.max(splashProgress, bob1 * conversionProgress));
        poseStack.m_85849_();
        float cameraY = Minecraft.m_91087_().m_91290_().f_114358_.m_90590_();
        float lightLength = 1.25f + bob2;
        float lightWidth = 0.35f;
        Component text = ((ConversionCrucibleBlockEntity)((Object)crucible)).getDisplayText();
        if (showItemProgress > 0.0f) {
            poseStack.m_252880_(0.5f, 1.25f, 0.5f);
            if (!displayStack.m_41619_()) {
                poseStack.m_85836_();
                poseStack.m_252880_(-0.15f, bob2 - 0.15f, -0.15f);
                poseStack.m_85841_(0.35f, 0.35f, 0.35f);
                poseStack.m_85837_(0.5, 0.0, 0.5);
                poseStack.m_252781_(Axis.f_252392_.m_252977_(ageInTicks * 3.0f));
                poseStack.m_85837_(-0.5, 0.0, -0.5);
                BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(displayStack, crucible.m_58904_(), null, 0);
                RenderType rt = ACRenderTypes.getTeslaBulb(TextureAtlas.f_118259_);
                ConversionCrucibleBlockRenderer.renderModel(poseStack.m_85850_(), bufferIn.m_6299_(rt), showItemProgress * 0.35f, null, bakedmodel, r, g, b, 240, OverlayTexture.f_118083_, ModelData.EMPTY, rt);
                poseStack.m_85849_();
            }
            if (text != null) {
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 0.45f + bob2, 0.0f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - cameraY));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                poseStack.m_85841_(0.02f, 0.02f, 0.02f);
                float f = -Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text) / 2;
                Minecraft.m_91087_().f_91062_.m_168645_(text.m_7532_(), f, 0.0f, FastColor.ARGB32.m_13660_((int)Mth.m_14045_((int)((int)(showItemProgress * 255.0f)), (int)4, (int)255), (int)255, (int)255, (int)255), FastColor.ARGB32.m_13660_((int)Mth.m_14045_((int)((int)(showItemProgress * 200.0f)), (int)4, (int)255), (int)((int)(r * 255.0f)), (int)((int)(g * 255.0f)), (int)((int)(b * 255.0f))), poseStack.m_85850_().m_252922_(), bufferIn, 240);
                poseStack.m_85849_();
            }
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, -1.1f, 0.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - cameraY));
            PoseStack.Pose posestack$pose1 = poseStack.m_85850_();
            Matrix4f matrix4f2 = posestack$pose1.m_252922_();
            Matrix3f matrix3f2 = posestack$pose1.m_252943_();
            VertexConsumer lightConsumer = bufferIn.m_6299_(ACRenderTypes.getCrucibleItemBeam());
            ConversionCrucibleBlockRenderer.shineOriginVertex(lightConsumer, matrix4f2, matrix3f2, 0.0f, 0.0f, r, g, b, 12.0f * showItemProgress);
            ConversionCrucibleBlockRenderer.shineLeftCornerVertex(lightConsumer, matrix4f2, matrix3f2, lightLength, lightWidth, 0.0f, 0.0f, r, g, b, 0.0f);
            ConversionCrucibleBlockRenderer.shineRightCornerVertex(lightConsumer, matrix4f2, matrix3f2, lightLength, lightWidth, 0.0f, 0.0f, r, g, b, 0.0f);
            ConversionCrucibleBlockRenderer.shineLeftCornerVertex(lightConsumer, matrix4f2, matrix3f2, lightLength, lightWidth, 0.0f, 0.0f, r, g, b, 0.0f);
            poseStack.m_85849_();
        }
    }

    public static void renderModel(PoseStack.Pose p_111068_, VertexConsumer p_111069_, float alpha, @Nullable BlockState p_111070_, BakedModel p_111071_, float p_111072_, float p_111073_, float p_111074_, int p_111075_, int p_111076_, ModelData modelData, RenderType renderType) {
        RandomSource randomsource = RandomSource.m_216327_();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            randomsource.m_188584_(42L);
            ConversionCrucibleBlockRenderer.renderQuadList(p_111068_, p_111069_, p_111072_, p_111073_, p_111074_, alpha, p_111071_.getQuads(p_111070_, direction, randomsource, modelData, renderType), p_111075_, p_111076_);
        }
        randomsource.m_188584_(42L);
        ConversionCrucibleBlockRenderer.renderQuadList(p_111068_, p_111069_, p_111072_, p_111073_, p_111074_, alpha, p_111071_.getQuads(p_111070_, (Direction)null, randomsource, modelData, renderType), p_111075_, p_111076_);
    }

    private static void renderQuadList(PoseStack.Pose p_111059_, VertexConsumer p_111060_, float p_111061_, float p_111062_, float p_111063_, float alpha, List<BakedQuad> p_111064_, int p_111065_, int p_111066_) {
        for (BakedQuad bakedquad : p_111064_) {
            float f = Mth.m_14036_((float)p_111061_, (float)0.0f, (float)1.0f);
            float f1 = Mth.m_14036_((float)p_111062_, (float)0.0f, (float)1.0f);
            float f2 = Mth.m_14036_((float)p_111063_, (float)0.0f, (float)1.0f);
            p_111060_.putBulkData(p_111059_, bakedquad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, f, f1, f2, alpha, new int[]{p_111065_, p_111065_, p_111065_, p_111065_}, p_111066_, false);
        }
    }

    private static void shineOriginVertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, float xOffset, float yOffset, float r, float g, float b, float a) {
        vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, a).m_7421_(xOffset + 0.5f, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void shineLeftCornerVertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, float length, float width, float xOffset, float yOffset, float r, float g, float b, float a) {
        vertexConsumer.m_252986_(matrix4f, -ACMath.HALF_SQRT_3 * width, length, 0.0f).m_85950_(r, g, b, a).m_7421_(xOffset, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void shineRightCornerVertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, float length, float width, float xOffset, float yOffset, float r, float g, float b, float a) {
        vertexConsumer.m_252986_(matrix4f, ACMath.HALF_SQRT_3 * width, length, 0.0f).m_85950_(r, g, b, a).m_7421_(xOffset + 1.0f, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    public int m_142163_() {
        return 128;
    }
}

