/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.client.model.LuxtructosaurusModel;
import com.github.alexmodguy.alexscaves.client.render.entity.LuxtructosaurusRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.LuxtructosaurusEntity;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.TabulaModelRenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class LuxtructosaurusAshParticle
extends TextureSheetParticle {
    private static final float ACCELERATION_SCALE = 0.0025f;
    private static final int INITIAL_LIFETIME = 300;
    private static final int CURVE_ENDPOINT_TIME = 300;
    private static final float FALL_ACC = 0.25f;
    private static final float WIND_BIG = 2.0f;
    private final SpriteSet sprites;
    private final int luxtructosaurusId;
    private final float particleRandom;

    protected LuxtructosaurusAshParticle(ClientLevel level, double x, double y, double z, int luxtructosaurusId, SpriteSet sprites) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_172258_ = 0.96f;
        this.f_172259_ = true;
        this.sprites = sprites;
        this.f_107663_ *= 3.0f + this.f_107223_.m_188501_() * 5.0f;
        this.f_107225_ = 300;
        this.m_108339_(sprites);
        this.f_107219_ = true;
        this.luxtructosaurusId = luxtructosaurusId;
        this.setInitialPos();
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107215_ = 0.3f - this.f_107223_.m_188501_() * 0.1f;
        this.f_107216_ = 0.2f - this.f_107223_.m_188501_() * 0.1f;
        this.f_107217_ = 0.3f - this.f_107223_.m_188501_() * 0.1f;
        this.f_107226_ = -0.005f - this.f_107223_.m_188501_() * 0.04f;
        this.particleRandom = this.f_107223_.m_188501_();
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
        float ageSca = (float)this.f_107224_ / (float)this.f_107225_;
        this.m_107271_(1.0f - ageSca);
        this.f_107215_ *= (double)1.01f;
        this.f_107216_ *= (double)1.01f;
        this.f_107217_ *= (double)1.01f;
        this.f_107227_ = Mth.m_14121_((float)this.f_107227_, (float)0.2f, (float)0.025f);
        this.f_107228_ = Mth.m_14121_((float)this.f_107228_, (float)0.2f, (float)0.025f);
        this.f_107229_ = Mth.m_14121_((float)this.f_107229_, (float)0.2f, (float)0.025f);
        if (!this.f_107220_) {
            float f = 300 - this.f_107225_;
            float f1 = Math.min(f / 300.0f, 1.0f);
            double d0 = Math.cos(Math.toRadians(this.particleRandom * 60.0f)) * 5.0 * Math.pow(f1, 1.25);
            double d1 = Math.sin(Math.toRadians(this.particleRandom * 60.0f)) * 5.0 * Math.pow(f1, 1.25);
            this.f_107215_ += d0 * (double)0.0025f;
            this.f_107217_ += d1 * (double)0.0025f;
            this.f_107216_ -= (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            if (this.f_107218_ || this.f_107225_ < 299 && (this.f_107215_ == 0.0 || this.f_107217_ == 0.0)) {
                this.m_107274_();
            }
            if (!this.f_107220_) {
                this.f_107215_ *= (double)this.f_172258_;
                this.f_107216_ *= (double)this.f_172258_;
                this.f_107217_ *= (double)this.f_172258_;
            }
        }
    }

    public float m_5902_(float partialTicks) {
        return this.f_107663_ * Mth.m_14036_((float)(1.0f - ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_), (float)0.0f, (float)1.0f);
    }

    public void setInitialPos() {
        Entity entity;
        if (this.luxtructosaurusId != -1 && (entity = this.f_107208_.m_6815_(this.luxtructosaurusId)) instanceof LuxtructosaurusEntity) {
            LuxtructosaurusEntity luxtructosaurus = (LuxtructosaurusEntity)entity;
            EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
            EntityRenderer entityRenderer = manager.m_114382_((Entity)luxtructosaurus);
            if (entityRenderer instanceof LuxtructosaurusRenderer) {
                LuxtructosaurusRenderer luxtructosaurusRenderer = (LuxtructosaurusRenderer)entityRenderer;
                LuxtructosaurusModel model = (LuxtructosaurusModel)luxtructosaurusRenderer.m_7200_();
                for (int attempts = 0; attempts < 5; ++attempts) {
                    TabulaModelRenderUtils.ModelBox randomBox;
                    AdvancedModelBox box = model.getRandomModelPart(this.f_107208_.m_213780_());
                    TabulaModelRenderUtils.ModelBox modelBox = randomBox = box.cubeList.size() > 0 ? (TabulaModelRenderUtils.ModelBox)box.cubeList.get(this.f_107223_.m_188503_(box.cubeList.size())) : null;
                    if (randomBox == null) continue;
                    float f = this.f_107223_.m_188501_();
                    float f1 = this.f_107223_.m_188501_();
                    float f2 = this.f_107223_.m_188501_();
                    float f3 = Mth.m_14179_((float)f, (float)randomBox.posX1, (float)randomBox.posX2) / 16.0f;
                    float f4 = Mth.m_14179_((float)f1, (float)randomBox.posY1, (float)randomBox.posY2) / 16.0f;
                    float f5 = Mth.m_14179_((float)f2, (float)randomBox.posZ1, (float)randomBox.posZ2) / 16.0f;
                    Vec3 innerOffset = new Vec3((double)f3, (double)f4, (double)f5);
                    Vec3 translate = this.translateAndRotate(box, innerOffset).m_82524_((float)(Math.PI - (double)(luxtructosaurus.f_20883_ * ((float)Math.PI / 180))));
                    this.m_107264_(luxtructosaurus.m_20185_() + translate.f_82479_, luxtructosaurus.m_20186_() + translate.f_82480_, luxtructosaurus.m_20189_() + translate.f_82481_);
                    return;
                }
            }
            this.f_107230_ = 1.0f;
            this.m_107274_();
        }
    }

    private Vec3 translateAndRotate(AdvancedModelBox box, Vec3 offsetIn) {
        PoseStack translationStack = new PoseStack();
        translationStack.m_85836_();
        ArrayList<AdvancedModelBox> flipMe = new ArrayList<AdvancedModelBox>();
        while (box.getParent() != null) {
            box = box.getParent();
            flipMe.add(box);
        }
        Collections.reverse(flipMe);
        for (AdvancedModelBox translateBy : flipMe) {
            translateBy.translateAndRotate(translationStack);
        }
        translationStack.m_85837_(offsetIn.f_82479_, offsetIn.f_82480_, offsetIn.f_82481_);
        Vector4f armOffsetVec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        armOffsetVec.mul((Matrix4fc)translationStack.m_85850_().m_252922_());
        Vec3 vec3 = new Vec3((double)(-armOffsetVec.x()), (double)(-armOffsetVec.y()), (double)armOffsetVec.z());
        translationStack.m_85849_();
        return vec3.m_82520_(0.0, 2.0, 0.0);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LuxtructosaurusAshParticle particle = new LuxtructosaurusAshParticle(worldIn, x, y, z, (int)xSpeed, this.spriteSet);
            float hue = worldIn.f_46441_.m_188501_() * 0.1f;
            particle.m_107253_(0.9f + hue, 0.4f + hue, hue);
            return particle;
        }
    }
}

