/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.MagnetronEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import net.minecraft.util.Mth;

public class MagnetronModel
extends AdvancedEntityModel<MagnetronEntity> {
    private final AdvancedModelBox wheel;
    private final AdvancedModelBox headPivot;
    private final AdvancedModelBox head;
    private final AdvancedModelBox headExtra;

    public MagnetronModel() {
        this.texWidth = 128;
        this.texHeight = 128;
        this.wheel = new AdvancedModelBox((AdvancedEntityModel)this);
        this.wheel.setRotationPoint(0.0f, 16.0f, 0.0f);
        this.wheel.setTextureOffset(28, 28).addBox(-3.0f, -8.0f, -8.0f, 6.0f, 4.0f, 16.0f, 0.0f, false);
        this.wheel.setTextureOffset(40, 60).addBox(-3.0f, -4.0f, -8.0f, 6.0f, 8.0f, 4.0f, 0.0f, false);
        this.wheel.setTextureOffset(56, 22).addBox(-3.0f, -4.0f, 4.0f, 6.0f, 8.0f, 4.0f, 0.0f, false);
        this.wheel.setTextureOffset(0, 44).addBox(-3.0f, 4.0f, -8.0f, 6.0f, 4.0f, 16.0f, 0.0f, false);
        this.headPivot = new AdvancedModelBox((AdvancedEntityModel)this);
        this.headPivot.setRotationPoint(0.0f, 0.0f, -2.0f);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.setRotationAngle(this.head, 0.3927f, 0.0f, 0.0f);
        this.headPivot.addChild((BasicModelPart)this.head);
        this.headExtra = new AdvancedModelBox((AdvancedEntityModel)this);
        this.headExtra.setRotationPoint(0.0f, 2.0f, 0.0f);
        this.head.addChild((BasicModelPart)this.headExtra);
        this.setRotationAngle(this.headExtra, 0.0f, -0.7854f, 0.0f);
        this.headExtra.setTextureOffset(52, 48).addBox(-2.0f, -5.0f, 18.0f, 6.0f, 6.0f, 6.0f, 0.0f, false);
        this.headExtra.setTextureOffset(0, 22).addBox(-8.0f, -5.0f, 8.0f, 6.0f, 6.0f, 16.0f, 0.0f, false);
        this.headExtra.setTextureOffset(28, 48).addBox(18.0f, -5.0f, -2.0f, 6.0f, 6.0f, 6.0f, 0.0f, false);
        this.headExtra.setTextureOffset(48, 0).addBox(8.0f, -5.0f, -8.0f, 16.0f, 6.0f, 6.0f, 0.0f, false);
        this.headExtra.setTextureOffset(0, 0).addBox(-8.0f, -5.0f, -8.0f, 16.0f, 6.0f, 16.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.wheel, (Object)this.headPivot);
    }

    public void setupAnim(MagnetronEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float formProgress = Math.min(1.0f, entity.getFormProgress(partialTick) * 10.0f);
        float rollProgress = 1.0f - formProgress;
        float rollLeanProgress = rollProgress * entity.getRollLeanProgress(partialTick);
        float timeRolling = (float)Math.toRadians(Mth.m_14177_((float)entity.getRollPosition(partialTick)));
        float bodyYaw = entity.f_20884_ + (entity.f_20883_ - entity.f_20884_) * partialTick;
        float wheelYaw = (entity.getWheelYaw(partialTick) - bodyYaw) * rollProgress + 90.0f * formProgress;
        this.progressRotationPrev(this.head, rollLeanProgress, (float)Math.toRadians(20.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.headPivot, rollLeanProgress, 0.0f, -2.0f, -4.0f, 1.0f);
        this.bob(this.headPivot, 0.15f, 1.5f, false, ageInTicks, 1.0f);
        this.wheel.rotateAngleY = (float)Math.toRadians(wheelYaw);
        if (entity.isFormed()) {
            float f = (float)Mth.m_14175_((double)Math.toDegrees(entity.clientRoll));
        } else {
            entity.clientRoll = this.wheel.rotateAngleX = timeRolling * rollProgress;
            this.bob(this.wheel, 1.0f, 10.0f, true, timeRolling, rollProgress);
            this.bob(this.headPivot, 1.0f, 4.0f, true, timeRolling, rollProgress);
        }
        this.wheel.showModel = entity.m_6084_();
        this.faceTarget(netHeadYaw, headPitch, 1.0f, new AdvancedModelBox[]{this.headPivot});
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.wheel, (Object)this.headPivot, (Object)this.head, (Object)this.headExtra);
    }

    public void setRotationAngle(AdvancedModelBox AdvancedModelBox2, float x, float y, float z) {
        AdvancedModelBox2.rotateAngleX = x;
        AdvancedModelBox2.rotateAngleY = y;
        AdvancedModelBox2.rotateAngleZ = z;
    }
}

