/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.worker;

import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.backend.sampler.ChunkSampler;
import caeruleusTait.world.preview.backend.worker.SampleUtils;
import caeruleusTait.world.preview.backend.worker.WorkResult;
import caeruleusTait.world.preview.backend.worker.WorkUnit;
import caeruleusTait.world.preview.mixin.NoiseChunkAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;

public class IntersectionWorkUnit
extends WorkUnit {
    private final ChunkSampler sampler;
    private final int numChunks;
    private final int yStride;

    public IntersectionWorkUnit(ChunkSampler sampler, SampleUtils sampleUtils, ChunkPos chunkPos, int numChunks, PreviewData previewData, int yStride) {
        super(sampleUtils, chunkPos, previewData, 0);
        this.sampler = sampler;
        this.numChunks = numChunks;
        this.yStride = yStride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<WorkResult> doWork() {
        NoiseGeneratorSettings noiseGeneratorSettings = this.sampleUtils.noiseGeneratorSettings();
        if (noiseGeneratorSettings == null) {
            return List.of();
        }
        NoiseSettings noiseSettings = noiseGeneratorSettings.f_64439_();
        NoiseChunk noiseChunk = this.sampleUtils.getNoiseChunk(this.chunkPos, this.numChunks, true);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int yMin = noiseSettings.f_158688_();
        int yMax = yMin + noiseSettings.f_64508_();
        int cellWidth = noiseSettings.m_189213_();
        int cellHeight = noiseSettings.m_189212_();
        int cellMinY = Mth.m_14042_((int)yMin, (int)noiseSettings.m_189212_());
        int cellCountY = Mth.m_14042_((int)noiseSettings.f_64508_(), (int)noiseSettings.m_189212_());
        int minBlockX = this.chunkPos.m_45604_();
        int minBlockZ = this.chunkPos.m_45605_();
        int cellCountXZ = 16 * this.numChunks / cellWidth;
        int cellStrideXZ = Math.max(1, this.sampler.blockStride() / cellWidth);
        int todoArraySize = Math.max(1, cellWidth / this.sampler.blockStride()) * Math.max(1, cellWidth / this.sampler.blockStride());
        ArrayList<WorkResult> results = new ArrayList<WorkResult>((yMax - yMin) / this.yStride);
        for (int y = yMin; y <= yMax; y += this.yStride) {
            results.add(new WorkResult(this, QuartPos.m_175400_((int)y), y == this.y ? this.primarySection : this.storage.section4(this.chunkPos, y, this.flags()), new ArrayList<WorkResult.BlockResult>(this.numChunks * this.numChunks * 4 * 4), List.of()));
        }
        noiseChunk.m_188791_();
        try {
            for (int cellX = 0; cellX < cellCountXZ && !this.isCanceled(); cellX += cellStrideXZ) {
                noiseChunk.m_188749_(cellX);
                for (int cellZ = 0; cellZ < cellCountXZ && !this.isCanceled(); cellZ += cellStrideXZ) {
                    ArrayList<XZPair> positions = new ArrayList<XZPair>(todoArraySize);
                    for (int xInCell = 0; xInCell < cellWidth; xInCell += this.sampler.blockStride()) {
                        for (int zInCell = 0; zInCell < cellWidth; zInCell += this.sampler.blockStride()) {
                            int x = minBlockX + cellX * cellWidth + xInCell;
                            int z = minBlockZ + cellZ * cellWidth + zInCell;
                            positions.add(new XZPair(x, (double)xInCell / (double)cellWidth, z, (double)zInCell / (double)cellWidth, new AtomicInteger(0)));
                        }
                    }
                    int lastCellY = Integer.MIN_VALUE;
                    for (int yTemp = yMin; yTemp <= yMax; yTemp += this.yStride) {
                        int y = Math.min(yTemp, yMax - 1);
                        int cellY = Math.min(Math.floorDiv(y - yMin, cellHeight), cellCountY - 1);
                        int yInCell = y % cellHeight;
                        if (cellY != lastCellY) {
                            noiseChunk.m_188810_(cellY, cellZ);
                        }
                        noiseChunk.m_209191_(y, (double)yInCell / (double)cellHeight);
                        lastCellY = cellY;
                        WorkResult res = (WorkResult)results.get((yTemp - yMin) / this.yStride);
                        for (XZPair curr : positions) {
                            noiseChunk.m_209230_(curr.x, curr.dX);
                            noiseChunk.m_209241_(curr.z, curr.dZ);
                            BlockState blockState = ((NoiseChunkAccessor)noiseChunk).invokeGetInterpolatedState();
                            if (blockState == null) {
                                blockState = noiseGeneratorSettings.f_64440_();
                            }
                            short colorId = (short)blockState.m_284242_(null, null).f_283805_;
                            short lastId = (short)curr.mutableLastValue.getAndSet(colorId);
                            if (colorId == 0 && lastId > 0) {
                                colorId = -lastId;
                            }
                            mutableBlockPos.m_122178_(curr.x, yTemp, curr.z);
                            this.sampler.expandRaw((BlockPos)mutableBlockPos, colorId, res);
                        }
                    }
                }
                noiseChunk.m_188804_();
            }
        }
        finally {
            noiseChunk.m_209248_();
        }
        return results;
    }

    @Override
    public long flags() {
        return 3L;
    }

    private record XZPair(int x, double dX, int z, double dZ, AtomicInteger mutableLastValue) {
    }
}

