/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.worker;

import caeruleusTait.world.preview.WorldPreviewConfig;
import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.backend.sampler.ChunkSampler;
import caeruleusTait.world.preview.backend.worker.SampleUtils;
import caeruleusTait.world.preview.backend.worker.WorkResult;
import caeruleusTait.world.preview.backend.worker.WorkUnit;
import caeruleusTait.world.preview.mixin.NoiseChunkAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;

public class HeightmapWorkUnit
extends WorkUnit {
    private final ChunkSampler sampler;
    private final int numChunks;

    public HeightmapWorkUnit(ChunkSampler sampler, SampleUtils sampleUtils, ChunkPos chunkPos, int numChunks, PreviewData previewData) {
        super(sampleUtils, chunkPos, previewData, 0);
        this.sampler = sampler;
        this.numChunks = numChunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<WorkResult> doWork() {
        WorkResult res = new WorkResult(this, QuartPos.m_175400_((int)0), this.primarySection, new ArrayList<WorkResult.BlockResult>(this.numChunks * this.numChunks * 4 * 4), List.of());
        NoiseGeneratorSettings noiseGeneratorSettings = this.sampleUtils.noiseGeneratorSettings();
        WorldPreviewConfig config = this.workManager.config();
        if (noiseGeneratorSettings == null) {
            return List.of(res);
        }
        NoiseSettings noiseSettings = noiseGeneratorSettings.f_64439_();
        NoiseChunk noiseChunk = this.sampleUtils.getNoiseChunk(this.chunkPos, this.numChunks, false);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int cellWidth = noiseSettings.m_189213_();
        int cellHeight = noiseSettings.m_189212_();
        int minY = config.onlySampleInVisualRange ? config.heightmapMinY : noiseSettings.f_158688_();
        int maxY = config.onlySampleInVisualRange ? config.heightmapMaxY : minY + noiseSettings.f_64508_();
        int cellMinY = Mth.m_14042_((int)minY, (int)noiseSettings.m_189212_());
        int cellCountY = Mth.m_14042_((int)(maxY - minY), (int)noiseSettings.m_189212_());
        int cellOffsetY = config.onlySampleInVisualRange ? cellMinY - Mth.m_14042_((int)noiseSettings.f_158688_(), (int)noiseSettings.m_189212_()) : 0;
        int minBlockX = this.chunkPos.m_45604_();
        int minBlockZ = this.chunkPos.m_45605_();
        int cellCountXZ = 16 * this.numChunks / cellWidth;
        int cellStrideXZ = Math.max(1, this.sampler.blockStride() / cellWidth);
        int todoArraySize = Math.max(1, cellWidth / this.sampler.blockStride()) * Math.max(1, cellWidth / this.sampler.blockStride());
        Predicate predicate = Heightmap.Types.OCEAN_FLOOR_WG.m_64299_();
        noiseChunk.m_188791_();
        try {
            for (int cellX = 0; cellX < cellCountXZ && !this.isCanceled(); cellX += cellStrideXZ) {
                noiseChunk.m_188749_(cellX);
                for (int cellZ = 0; cellZ < cellCountXZ && !this.isCanceled(); cellZ += cellStrideXZ) {
                    ArrayList<XZPair> positions = new ArrayList<XZPair>(todoArraySize);
                    for (int xInCell = 0; xInCell < cellWidth; xInCell += this.sampler.blockStride()) {
                        for (int zInCell = 0; zInCell < cellWidth; zInCell += this.sampler.blockStride()) {
                            int x = minBlockX + cellX * cellWidth + xInCell;
                            int z = minBlockZ + cellZ * cellWidth + zInCell;
                            positions.add(new XZPair(x, (double)xInCell / (double)cellWidth, z, (double)zInCell / (double)cellWidth));
                        }
                    }
                    for (int cellY = cellCountY - 1; cellY >= 0 && !positions.isEmpty() && !this.isCanceled(); --cellY) {
                        noiseChunk.m_188810_(cellY + cellOffsetY, cellZ);
                        for (int yInCell = cellHeight - 1; yInCell >= 0 && !positions.isEmpty(); --yInCell) {
                            int y = (cellMinY + cellY) * cellHeight + yInCell;
                            noiseChunk.m_209191_(y, (double)yInCell / (double)cellHeight);
                            for (int idx = 0; idx < positions.size(); ++idx) {
                                XZPair curr = (XZPair)positions.get(idx);
                                noiseChunk.m_209230_(curr.x, curr.dX);
                                noiseChunk.m_209241_(curr.z, curr.dZ);
                                BlockState blockState = ((NoiseChunkAccessor)noiseChunk).invokeGetInterpolatedState();
                                if (blockState == null) {
                                    blockState = noiseGeneratorSettings.f_64440_();
                                }
                                if (!predicate.test(blockState)) continue;
                                mutableBlockPos.m_122178_(curr.x, 0, curr.z);
                                this.sampler.expandRaw((BlockPos)mutableBlockPos, (short)(y + 1), res);
                                positions.remove(idx--);
                            }
                        }
                    }
                }
                noiseChunk.m_188804_();
            }
        }
        finally {
            noiseChunk.m_209248_();
        }
        return List.of(res);
    }

    @Override
    public long flags() {
        return 2L;
    }

    private record XZPair(int x, double dX, int z, double dZ) {
    }
}

