/*
 * Decompiled with CFR 0.152.
 */
package com.tom.stockbridge.block.entity;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagingRequest;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.LogisticsManager;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.tom.stockbridge.block.entity.AbstractStockBridgeBlockEntity;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.joml.Math;

public class BridgeBehaviour
extends LogisticallyLinkedBehaviour {
    public String recipeAddress = "";

    public BridgeBehaviour(SmartBlockEntity be, boolean global) {
        super(be, global);
    }

    public InventorySummary getSummary(@Nullable IdentifiedInventory ignoredHandler) {
        SmartBlockEntity smartBlockEntity = this.blockEntity;
        if (smartBlockEntity instanceof AbstractStockBridgeBlockEntity) {
            AbstractStockBridgeBlockEntity plbe = (AbstractStockBridgeBlockEntity)smartBlockEntity;
            if (ignoredHandler == null || !plbe.getInvId().equals((Object)ignoredHandler)) {
                return plbe.fetchSummaryFromPackager();
            }
        }
        return InventorySummary.EMPTY;
    }

    public Pair<PackagerBlockEntity, PackagingRequest> processRequest(ItemStack stack, int amount, String address, int linkIndex, MutableBoolean finalLink, int orderId, @Nullable PackageOrderWithCrafts context, @Nullable IdentifiedInventory ignoredHandler) {
        SmartBlockEntity smartBlockEntity = this.blockEntity;
        if (smartBlockEntity instanceof AbstractStockBridgeBlockEntity) {
            AbstractStockBridgeBlockEntity plbe = (AbstractStockBridgeBlockEntity)smartBlockEntity;
            if (ignoredHandler == null || !plbe.getInvId().equals((Object)ignoredHandler)) {
                return plbe.processRequest(stack, amount, address, linkIndex, finalLink, orderId, context);
            }
        }
        return null;
    }

    public void initialize() {
        super.initialize();
        if (this.getWorld().f_46443_) {
            return;
        }
        SmartBlockEntity smartBlockEntity = this.blockEntity;
        if (smartBlockEntity instanceof AbstractStockBridgeBlockEntity) {
            AbstractStockBridgeBlockEntity plbe = (AbstractStockBridgeBlockEntity)smartBlockEntity;
            Create.LOGISTICS.linkAdded(this.freqId, this.getGlobalPos(), plbe.placedBy);
        }
    }

    private GlobalPos getGlobalPos() {
        return GlobalPos.m_122643_((ResourceKey)this.getWorld().m_46472_(), (BlockPos)this.getPos());
    }

    public int requestItem(ItemStack stack, int demand) {
        SmartBlockEntity smartBlockEntity = this.blockEntity;
        if (smartBlockEntity instanceof AbstractStockBridgeBlockEntity) {
            AbstractStockBridgeBlockEntity plbe = (AbstractStockBridgeBlockEntity)smartBlockEntity;
            IdentifiedInventory id = plbe.getInvId();
            int availableOnNetwork = LogisticsManager.getStockOf((UUID)this.freqId, (ItemStack)stack, (IdentifiedInventory)id);
            if (availableOnNetwork == 0) {
                return 0;
            }
            int maxStackSize = stack.m_41741_();
            int amountToOrder = Math.clamp((int)demand, (int)0, (int)(maxStackSize * 9));
            BigItemStack orderedItem = new BigItemStack(stack, Math.min((int)amountToOrder, (int)availableOnNetwork));
            PackageOrderWithCrafts order = PackageOrderWithCrafts.simple(List.of(orderedItem));
            if (!LogisticsManager.broadcastPackageRequest((UUID)this.freqId, (LogisticallyLinkedBehaviour.RequestType)LogisticallyLinkedBehaviour.RequestType.RESTOCK, (PackageOrderWithCrafts)order, (IdentifiedInventory)id, (String)this.recipeAddress)) {
                return 0;
            }
            return amountToOrder;
        }
        return 0;
    }

    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        tag.m_128359_("address", this.recipeAddress);
    }

    public void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128359_("address", this.recipeAddress);
    }

    public void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.recipeAddress = tag.m_128461_("address");
    }

    public InventorySummary getItems() {
        SmartBlockEntity smartBlockEntity = this.blockEntity;
        if (smartBlockEntity instanceof AbstractStockBridgeBlockEntity) {
            AbstractStockBridgeBlockEntity plbe = (AbstractStockBridgeBlockEntity)smartBlockEntity;
            IdentifiedInventory id = plbe.getInvId();
            InventorySummary summaryOfLinks = new InventorySummary();
            LogisticallyLinkedBehaviour.getAllPresent((UUID)this.freqId, (boolean)false).forEach(link -> {
                InventorySummary summary = link.getSummary(id);
                if (summary != InventorySummary.EMPTY) {
                    ++summaryOfLinks.contributingLinks;
                }
                summaryOfLinks.add(summary);
            });
            return summaryOfLinks;
        }
        return InventorySummary.EMPTY;
    }
}

