/*
 * Decompiled with CFR 0.152.
 */
package com.tom.stockbridge.ae.util;

import appeng.menu.AEBaseMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import com.google.common.base.Preconditions;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class AEMenuTypeBuilder<M extends AEBaseMenu, I> {
    @Nullable
    private ResourceLocation id;
    private final Class<I> hostInterface;
    private final MenuFactory<M, I> factory;
    private Function<I, Component> menuTitleStrategy = this::getDefaultMenuTitle;
    @Nullable
    private InitialDataSerializer<I> initialDataSerializer;
    @Nullable
    private InitialDataDeserializer<M, I> initialDataDeserializer;
    private MenuType<M> menuType;

    private AEMenuTypeBuilder(Class<I> hostInterface, TypedMenuFactory<M, I> typedFactory) {
        this.hostInterface = hostInterface;
        this.factory = (containerId, playerInv, accessObj) -> (AEBaseMenu)typedFactory.create(this.menuType, containerId, playerInv, accessObj);
    }

    private AEMenuTypeBuilder(Class<I> hostInterface, MenuFactory<M, I> factory) {
        this.hostInterface = hostInterface;
        this.factory = factory;
    }

    public static <C extends AEBaseMenu, I> AEMenuTypeBuilder<C, I> create(MenuFactory<C, I> factory, Class<I> hostInterface) {
        return new AEMenuTypeBuilder<C, I>(hostInterface, factory);
    }

    public static <C extends AEBaseMenu, I> AEMenuTypeBuilder<C, I> create(TypedMenuFactory<C, I> factory, Class<I> hostInterface) {
        return new AEMenuTypeBuilder<C, I>(hostInterface, factory);
    }

    public AEMenuTypeBuilder<M, I> withMenuTitle(Function<I, Component> menuTitleStrategy) {
        this.menuTitleStrategy = menuTitleStrategy;
        return this;
    }

    public AEMenuTypeBuilder<M, I> withInitialData(InitialDataSerializer<I> initialDataSerializer, InitialDataDeserializer<M, I> initialDataDeserializer) {
        this.initialDataSerializer = initialDataSerializer;
        this.initialDataDeserializer = initialDataDeserializer;
        return this;
    }

    private M fromNetwork(int containerId, Inventory inv, FriendlyByteBuf packetBuf) {
        MenuLocator locator = MenuLocators.readFromPacket((FriendlyByteBuf)packetBuf);
        Object host = locator.locate(inv.f_35978_, this.hostInterface);
        if (host == null) {
            ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
            if (connection != null) {
                connection.m_104955_((Packet)new ServerboundContainerClosePacket(containerId));
            }
            throw new IllegalStateException("Couldn't find menu host at " + locator + " for " + this.id + " on client. Closing menu.");
        }
        AEBaseMenu menu = (AEBaseMenu)this.factory.create(containerId, inv, host);
        menu.setReturnedFromSubScreen(packetBuf.readBoolean());
        if (this.initialDataDeserializer != null) {
            this.initialDataDeserializer.deserializeInitialData(host, menu, packetBuf);
        }
        return (M)menu;
    }

    private boolean open(Player player, MenuLocator locator, boolean fromSubMenu) {
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        Object accessInterface = locator.locate(player, this.hostInterface);
        if (accessInterface == null) {
            return false;
        }
        Component title = this.menuTitleStrategy.apply(accessInterface);
        SimpleMenuProvider menu = new SimpleMenuProvider((wnd, p, pl) -> {
            AEBaseMenu m = (AEBaseMenu)this.factory.create(wnd, p, accessInterface);
            m.setLocator(locator);
            return m;
        }, title);
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)menu, buffer -> {
            MenuLocators.writeToPacket((FriendlyByteBuf)buffer, (MenuLocator)locator);
            buffer.writeBoolean(fromSubMenu);
            if (this.initialDataSerializer != null) {
                this.initialDataSerializer.serializeInitialData(accessInterface, (FriendlyByteBuf)buffer);
            }
        });
        return true;
    }

    public MenuType<M> build() {
        Preconditions.checkState((this.menuType == null ? 1 : 0) != 0, (Object)"build was already called");
        this.menuType = IForgeMenuType.create(this::fromNetwork);
        MenuOpener.addOpener(this.menuType, this::open);
        return this.menuType;
    }

    private Component getDefaultMenuTitle(I accessInterface) {
        Nameable nameable;
        if (accessInterface instanceof Nameable && (nameable = (Nameable)accessInterface).m_8077_()) {
            return nameable.m_7770_();
        }
        return Component.m_237119_();
    }

    @FunctionalInterface
    public static interface TypedMenuFactory<C extends AbstractContainerMenu, I> {
        public C create(MenuType<C> var1, int var2, Inventory var3, I var4);
    }

    @FunctionalInterface
    public static interface MenuFactory<C, I> {
        public C create(int var1, Inventory var2, I var3);
    }

    @FunctionalInterface
    public static interface InitialDataSerializer<I> {
        public void serializeInitialData(I var1, FriendlyByteBuf var2);
    }

    @FunctionalInterface
    public static interface InitialDataDeserializer<C, I> {
        public void deserializeInitialData(I var1, C var2, FriendlyByteBuf var3);
    }
}

