/*
 * Decompiled with CFR 0.152.
 */
package com.tom.stockbridge.ae;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.tom.stockbridge.Registration;
import com.tom.stockbridge.ae.AERemoteItemKey;
import java.util.concurrent.ExecutionException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class VirtualPattern
implements IPatternDetails {
    private static final LoadingCache<AEItemKey, VirtualPattern> PATTERN_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(VirtualPattern::new));
    private final IPatternDetails.IInput[] input;
    private final GenericStack[] output;
    private final AEItemKey item;
    private final AEItemKey result;

    private VirtualPattern(AEItemKey result) {
        this.result = result;
        this.output = new GenericStack[]{new GenericStack((AEKey)result, 1L)};
        this.input = new IPatternDetails.IInput[]{new Input(result)};
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("result", (Tag)result.toTag());
        this.item = AEItemKey.of((ItemLike)Registration.REQUEST_ITEM.m_5456_(), (CompoundTag)tag);
    }

    public static VirtualPattern of(AEItemKey result) {
        try {
            return (VirtualPattern)PATTERN_CACHE.get((Object)result);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static VirtualPattern fromTag(CompoundTag tag) {
        AEItemKey result = AEItemKey.fromTag((CompoundTag)tag.m_128469_("result"));
        if (result == null) {
            return null;
        }
        return VirtualPattern.of(result);
    }

    public AEItemKey getDefinition() {
        return this.item;
    }

    public IPatternDetails.IInput[] getInputs() {
        return this.input;
    }

    public GenericStack[] getOutputs() {
        return this.output;
    }

    public AEItemKey getResult() {
        return this.result;
    }

    private static class Input
    implements IPatternDetails.IInput {
        private GenericStack[] template;

        public Input(AEItemKey item) {
            this.template = new GenericStack[]{new GenericStack((AEKey)AERemoteItemKey.of((ItemLike)item.getItem(), item.getTag()), 1L)};
        }

        public GenericStack[] getPossibleInputs() {
            return this.template;
        }

        public long getMultiplier() {
            return 1L;
        }

        public boolean isValid(AEKey input, Level p1) {
            return input.matches(this.template[0]);
        }

        @Nullable
        public AEKey getRemainingKey(AEKey p0) {
            return null;
        }
    }
}

