/*
 * Decompiled with CFR 0.152.
 */
package com.tom.stockbridge.ae;

import appeng.api.client.AEKeyRenderHandler;
import appeng.api.client.AEKeyRendering;
import appeng.api.stacks.AEKeyType;
import appeng.init.client.InitScreens;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import com.simibubi.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import com.simibubi.create.infrastructure.ponder.AllCreatePonderTags;
import com.simibubi.create.infrastructure.ponder.scenes.highLogistics.FrogAndConveyorScenes;
import com.simibubi.create.infrastructure.ponder.scenes.highLogistics.PonderHilo;
import com.tom.stockbridge.ae.AERegistration;
import com.tom.stockbridge.ae.AERemoteItemKey;
import com.tom.stockbridge.ae.RemoteItemKeyType;
import com.tom.stockbridge.ae.menu.AEStockBridgeMenu;
import com.tom.stockbridge.ae.menu.AEStockBridgeScreen;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.List;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.registration.PonderSceneRegistrationHelper;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AEClientRegistration {
    private static final Logger LOG = LoggerFactory.getLogger(AEClientRegistration.class);

    public static void register() {
        AEKeyRendering.register((AEKeyType)RemoteItemKeyType.INSTANCE, AERemoteItemKey.class, (AEKeyRenderHandler)new AEKeyRenderHandler<AERemoteItemKey>(){
            private final Component REMOTE_INFO = Component.m_237115_((String)"tooltip.stockbridge.remote_item");

            public void drawInGui(Minecraft minecraft, GuiGraphics guiGraphics, int x, int y, AERemoteItemKey stack) {
                PoseStack poseStack = guiGraphics.m_280168_();
                poseStack.m_85836_();
                ItemStack displayStack = stack.getReadOnlyStack();
                guiGraphics.m_280480_(displayStack, x, y);
                guiGraphics.m_280302_(minecraft.f_91062_, displayStack, x, y, "");
                poseStack.m_252880_((float)x + 10.5f, (float)y, 200.0f);
                poseStack.m_85841_(0.33f, 0.33f, 1.0f);
                guiGraphics.m_280398_(ResourceLocation.m_214293_((String)"createstockbridge", (String)"textures/gui/remote_item.png"), 0, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                poseStack.m_85849_();
            }

            public void drawOnBlockFace(PoseStack poseStack, MultiBufferSource buffers, AERemoteItemKey what, float scale, int combinedLight, Level level) {
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 0.0f, 0.01f);
                poseStack.m_252931_(new Matrix4f().scale(scale, scale, 0.001f));
                poseStack.m_85850_().m_252943_().rotateX(-0.7853982f);
                Minecraft.m_91087_().m_91291_().m_269128_(what.getReadOnlyStack(), ItemDisplayContext.GUI, combinedLight, OverlayTexture.f_118083_, poseStack, buffers, level, 0);
                poseStack.m_85849_();
            }

            public Component getDisplayName(AERemoteItemKey stack) {
                return stack.getDisplayName();
            }

            public List<Component> getTooltip(AERemoteItemKey stack) {
                try {
                    List l = stack.getReadOnlyStack().m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
                    l.add(this.REMOTE_INFO);
                    return l;
                }
                catch (Exception e) {
                    LOG.error("Getting the tooltip of item {} crashed!", (Object)stack.getId(), (Object)e);
                    return List.of(stack.getDisplayName(), Component.m_237113_((String)stack.getId().toString()), Component.m_237113_((String)"GETTING TOOLTIP CRASHED").m_130940_(ChatFormatting.RED));
                }
            }
        });
        InitScreens.register(AEStockBridgeMenu.TYPE, AEStockBridgeScreen::new, (String)"/screens/csb_bridge.json");
    }

    public static void registerPonder(PonderSceneRegistrationHelper<BlockEntry<?>> HELPER) {
        HELPER.forComponents((Object[])new BlockEntry[]{AERegistration.BRIDGE_BLOCK}).addStoryBoard("ae_stockbridge", AEClientRegistration::stockbridge, new ResourceLocation[]{AllCreatePonderTags.HIGH_LOGISTICS});
    }

    public static void stockbridge(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        BlockPos ticker = util.grid().at(5, 1, 1);
        BlockPos bridge = util.grid().at(2, 1, 2);
        BlockPos conv1 = util.grid().at(5, 4, 1);
        BlockPos conv2 = util.grid().at(5, 4, 6);
        scene.title("ae_stockbridge", "Connecting the Stock System to AE");
        scene.configureBasePlate(0, 0, 7);
        scene.scaleSceneView(0.75f);
        scene.setSceneOffsetY(-1.0f);
        scene.showBasePlate();
        ElementLink bridgeBlock = scene.world().showIndependentSection(util.select().position(2, 1, 2), Direction.DOWN);
        scene.world().moveSection(bridgeBlock, util.vector().of(0.0, 0.0, 0.0), 0);
        scene.idle(10);
        scene.overlay().showText(70).pointAt(util.vector().of(2.0, 2.0, 2.0)).placeNearTarget().attachKeyFrame().text("AE Stock Bridge links the Create Stock system with AE");
        scene.idle(70);
        scene.world().hideIndependentSection(bridgeBlock, Direction.UP);
        scene.idle(10);
        ElementLink bindT = scene.world().showIndependentSection(util.select().position(ticker), Direction.DOWN);
        scene.world().moveSection(bindT, util.vector().of(-2.0, 0.0, 2.0), 0);
        scene.idle(10);
        scene.overlay().showText(60).pointAt(util.vector().of(3.0, 2.0, 3.0)).placeNearTarget().attachKeyFrame().text("Right-Click to bind to the stock network before placing");
        scene.idle(10);
        scene.overlay().showControls(util.vector().of(3.0, 2.0, 3.0), Pointing.UP, 70).rightClick().withItem(AERegistration.BRIDGE_BLOCK.asStack());
        scene.idle(5);
        scene.overlay().showOutline(PonderPalette.BLUE, (Object)util.grid().at(3, 1, 3), util.select().position(3, 1, 3), 70);
        scene.idle(75);
        scene.world().hideIndependentSection(bindT, Direction.UP);
        scene.idle(10);
        bridgeBlock = scene.world().showIndependentSection(util.select().position(2, 1, 2), Direction.DOWN);
        scene.world().moveSection(bridgeBlock, util.vector().of(0.0, 0.0, 0.0), 0);
        scene.idle(10);
        ElementLink ae = scene.world().showIndependentSection(util.select().fromTo(1, 1, 2, 1, 2, 4), Direction.DOWN);
        scene.world().moveSection(ae, util.vector().of(0.0, 0.0, 0.0), 0);
        scene.idle(10);
        ElementLink stock = scene.world().showIndependentSection(util.select().fromTo(3, 1, 1, 6, 4, 6), Direction.DOWN);
        scene.world().moveSection(stock, util.vector().of(0.0, 0.0, 0.0), 0);
        scene.idle(10);
        scene.overlay().showText(70).pointAt(util.vector().of(2.0, 2.0, 2.0)).placeNearTarget().attachKeyFrame().text("Set the AE Stock Bridge address to match the Frogport address");
        scene.idle(60);
        scene.overlay().showText(40).colored(PonderPalette.BLUE).text("AE").pointAt(util.vector().topOf(bridge)).placeNearTarget();
        scene.overlay().showText(40).colored(PonderPalette.BLUE).text("AE").pointAt(util.vector().topOf(util.grid().at(3, 2, 2))).placeNearTarget();
        scene.idle(20);
        scene.overlay().showText(70).pointAt(util.vector().of(1.0, 2.0, 3.0)).placeNearTarget().attachKeyFrame().text("AE can request items by 'crafting'");
        scene.idle(10);
        PonderHilo.linkEffect((CreateSceneBuilder)scene, (BlockPos)bridge);
        scene.idle(20);
        ItemStack box = PackageStyles.getDefaultBox().m_41777_();
        PackageItem.addAddress((ItemStack)box, (String)"AE");
        scene.world().modifyBlockEntity(conv2, ChainConveyorBlockEntity.class, be -> {
            be.addLoopingPackage(new ChainConveyorPackage(0.0f, box));
            FrogAndConveyorScenes.boxTransfer((BlockPos)conv1, (BlockPos)conv2, (ChainConveyorBlockEntity)be);
        });
        scene.idle(60);
        PonderHilo.packagerUnpack((CreateSceneBuilder)scene, (BlockPos)util.grid().at(3, 1, 2), (ItemStack)box);
        scene.idle(20);
        scene.overlay().showText(70).pointAt(util.vector().of(5.0, 2.0, 1.0)).independent(0).attachKeyFrame().text("Create can request stored items from AE");
        ItemStack box2 = PackageStyles.getDefaultBox().m_41777_();
        PackageItem.addAddress((ItemStack)box2, (String)"Vault");
        scene.idle(10);
        PonderHilo.linkEffect((CreateSceneBuilder)scene, (BlockPos)ticker);
        PonderHilo.linkEffect((CreateSceneBuilder)scene, (BlockPos)bridge);
        scene.idle(20);
        PonderHilo.packagerCreate((CreateSceneBuilder)scene, (BlockPos)util.grid().at(3, 1, 2), (ItemStack)box2);
        scene.idle(30);
        scene.world().modifyBlockEntity(util.grid().at(3, 1, 2), PackagerBlockEntity.class, be -> {
            be.heldBox = ItemStack.f_41583_;
        });
        scene.world().modifyBlockEntity(util.grid().at(3, 2, 2), FrogportBlockEntity.class, be -> be.startAnimation(box2, true));
        scene.idle(100);
        scene.world().modifyBlockEntity(conv1, ChainConveyorBlockEntity.class, be -> FrogAndConveyorScenes.boxTransfer((BlockPos)conv2, (BlockPos)conv1, (ChainConveyorBlockEntity)be));
        scene.idle(110);
        scene.world().modifyBlockEntity(conv2, ChainConveyorBlockEntity.class, be -> {
            if (!be.getLoopingPackages().isEmpty()) {
                be.getLoopingPackages().remove(0);
            }
        });
    }
}

