/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.network.message.CPacketRequestNBT;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlockEntityUtil {
    public static void sendUpdatePacket(BlockEntity tileEntity) {
        ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)tileEntity);
        if (packet != null) {
            BlockEntityUtil.sendUpdatePacket(tileEntity.m_58904_(), tileEntity.m_58899_(), packet);
        } else {
            LightmansCurrency.LogError(tileEntity.getClass().getName() + ".getUpdatePacket() returned null!");
        }
    }

    public static void sendUpdatePacket(BlockEntity tileEntity, CompoundTag compound) {
        ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)tileEntity, be -> compound);
        BlockEntityUtil.sendUpdatePacket(tileEntity.m_58904_(), tileEntity.m_58899_(), packet);
    }

    private static void sendUpdatePacket(Level world, BlockPos pos, ClientboundBlockEntityDataPacket packet) {
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            List players = server.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false);
            players.forEach(player -> player.f_8906_.m_9829_((Packet)packet));
        } else {
            LightmansCurrency.LogWarning("Cannot send Tile Entity Update Packet from a client.");
        }
    }

    public static void requestUpdatePacket(BlockEntity be) {
        if (be != null) {
            BlockEntityUtil.requestUpdatePacket(be.m_58904_(), be.m_58899_());
        }
    }

    public static void requestUpdatePacket(Level level, BlockPos pos) {
        if (level.f_46443_) {
            new CPacketRequestNBT(pos).send();
        }
    }
}

