/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.paygate;

import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class CPacketCollectTicketStubs
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketCollectTicketStubs> HANDLER = new H();
    private final long traderID;

    public CPacketCollectTicketStubs(long traderID) {
        this.traderID = traderID;
    }

    @Override
    public void encode(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeLong(this.traderID);
    }

    private static class H
    extends CustomPacket.Handler<CPacketCollectTicketStubs> {
        private H() {
        }

        @Override
        @Nonnull
        public CPacketCollectTicketStubs decode(@Nonnull FriendlyByteBuf buffer) {
            return new CPacketCollectTicketStubs(buffer.readLong());
        }

        @Override
        protected void handle(@Nonnull CPacketCollectTicketStubs message, @Nullable ServerPlayer sender) {
            TraderData traderData = TraderAPI.API.GetTrader(false, message.traderID);
            if (traderData instanceof PaygateTraderData) {
                PaygateTraderData paygate = (PaygateTraderData)traderData;
                if (sender != null) {
                    paygate.collectTicketStubs((Player)sender);
                }
            }
        }
    }
}

