/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.data;

import io.github.lightman314.lightmanscurrency.LCRegistries;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomData;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomDataType;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.data.ClientCustomDataCache;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class SPacketSyncCustomData
extends ServerToClientPacket {
    public static final CustomPacket.Handler<SPacketSyncCustomData> HANDLER = new H();
    private final ResourceLocation dataType;
    private final LazyPacketData data;

    public SPacketSyncCustomData(@Nonnull CustomDataType<?> type, @Nonnull LazyPacketData data) {
        this(LCRegistries.CUSTOM_DATA.getKey(type), data);
    }

    protected SPacketSyncCustomData(@Nonnull ResourceLocation dataType, @Nonnull LazyPacketData data) {
        this.dataType = Objects.requireNonNull(dataType, "CustomDataType");
        this.data = data;
    }

    @Override
    public void encode(@Nonnull FriendlyByteBuf buffer) {
        buffer.m_130070_(this.dataType.toString());
        this.data.encode(buffer);
    }

    private static class H
    extends CustomPacket.Handler<SPacketSyncCustomData> {
        private H() {
        }

        @Override
        @Nonnull
        public SPacketSyncCustomData decode(@Nonnull FriendlyByteBuf buffer) {
            return new SPacketSyncCustomData(VersionUtil.parseResource(buffer.m_130277_()), LazyPacketData.decode(buffer));
        }

        @Override
        protected void handle(@Nonnull SPacketSyncCustomData message, @Nullable ServerPlayer sender) {
            CustomDataType type = (CustomDataType)LCRegistries.CUSTOM_DATA.getValue(message.dataType);
            if (type == null) {
                LightmansCurrency.LogWarning("Recieved sync packet for custom data of type '" + message.dataType + "' from the server, but no such data is registered on the client!");
                return;
            }
            Object data = ClientCustomDataCache.getData(type);
            if (data == null) {
                LightmansCurrency.LogError("Error getting client copy of the '" + message.dataType + "' custom data!");
                return;
            }
            ((CustomData)data).receivePacket(message.data);
        }
    }
}

