/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.mixin.compat.supplementaries;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenu;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.inventories.RedMerchantMenu;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MerchantContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraftforge.items.ItemHandlerHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RedMerchantMenu.class})
public abstract class RedMerchantMenuMixin {
    @Unique
    protected RedMerchantMenu lightmanscurrency$self() {
        return (RedMerchantMenu)this;
    }

    @Accessor(value="trader", remap=false)
    public abstract Merchant getTrader();

    @Accessor(value="tradeContainer", remap=false)
    public abstract MerchantContainer getTradeContainer();

    @Unique
    public Player lightmanscurrency$getPlayer() {
        Merchant m = this.getTrader();
        if (m != null) {
            return m.m_7962_();
        }
        return null;
    }

    @Inject(at={@At(value="HEAD")}, method={"tryMoveItems"}, remap=false)
    private void tryMoveItemsEarly(int trade, CallbackInfo info) {
        try {
            RedMerchantMenu self = this.lightmanscurrency$self();
            if (trade >= 0 && trade < self.getOffers().size()) {
                this.lightmanscurrency$EjectMoneyIntoWallet(this.lightmanscurrency$getPlayer(), false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tryMoveItems"}, remap=false)
    private void tryMoveItems(int trade, CallbackInfo info) {
        try {
            MerchantOffer offer;
            MerchantContainer tradeContainer;
            RedMerchantMenu self = this.lightmanscurrency$self();
            if (trade >= 0 && trade < self.getOffers().size() && ((tradeContainer = this.getTradeContainer()).m_8020_(0).m_41619_() || tradeContainer.m_8020_(1).m_41619_()) && (CoinAPI.API.IsCoin((offer = (MerchantOffer)self.getOffers().get(trade)).m_45358_(), false) || CoinAPI.API.IsCoin(offer.m_45364_(), false))) {
                ItemStack coinA = offer.m_45358_().m_41777_();
                ItemStack coinB = offer.m_45364_().m_41777_();
                ChainData chainA = CoinAPI.API.ChainDataOfCoin(coinA);
                ChainData chainB = CoinAPI.API.ChainDataOfCoin(coinB);
                long valueA = chainA != null && tradeContainer.m_8020_(0).m_41619_() ? chainA.getCoreValue(coinA) : 0L;
                long valueB = chainB != null && tradeContainer.m_8020_(1).m_41619_() ? chainB.getCoreValue(coinB) : 0L;
                Player player = this.lightmanscurrency$getPlayer();
                MoneyView availableFunds = WalletCapability.getWalletMoney((Entity)player);
                MoneyValue fundsToExtractA = MoneyValue.empty();
                MoneyValue fundsToExtractB = MoneyValue.empty();
                int coinACount = valueA > 0L ? coinA.m_41613_() : 0;
                int coinBCount = valueB > 0L ? coinB.m_41613_() : 0;
                int coinAMaxCount = valueA > 0L ? coinA.m_41741_() : 0;
                int coinBMaxCount = valueB > 0L ? coinB.m_41741_() : 0;
                int coinToAddA = 0;
                int coinToAddB = 0;
                boolean keepLooping = true;
                while (keepLooping) {
                    int tempC2AA = coinAMaxCount > coinToAddA ? MathUtil.clamp(coinToAddA + coinACount, 0, coinAMaxCount) : coinToAddA;
                    int tempC2AB = coinBMaxCount > coinToAddB ? MathUtil.clamp(coinToAddB + coinBCount, 0, coinBMaxCount) : coinToAddB;
                    coinA.m_41764_(tempC2AA);
                    coinB.m_41764_(tempC2AB);
                    if (!RedMerchantMenuMixin.lightmanscurrency$containsValueFor(availableFunds, chainA, valueA, tempC2AA, chainB, valueB, tempC2AB)) {
                        keepLooping = false;
                        continue;
                    }
                    fundsToExtractA = CoinValue.fromNumber(chainA.chain, valueA * (long)tempC2AA);
                    if (chainB != null) {
                        fundsToExtractB = CoinValue.fromNumber(chainB.chain, valueB * (long)tempC2AB);
                    }
                    coinToAddA = tempC2AA;
                    coinToAddB = tempC2AB;
                    if (coinToAddA < coinAMaxCount || coinToAddB < coinBMaxCount) continue;
                    keepLooping = false;
                }
                if (!(coinToAddA <= 0 && coinToAddB <= 0 || fundsToExtractA.isEmpty())) {
                    IMoneyHolder handler;
                    coinA.m_41764_(coinToAddA);
                    coinB.m_41764_(coinToAddB);
                    if (fundsToExtractA.sameType(fundsToExtractB)) {
                        fundsToExtractA = fundsToExtractA.addValue(fundsToExtractB);
                        fundsToExtractB = MoneyValue.empty();
                    }
                    if ((handler = MoneyAPI.API.GetPlayersMoneyHandler(player)).extractMoney(fundsToExtractA, true).isEmpty() && handler.extractMoney(fundsToExtractB, true).isEmpty()) {
                        handler.extractMoney(fundsToExtractA, false);
                        handler.extractMoney(fundsToExtractB, false);
                        if (coinToAddA > 0) {
                            tradeContainer.m_6836_(0, coinA.m_41777_());
                        }
                        if (coinToAddB > 0) {
                            tradeContainer.m_6836_(1, coinB.m_41777_());
                        }
                        LightmansCurrency.LogDebug("Moved " + fundsToExtractA.getString() + " & " + fundsToExtractB.getString() + " worth of coins into the Merchant Menu!");
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Unique
    private static boolean lightmanscurrency$containsValueFor(@Nonnull MoneyView query, @Nonnull ChainData chainA, long valueA, int countA, @Nullable ChainData chainB, long valueB, int countB) {
        MoneyValue cvB;
        MoneyValue cvA = CoinValue.fromNumber(chainA.chain, valueA * (long)countA);
        MoneyValue moneyValue = cvB = chainB == null ? MoneyValue.empty() : CoinValue.fromNumber(chainB.chain, valueB * (long)countB);
        if (cvA.sameType(cvB)) {
            cvA = cvA.addValue(cvB);
            cvB = MoneyValue.empty();
        }
        return query.containsValue(cvA) && query.containsValue(cvB);
    }

    @Inject(at={@At(value="HEAD")}, method={"removed"})
    private void removed(Player player, CallbackInfo info) {
        if (this.lightmanscurrency$isPlayerAliveAndValid(player)) {
            this.lightmanscurrency$EjectMoneyIntoWallet(player, true);
        }
    }

    @Unique
    protected boolean lightmanscurrency$isPlayerAliveAndValid(Player player) {
        if (player.m_6084_()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                return !sp.m_9232_();
            }
            return true;
        }
        return false;
    }

    @Unique
    private void lightmanscurrency$EjectMoneyIntoWallet(Player player, boolean noUpdate) {
        ItemStack leftovers;
        ItemStack wallet;
        IWalletHandler walletHandler;
        MerchantContainer tradeContainer = this.getTradeContainer();
        ItemStack item = tradeContainer.m_8020_(0);
        if (!item.m_41619_() && CoinAPI.API.IsCoin(item, false) && (walletHandler = WalletCapability.lazyGetWalletHandler((Entity)player)) != null && WalletItem.isWallet(wallet = walletHandler.getWallet())) {
            leftovers = WalletItem.PickupCoin(wallet, item);
            WalletMenu.OnWalletUpdated((Entity)player);
            if (!leftovers.m_41619_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)leftovers);
            }
            if (noUpdate) {
                tradeContainer.m_8016_(0);
            } else {
                tradeContainer.m_6836_(0, ItemStack.f_41583_);
            }
        }
        if (!(item = tradeContainer.m_8020_(1)).m_41619_() && CoinAPI.API.IsCoin(item, false) && (walletHandler = WalletCapability.lazyGetWalletHandler((Entity)player)) != null && WalletItem.isWallet(wallet = walletHandler.getWallet())) {
            leftovers = WalletItem.PickupCoin(wallet, item);
            WalletMenu.OnWalletUpdated((Entity)player);
            if (!leftovers.m_41619_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)leftovers);
            }
            if (noUpdate) {
                tradeContainer.m_8016_(1);
            } else {
                tradeContainer.m_6836_(1, ItemStack.f_41583_);
            }
        }
    }
}

