/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.jeiplugin.misc;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ItemFilterScreen;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemFilterGhostIngredientHandler
implements IGhostIngredientHandler<ItemFilterScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(ItemFilterScreen screen, ITypedIngredient<I> ingredient, boolean doStart) {
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            return List.of(new FilterTarget(screen));
        }
        return List.of();
    }

    public void onComplete() {
    }

    private record FilterTarget<T>(ItemFilterScreen screen) implements IGhostIngredientHandler.Target<T>
    {
        public Rect2i getArea() {
            return new Rect2i(this.screen.getGuiLeft() + 8, this.screen.getGuiTop() + 102, 16, 16);
        }

        public void accept(T ingredient) {
            if (ingredient instanceof ItemStack) {
                ItemStack stack = (ItemStack)ingredient;
                this.screen.setFakeSlotItem(stack);
            }
        }
    }
}

