/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.impactor.money.client;

import io.github.lightman314.lightmanscurrency.api.money.input.templates.SimpleDisplayInput;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.integration.impactor.LCImpactorCompat;
import io.github.lightman314.lightmanscurrency.integration.impactor.money.ImpactorCurrencyType;
import io.github.lightman314.lightmanscurrency.integration.impactor.money.ImpactorMoneyValue;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.minecraft.network.chat.MutableComponent;

public class ImpactorMoneyInputHandler
extends SimpleDisplayInput {
    private final Currency currency;

    public ImpactorMoneyInputHandler(Currency currency) {
        this.currency = currency;
        String format = this.currency.format(BigDecimal.ZERO).toString();
        String[] split = format.split("0", 2);
        if (split.length == 1) {
            this.setPrefix(split[0]);
        } else {
            this.setPrefix(split[0]);
            this.setPostfix(split[1]);
        }
    }

    @Override
    @Nonnull
    protected MoneyValue getValueFromInput(double inputValue) {
        return ImpactorMoneyValue.of(this.currency, BigDecimal.valueOf(inputValue));
    }

    @Override
    protected double getTextFromDisplay(@Nonnull MoneyValue value) {
        if (value instanceof ImpactorMoneyValue) {
            ImpactorMoneyValue val = (ImpactorMoneyValue)value;
            return val.getValue().doubleValue();
        }
        return 0.0;
    }

    @Override
    protected int getRelevantDecimals() {
        return this.currency.decimals();
    }

    @Override
    @Nonnull
    public MutableComponent inputName() {
        return LCImpactorCompat.convertComponent(this.currency.singular());
    }

    @Override
    @Nonnull
    public String getUniqueName() {
        return MoneyValue.generateCustomUniqueName(ImpactorCurrencyType.TYPE, this.currency.key().toString());
    }
}

