/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.impactor.money;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValueParser;
import io.github.lightman314.lightmanscurrency.integration.impactor.LCImpactorCompat;
import io.github.lightman314.lightmanscurrency.integration.impactor.money.ImpactorMoneyValue;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.kyori.adventure.key.InvalidKeyException;
import net.kyori.adventure.key.Key;

public class ImpactorValueParser
extends MoneyValueParser {
    public static final MoneyValueParser INSTANCE = new ImpactorValueParser();
    public static final DynamicCommandExceptionType INVALID_KEY = new DynamicCommandExceptionType(xva$0 -> LCText.ARGUMENT_MONEY_VALUE_IMPACTOR_INVALID_KEY.get(xva$0));
    public static final DynamicCommandExceptionType INVALID_CURRENCY = new DynamicCommandExceptionType(xva$0 -> LCText.ARGUMENT_MONEY_VALUE_IMPACTOR_INVALID_KEY.get(xva$0));
    public static final DynamicCommandExceptionType INVALID_AMOUNT = new DynamicCommandExceptionType(xva$0 -> LCText.ARGUMENT_MONEY_VALUE_IMPACTOR_INVALID_AMOUNT.get(xva$0));
    public static final SimpleCommandExceptionType UNKNOWN_ERROR = new SimpleCommandExceptionType((Message)LCText.ARGUMENT_MONEY_VALUE_IMPACTOR_ERROR.get(new Object[0]));

    private ImpactorValueParser() {
        super("impactor");
    }

    @Override
    protected MoneyValue parseValueArgument(@Nonnull StringReader reader) throws CommandSyntaxException {
        try {
            String currencyType = ImpactorValueParser.readStringUntil(reader, ';');
            try {
                Key type = Key.key((String)currencyType, (char)':');
                Currency currency = LCImpactorCompat.getCurrency(type);
                if (currency == null) {
                    throw INVALID_CURRENCY.createWithContext((ImmutableStringReader)reader, (Object)currencyType);
                }
                String number = reader.getRemaining();
                try {
                    BigDecimal value = new BigDecimal(number);
                    int comparison = value.compareTo(BigDecimal.ZERO);
                    if (comparison == 0) {
                        throw NO_VALUE_EXCEPTION.createWithContext((ImmutableStringReader)reader);
                    }
                    if (comparison < 0) {
                        throw INVALID_AMOUNT.createWithContext((ImmutableStringReader)reader, (Object)number);
                    }
                    return ImpactorMoneyValue.of(currency, value);
                }
                catch (NumberFormatException e) {
                    throw INVALID_AMOUNT.createWithContext((ImmutableStringReader)reader, (Object)number);
                }
            }
            catch (InvalidKeyException e) {
                throw INVALID_KEY.createWithContext((ImmutableStringReader)reader, (Object)currencyType);
            }
        }
        catch (Exception e) {
            if (e instanceof CommandSyntaxException) {
                throw e;
            }
            throw UNKNOWN_ERROR.createWithContext((ImmutableStringReader)reader);
        }
    }

    @Override
    protected String writeValueArgument(@Nonnull MoneyValue value) {
        return "";
    }
}

